****************************************************************************
****************************************************************************
**                                                               
**  Mercury for TI-89 / TI-92 Plus
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated April 17, 2012
**                                      
****************************************************************************
****************************************************************************

*************************************** MASK (A1/A0) over (A2/A3)

MASK_LONG MACRO
        move.l  BUFFER_SIZE(a1),d0
        move.l  (a1)+,d1
        move.l  d0,d2
        or.l    d1,d2                   ; D2 = mask to black
        move.l  d2,d3
        or.l    BUFFER_SIZE(a0),d2
        or.l    (a0)+,d3
        eor.l   d0,d2
        eor.l   d1,d3
        move.l  d2,(a2)+
        move.l  d3,(a3)+
        ENDM

*************************************** SCROLL AND DRAW BACKGROUND

Scroll_Screen:
        tst.w   open_space(a5)
        blt.s   scroll_space
        bgt.s   stationary

*************************************** SCROLLING BOTH PLANES

        addq.w  #1,fg_x(a5)
        bsr     Scroll_FG_Left          ; foreground left 1
        btst    #0,fg_x+1(a5)
        beq.s   \sd                     ; if even pixel, skip background           
        addq.w  #1,bg_x(a5)             ; background left 1
        bsr     Scroll_BG_Left
\sd:    bra     Build_Main_Screen

*************************************** SCROLLING BACKGROUND ONLY

scroll_space:
        bclr    #3,fg_x+1(a5)           ; keep foreground x in 0..7
        addq.w  #1,fg_x(a5)             ; increment foreground x
        btst    #0,fg_x+1(a5)           ; if even pixel, don't scroll 
        beq.s   stationary              
        addq.w  #1,bg_x(a5)             ; background left 1
        bsr     Scroll_BG_Left

*************************************** NO SCROLLING

stationary:
        bsr     Build_Main_Screen       ; display screen
        tst.w   enemycount(a5)          ; if no enemies, back to normal
        bne.s   \gc
        clr.w   open_space(a5)
\gc:    rts

*************************************** BUILD MAIN SCREEN

Build_Main_Screen:
        move.l  backbuffer(a5),a1       ; A1 -> foreground
    IFD ti89
        move.w  screeny(a5),d0
        sub.w   #64,d0
        mulu    #BUFFER_WIDTH,d0
        add.w   d0,a1
    ENDIF
        lea     s(a5),a2
        lea     PLANE_SIZE(a2),a3
        lea     BUFFER_SIZE*2(a1),a0    ; A0 -> background

        moveq   #SCR_HEIGHT-1,d7
\l:     MASK_LONG
        MASK_LONG
        MASK_LONG
        MASK_LONG
        MASK_LONG
    IFND ti89
        MASK_LONG
    ENDIF
        addq.w  #2,a0
        addq.w  #2,a1
        dbra    d7,\l
        rts

*************************************** SCROLL FOREGROUND LEFT

Scroll_FG_Left:
        move.l  backbuffer(a5),a0
        lea     BUFFER_SIZE*2(a0),a0
        bsr.s   Scroll_Buffer
                             
        move.w  fg_x(a5),d0             ; skip next column if not on boundary
        and.w   #15,d0
        bne.s   \n

        move.w  fg_x(a5),d2             ; go to next level if X = level width 
        bsr     Get_Level_Width
        lsl.w   #4,d0
        cmp.w   d0,d2
        bne.s   \no_restart
        bsr.s   Next_Level
\no_restart:

*************************************** IF ON COLUMN BOUNDARY, DRAW NEXT ONE

        lea     column_map+64(a5),a2    ; Shift back list of columns
        moveq   #15,d1
\l2:    subq.w  #4,a2
        move.l  -4(a2),(a2)
        dbra    d1,\l2

        move.l  map_offset(a5),d1       ; offset and bit values
        move.l  d1,(a2)
        move.l  d1,d2
        swap    d2                      ; get offset in low word of D2

        lea     FG_til(pc),a2
        lea     BUFFER_WIDTH-2(a0),a0
        bsr     Draw_Compressed_Column
        bsr     Read_Byte

        move.w  d2,map_offset(a5)
        move.w  d1,map_bit(a5)

        lsr.w   #6,d4
        bra     Handle_Events
\n:     rts

*************************************** SCROLL ONE PAGE TO THE LEFT

Scroll_Buffer:
        move.w  #(BUFFER_SIZE*2)/32-1,d0
\l:     roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        roxl.w  -(a0)
        dbra    d0,\l
        rts

*************************************** ADVANCE TO NEXT LEVEL

Next_Level:
   IFND ti89
        move.l  a0,-(sp)
        lea     bcd_level+4(a5),a1
        lea     one(pc),a0
        moveq   #1,d5
        bsr     Add_BCD
        move.l  (sp)+,a0
   ENDIF

        addq.w  #1,level(a5)
        bsr     Get_Level
        bne.s   \nb
        st      show_end(a5)
\nb:
        clr.w   fg_x(a5)
        move.w  d1,map_offset(a5)
        move.w  #7,map_bit(a5)
        rts

*************************************** SCROLL BACKGROUND LEFT

Scroll_BG_Left:
        move.l  backbuffer(a5),a0
        lea     BUFFER_SIZE*4(a0),a0

        bsr.s   Scroll_Buffer

*************************************** IF ON COLUMN BOUNDARY, DRAW NEXT ONE

        move.w  bg_x(a5),d0
        and.w   #15,d0
        bne.s   \n
        tst.b   bg_x+1(a5)
        bne.s   \no_reset
        move.w  #BG_map-Level_Data,bmap_offset(a5)
        move.w  #7,bmap_bit(a5)
\no_reset:

        lea     BG_til(pc),a2
        lea     BUFFER_WIDTH-2(a0),a0
        move.w  bmap_offset(a5),d2
        move.w  bmap_bit(a5),d1
        bsr     Draw_Compressed_Column
        move.w  d2,bmap_offset(a5)
        move.w  d1,bmap_bit(a5)
\n:     rts

*************************************** INVERT FOREGROUND (TO MASK ON BLACK)

Invert_FG:
        lea     FG_til(pc),a0
        lea     BG_til(pc),a1
\i:     not.l   (a0)+
        cmp.l   a0,a1
        bne.s   \i
        rts

*************************************** CLEAR BACKGROUND DATA

Zero_Foreground:
        move.l  backbuffer(a5),a0
        move.w  #BUFFER_SIZE/2-1,d0
\s:     clr.l   (a0)+
        dbra    d0,\s
        rts  

*************************************** REDRAW TILES

Redraw_Foreground:
        bsr     Zero_Foreground

        lea     FG_til(pc),a2           ; A2 -> tile data
        move.l  backbuffer(a5),a0
        add.w   #BUFFER_WIDTH-2,a0      ; A0 -> column to draw in
        move.w  fg_x(a5),d7
        blt.s   \q

        bsr     Get_Level_Width         ; D6 = map width
        moveq   #(BUFFER_WIDTH/2)-1,d5  ; D5 = # columns remaining
        lea     column_map(a5),a4       ; A4 -> list of columns to draw

\rfl:   move.w  (a4)+,d2
        move.w  (a4)+,d1
        bsr     Draw_Compressed_Column
        lea     -2-BUFFER_SIZE(a0),a0   ; shift to previous column
        dbra    d5,\rfl

        move.w  fg_x(a5),d7
        and.w   #15,d7
        subq.w  #1,d7   
        blt.s   \q
\slide: bsr     Scroll_FG_Left
        dbra    d7,\slide
\q:     rts

Redraw_Background:
        lea     BG_til(pc),a2           ; A2 -> tile data
        move.l  backbuffer(a5),a0
        add.w   #BUFFER_SIZE*2+BUFFER_WIDTH-2,a0
        move.w  #BG_map-Level_Data,d2
        moveq   #7,d1
        moveq   #(BUFFER_WIDTH/2)-1,d5  ; D5 = # columns remaining

\rfl:   bsr     Draw_Compressed_Column
        lea     -2-BUFFER_SIZE(a0),a0   ; shift to previous column
        dbra    d5,\rfl

        move.w  #255,bg_x(a5)
\q:     rts

*************************************** DRAW ONE COMPRESSED COLUMN
*
* Draws one column (full 128 lines) of the map into the buffer.  Inputs:
*
* A0 -> first word of this column in buffer
* A2 -> tile set
*
* D1 / D2 hold bit / offset on input, and updated values on return.
*
* Modifies D0-D4, A0, A1.
*
********

Draw_Compressed_Column:
        moveq   #7,d0
\next_tile:
        bsr     Read_Byte
        lea     0(a2,d4.w),a1
        moveq   #15,d3
\next_line:
        move.w  32(a1),BUFFER_SIZE(a0)
        move.w  (a1)+,(a0)
        lea     BUFFER_WIDTH(a0),a0
        dbra    d3,\next_line
        dbra    d0,\next_tile
        rts
