****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Player bullet movement/display code)
**
**  Copyright 2003 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated April 19, 2003
**
****************************************************************************
****************************************************************************

Player_Bullets:
        lea     bullets_data(a5),a4     
        moveq   #num_b-1,d7    
loop_player_bullets:
        move.w  (a4),d6                         ;Skip if doesn't exist
        beq.s   no_bullet_here

        jsr     Player_Bullets(pc,d6.w)
        tst.w   (a4)
        beq.s   no_bullet_here

        move.w  b_x(a4),d0                      ;Draw the bullet
        move.w  b_y(a4),d1
        move.w  b_image(a4),d2 
        bsr     Draw_Sprite_D2

no_bullet_here:
        lea     b_size(a4),a4                   ;Move on to next bullet   
        dbra    d7,loop_player_bullets     
        rts

pbx_kill:
        clr.w   (a4)
        rts

pbx_wobble:
        move.w  game_timer(a5),d0
        btst    #3,d0
        beq.s   pbx_x_only

pbx_simple:
        move.w  b_y(a4),d0
        add.w   b_yv(a4),d0
        cmp.w   #54<<4,d0
        blt.s   pbx_kill
        cmp.w   #192<<4,d0
        bge.s   pbx_kill
        move.w  d0,b_y(a4)

pbx_x_only:
        move.w  b_x(a4),d0
        add.w   b_xv(a4),d0
        cmp.w   #208<<4,d0
        bge.s   pbx_kill
        move.w  d0,b_x(a4)
        rts

pbx_explode:
        btst    #0,game_timer+1(a5)
        beq.s   \done
        bsr     Next_Sprite             ; advance to next image
        bge.s   \done
        clr.w   (a4)
\done:  rts

********************************************** PLAYER BULLET TYPES
*
* The PBULLET macro assigns a bullet type to each type of player bullet used
* in the game.  The first argument is the symbol that is created for the
* type, and the second is the bullet's code.  The player bullet type is a
* relative pointer, and is used in the type field of the player bullet array.
*
* As this table is only used to set symbols to equal the offsets, this table
* takes absolutely no space in the executable code.
*
*******

PBULLET MACRO   
\1      equ     \2-Player_Bullets        
        ENDM    

        PBULLET PB_SIMPLE,pbx_simple
        PBULLET PB_WOBBLE,pbx_wobble
        PBULLET PB_EXPLODE,pbx_explode
