****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Collision detection)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated January 7, 2001
**
****************************************************************************
****************************************************************************

******************************************** TEST FOR COLLISIONS
*
* This routine tests two objects for collisions.  It returns with the zero
* flag set (equal) if there is no collision, and the zero flag clear
* (not equal) if there is a collision.  It first checks whether the
* rectangular boundaries of the objects overlap.  If they do, it then tests
* whether the images (dark planes only) overlap.
*
* This routine is guaranteed to preserve A1, A5, A6 and D4-D7.  All other
* registers may be changed.
*
* Parameters:
*
* A3 -> Bullet, enemy, or enemy bullet structure of one object
* A4 -> Bullet, enemy, or enemy bullet structure of the other
*
********

no_collision:
        moveq   #0,d0   
        rts     

Test_Collision:
        move.w  e_y(a4),d3              
        sub.w   b_y(a3),d3              ; D3 = A4.Y - A3.Y
        asr.w   #4,d3
        add.w   e_h(a4),d3
        ble.s   no_collision
        sub.w   e_h(a4),d3
        cmp.w   b_h(a3),d3
        bge.s   no_collision

        move.w  e_x(a4),d0        
        sub.w   b_x(a3),d0
        asr.w   #4,d0                   ; D0 = A4.X - A3.X
        add.w   e_w(a4),d0      
        ble.s   no_collision    
        sub.w   e_w(a4),d0      
        cmp.w   b_w(a3),d0      
        bge.s   no_collision

        tst.w   d3                      ; test A4.Y - A3.Y
        bge.s   \a3top                  ; branch if A3 is on top
        exg     a3,a4
        neg.w   d3
        neg.w   d0
\a3top: ;bra.s   \a3top                                

        lea     Draw_Sprite(pc),a2
        move.w  e_image(a4),d1
        lea     2(a2,d1.w),a0           ; A0 -> image of A4 sprite
        move.w  d3,d2
        add.w   d2,d2
        add.w   d2,d2
        add.w   e_image(a3),d2
        lea     2(a2,d2.w),a2           ; A2 -> image of A3 sprite

        not.w   d3                      ; D3 = A4.Y - A3.Y - 1
        add.w   e_h(a3),d3              ; D0 = number of lines to check - 1

        cmp.w   e_h(a4),d3              ; prevent check below bottom of A4
        blt.s   \ok
        move.w  e_h(a4),d3
        subq.w  #1,d3
\ok:

        tst.w   d0                      ; D0 = amount to shift A3 enemy left
        blt.s   \a3right
        beq.s   \samey

\ll:    move.l  (a2)+,d2
        lsl.l   d0,d2
        and.l   (a0)+,d2
        dbne    d3,\ll
\rts:   rts

\a3right:
        neg.w   d0
\rl:    move.l  (a2)+,d2
        lsr.l   d0,d2
        and.l   (a0)+,d2
        dbne    d3,\rl
        rts

\samey: move.l  (a2)+,d2
        and.l   (a0)+,d2
        dbne    d3,\samey
        rts
