****************************************************************************
****************************************************************************
**                                                               
**  Mercury (TI-89 Display routine)
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**                  
**  Last updated April 16, 2012
**
****************************************************************************
****************************************************************************

******************************************** PREPARE GRAYSCALE DISPLAY

Grayscale_Post_Init:
        move.l  a3,backbuffer(a5)
        move.l  gs_plane0(pc),a0
        move.l  gs_plane1(pc),a1
        move.l  a0,plane0(a5)
        move.l  a1,plane1(a5)

        move.l  #(239<<16)+127,-(sp)
        pea     (a0)
        JSR_ROM PortSet
        addq.l  #8,sp
        rts

******************************************** SET UP INFORMATION SCREEN

Set_Up_Screen:
        move.l  plane0(a5),a2
        move.w  #959,d0
        moveq   #-1,d1
\l:     move.l  d1,(a2)+
        dbra    d0,\l

        moveq   #0,d0
        bsr     Set_Font
        
        moveq   #95,d0
        moveq   #0,d1
        lea     energy_msg(pc),a0
        bsr     Display_String

        moveq   #95,d0
        moveq   #72,d1
        lea     shield_msg(pc),a0
        bsr     Display_String

        moveq   #95,d0
        moveq   #113,d1
        lea     score_msg(pc),a0
        bsr     Display_String

        bsr     Display_String
        move.l  plane0(a5),a0
        move.l  plane1(a5),a1
        move.w  #959,d0
\m:     move.l  (a0)+,(a1)+
        dbra    d0,\m
        rts

shield_msg:
        dc.b    'Shield:',0

score_msg:
        dc.b    'Score:',0

energy_msg:
        dc.b    'Power:',0

        EVEN

******************************************** DISPLAY SCREEN BUFFER

Display_Game_Screen:
        bsr     Display_Screen

        move.l  plane1(a5),a1
        add.w   #3+SCR_HEIGHT*30,a1
        move.w  energy(a5),d0
        lsr.w   #2,d0
        moveq   #5,d1
        moveq   #3,d2
        bsr     Display_Horiz_Bar

        move.l  plane1(a5),a1
        add.w   #17+SCR_HEIGHT*30,a1
        lea     score+1(a5),a0
        moveq   #2,d0
        bsr     Display_BCD

        move.l  plane1(a5),a1
        add.w   #12+SCR_HEIGHT*30,a1
        lea     player_dmg(a5),a0
        moveq   #1,d0
        bra     Display_BCD

Display_Screen:
        LEA     (A5),A0
        lea     s2(a5),a3
        move.l  plane1(a5),a1
        move.l  plane0(a5),a2

        MOVEQ   #94,D0  
LAB_0124:
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        lea     10(a1),A1       
        lea     10(a2),a2       
        DBF     D0,LAB_0124

        RTS     

******************************************* DISPLAY A BCD NUMBER
*
* Displays D0+1 bytes of a BCD number at A0 in memory at A1.
*
* Modifies D0, D1, A0 - A2.
*
********

Display_BCD:
        move.b  (a0),d1
        and.w   #$f0,d1
        lsr.w   #4,d1
        mulu    #5,d1
        lea     digits(pc,d1.w),a2
        moveq   #4,d1
loop_copy:
        move.b  (a2)+,d2
        move.b  d2,(a1)
        lea     30(a1),a1
        dbra    d1,loop_copy
        lea     -150(a1),a1

        move.b  (a0)+,d1
        and.w   #$f,d1
        mulu    #5,d1
        lea     digits(pc,d1.w),a2
        moveq   #4,d1
loop_or:
        move.b  (a2)+,d2
        ror.b   #4,d2
        and.b   d2,(a1)
        lea     30(a1),a1
        dbra    d1,loop_or
        lea     -149(a1),a1
        
        dbra    d0,Display_BCD
        rts

digits: dc.b    %10111111
        dc.b    %01011111
        dc.b    %01011111
        dc.b    %01011111
        dc.b    %10111111

        dc.b    %10111111
        dc.b    %10111111
        dc.b    %10111111
        dc.b    %10111111
        dc.b    %10111111

        dc.b    %10111111
        dc.b    %01011111
        dc.b    %11011111
        dc.b    %10111111
        dc.b    %00011111

        dc.b    %00111111
        dc.b    %11011111
        dc.b    %00111111
        dc.b    %11011111
        dc.b    %00111111

        dc.b    %01011111
        dc.b    %01011111
        dc.b    %00011111
        dc.b    %11011111
        dc.b    %11011111

        dc.b    %00011111
        dc.b    %01111111
        dc.b    %00111111
        dc.b    %11011111
        dc.b    %00111111

        dc.b    %10011111
        dc.b    %01111111
        dc.b    %00011111
        dc.b    %01011111
        dc.b    %00011111

        dc.b    %00011111
        dc.b    %11011111
        dc.b    %11011111
        dc.b    %10111111
        dc.b    %10111111

        dc.b    %10111111
        dc.b    %01011111
        dc.b    %10111111
        dc.b    %01011111
        dc.b    %10111111

        dc.b    %00011111
        dc.b    %01011111
        dc.b    %00011111
        dc.b    %11011111
        dc.b    %00111111
