****************************************************************************
****************************************************************************
**                                                               
**  Mercury (TI-92+ Display routine)
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**                  
**  Last updated April 16, 2012
**
****************************************************************************
****************************************************************************

******************************************** PREPARE GRAYSCALE DISPLAY

Grayscale_Post_Init:
        move.l  a3,backbuffer(a5)
        move.l  gs_plane0(pc),a0
        move.l  gs_plane1(pc),a1
        move.l  a0,plane0(a5)
        move.l  a1,plane1(a5)

        move.l  #(239<<16)+127,-(sp)
        pea     (a0)
        JSR_ROM PortSet
        addq.l  #8,sp
        rts

******************************************** SET UP INFORMATION SCREEN

Set_Up_Screen:
        move.l  plane0(a5),a2
        move.w  #959,d0
        moveq   #-1,d1
\l:     move.l  d1,(a2)+
        dbra    d0,\l

        moveq   #2,d0
        bsr     Set_Font 
        
        moveq   #6,d0
        move.w  #192,d1
        lea     shield_msg(pc),a0
        bsr     Display_String

        moveq   #38,d0
        move.w  #192,d1
        lea     score_msg(pc),a0
        bsr     Display_String

        moveq   #70,d0
        move.w  #192,d1
        lea     energy_msg(pc),a0
        bsr     Display_String

        moveq   #102,d0
        move.w  #192,d1
        lea     level_msg(pc),a0
        bsr     Display_String

        move.l  plane0(a5),a0
        move.l  plane1(a5),a1
        move.w  #959,d0
\m:     move.l  (a0)+,(a1)+
        dbra    d0,\m
        rts

shield_msg:
        dc.b    'Shield',0

score_msg:
        dc.b    'Score',0

energy_msg:
        dc.b    'Energy',0

level_msg:
        dc.b    'Level',0

        EVEN

******************************************** DISPLAY SCREEN BUFFER

Display_Game_Screen:
        bsr     Display_Screen

        move.w  energy(a5),d0
        lsr.w   #2,d0
        move.l  plane1(a5),a1
        add.w   #30*82+24,a1
        moveq   #5,d1
        moveq   #8,d2
        bsr     Display_Horiz_Bar

        lea     bcd_level+1(a5),a0
        moveq   #2,d0
        move.l  plane1(a5),a1
        add.w   #30*114+24,a1  
        bsr     Display_BCD

        lea     score+1(a5),a0
        moveq   #2,d0
        move.l  plane1(a5),a1
        add.w   #30*50+24,a1  
        bsr     Display_BCD

        lea     player_dmg-1(a5),a0
        moveq   #2,d0
        move.l  plane1(a5),a1
        add.w   #30*18+24,a1
        bra     Display_BCD

Display_Screen:
        LEA     (A5),A0
        lea     s2(a5),a3
        move.l  plane1(a5),a1
        move.l  plane0(a5),a2
        MOVEQ   #127,D0  
LAB_0124:
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        MOVE.L  (A0)+,(A1)+
        move.l  (a3)+,(a2)+
        lea     6(a1),A1       
        lea     6(a2),a2       
        DBF     D0,LAB_0124
Initialize_Info:
        RTS     

******************************************* DISPLAY A BCD NUMBER
*
* Displays D0+1 bytes of a BCD number at A0 in memory at A1.
*
* Modifies D0, D1, A0 - A2.
*
********

Display_BCD:
        move.b  (a0),d1
        and.w   #$f0,d1
        lsr.w   #4,d1
        bsr     show_digit
        move.b  (a0)+,d1
        and.w   #$f,d1
        bsr     show_digit
        dbra    d0,Display_BCD
        rts

show_digit:
        mulu    #7,d1
        lea     digits(pc,d1.w),a2
        moveq   #6,d1
loop_copy:
        move.b  (a2)+,d2
        move.b  d2,(a1)
        lea     30(a1),a1
        dbra    d1,loop_copy
        lea     -209(a1),a1
        rts

digits: dc.b    %11000001
        dc.b    %10111100
        dc.b    %10111010
        dc.b    %10110110
        dc.b    %10101110
        dc.b    %10011110
        dc.b    %11000001

        dc.b    %11100111
        dc.b    %11010111
        dc.b    %10110111
        dc.b    %11110111
        dc.b    %11110111
        dc.b    %11110111
        dc.b    %10000000

        dc.b    %11100011
        dc.b    %11011101
        dc.b    %10111101
        dc.b    %11111011
        dc.b    %11110111
        dc.b    %11101111
        dc.b    %10000000

        dc.b    %10000001
        dc.b    %11111110
        dc.b    %11111110
        dc.b    %10000001
        dc.b    %11111110
        dc.b    %11111110
        dc.b    %10000001

        dc.b    %10111101
        dc.b    %10111101
        dc.b    %10111101
        dc.b    %10000000
        dc.b    %11111101
        dc.b    %11111101
        dc.b    %11111101

        dc.b    %10000000
        dc.b    %10111111
        dc.b    %10111111
        dc.b    %10000001
        dc.b    %11111110
        dc.b    %11111110
        dc.b    %10000001

        dc.b    %11000000
        dc.b    %10111111
        dc.b    %10111111
        dc.b    %10000000
        dc.b    %10111110
        dc.b    %10111110
        dc.b    %11000001

        dc.b    %10000000
        dc.b    %11111101
        dc.b    %11111101
        dc.b    %11111011
        dc.b    %11111011
        dc.b    %11110111
        dc.b    %11110111

        dc.b    %11000001
        dc.b    %10111110
        dc.b    %10111110
        dc.b    %11000001
        dc.b    %10111110
        dc.b    %10111110
        dc.b    %11000001

        dc.b    %10000001
        dc.b    %10111110
        dc.b    %10111110
        dc.b    %10000000
        dc.b    %11111110
        dc.b    %11111110
        dc.b    %10000001
