****************************************************************************
****************************************************************************
**                                                               
**  Mercury for TI-89 (Sprite Plotting Routine)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated December 22, 2001
**
****************************************************************************
****************************************************************************

;************************************** MASKING (D1,D2) over (A1)

MASKDRAW MACRO
        move.l  d1,d2                   ; D2 = plane 0 data
        or.l    d3,d2                   ; D2 = plane data ORed
        move.l  d2,d5                   ; D5 = pixel mask (to black)
        or.l    (a1),d5                 ; D5 = plane 0 masked
        eor.l   d1,d5                   ; D5 = plane 0 masked and drawn ona
        move.l  d5,(a1)                 ; save new plane 0 data
        or.l    PLANE_SIZE(a1),d2       ; D2 = plane 1 masked
        eor.l   d3,d2                   ; D2 = plane 1 masked and drawn ona
        move.l  d2,PLANE_SIZE(a1)       ; save new plane 1 data
        ENDM

MASKDRAWR MACRO
        move.w  d1,d2                   ; D2 = plane 0 data
        or.w    d3,d2                   ; D2 = plane data ORed
        move.w  d2,d5                   ; D5 = pixel mask (to black)
        or.w    (a1),d5                 ; D5 = plane 0 masked
        eor.w   d1,d5                   ; D5 = plane 0 masked and drawn ona
        move.w  d5,(a1)                 ; save new plane 0 data
        or.w    PLANE_SIZE(a1),d2       ; D2 = plane 1 masked
        eor.w   d3,d2                   ; D2 = plane 1 masked and drawn ona
        move.w  d2,PLANE_SIZE(a1)       ; save new plane 1 data
        ENDM

MASKDRAWL MACRO
        swap    d1
        swap    d3
        MASKDRAWR
        ENDM

;************************************** GRAYSCALE SPRITE ROUTINE

clip_top:
        move.w  d1,d2                   ;D2 = - # of lines skipped
        add.w   d4,d1                   ;D1 = # of lines to draw - 1
        blt     rts

        add.w   d2,d2
        add.w   d2,d2                   ;D2 = -4 * # of lines skipped
        sub.w   d2,a0                   ;A0 -> First used sprite data
        sub.w   d2,a2

        move.w  d1,d4
        move.l  a5,a1
        bra.s   y_offset_obtained

Draw_Sprite_D2:
        lea     Draw_Sprite(pc,d2.w),a0
Draw_Sprite:
        asr.w   #4,d0
        asr.w   #4,d1
        sub.w   screenx(a5),d0
        move.w  (a0)+,d4                ;D4 = height in lines - 1
        move.w  d4,d2
        add.w   d2,d2
        add.w   d2,d2                   ;D2 = length of plane data - 4
        lea     4(a0,d2.w),a2           ;A2 -> second image

        sub.w   screeny(a5),d1          ;D1 = # of lines from top to start
        blt.s   clip_top
        move.w  d1,d3

        add.w   d4,d3
        sub.w   #SCR_HEIGHT-1,d3       ;D3 = # lines past bottom
        ble.s   clipped_vert
        sub.w   d3,d4
        blt     rts

clipped_vert:
        mulu    #WIDTH_BYTES,d1         ;D1 = line's offset in buffer
        lea     0(a5,d1.w),a1           ;A1 -> start of line in buffer
y_offset_obtained:

        move.w  d0,d2
        and.w   #15,d0                  ;D0 = low 4 bits of X coordinate
        asr.w   #4,d2                   ;D2 = word offset in line
        blt     clip_left
        cmp.w   #WIDTH_BYTES/2-1,d2
        bge     clip_right
        add.w   d2,d2                   ;D2 = byte offset in line       
        add.w   d2,a1                   ;A1 -> long image drawn at
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        move.l  (a2)+,d3
        lsl.l   d0,d1   
        lsl.l   d0,d3
        MASKDRAW
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\leftloop
\rts:   rts     
\cent:  move.l  (a0)+,d1
        move.l  (a2)+,d3
        MASKDRAW
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\cent
        rts

\right: move.l  (a0)+,d1
        move.l  (a2)+,d3
        lsr.l   d0,d1
        lsr.l   d0,d3
        MASKDRAW
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\right                
        rts     

clip_left:
        addq.w  #1,d2
        blt.s   \rts
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        move.l  (a2)+,d3
        lsl.l   d0,d1   
        lsl.l   d0,d3
        MASKDRAWR
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\leftloop
\rts:   rts

\cent:  move.l  (a0)+,d1
        move.l  (a2)+,d3
        MASKDRAWR
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\cent
        rts     

\right: move.l  (a0)+,d1
        move.l  (a2)+,d3
        lsr.l   d0,d1
        lsr.l   d0,d3
        MASKDRAWR
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\right                
        rts     

clip_right:
        bgt.s   \rts
        lea     WIDTH_BYTES-2(a1),a1
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        move.l  (a2)+,d3
        lsl.l   d0,d1   
        lsl.l   d0,d3
        MASKDRAWL
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\leftloop
\rts:   rts

\cent:  move.l  (a0)+,d1
        move.l  (a2)+,d3
        MASKDRAWL
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\cent
        rts     

\right: move.l  (a0)+,d1
        move.l  (a2)+,d3
        lsr.l   d0,d1
        lsr.l   d0,d3
        MASKDRAWL
        lea     WIDTH_BYTES(a1),a1       
        dbra    d4,\right                
rts:    rts
