****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Enemy bullets)
**
**  Copyright 2004 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated September 3, 2004
**
****************************************************************************
****************************************************************************

******************************************** HANDLE ENEMY BULLETS
*
* This routines processes each bullet in the enemy bullet array.  It tests
* each bullet for a collision with the player, and if a collision is
* detected the bullet is eliminated and the player damaged.  Both objects are
* approximated as rectangles for this collision detection.  Refer to the
* description of player-bullet-to-enemy collisions in 'BULLETS.ASM' for
* details of how that works.
*
* For each bullet which does not hit the player, the enemy movement routine
* is then called.  The bullet's type is the word offset of the routine.  The
* bullet routine is called with A4 pointing to the bullet structure, and D7
* holding the number of items remaining in the array.  It must preserve these
* two registers, and should update the coordinates and other data as needed,
* but not draw the bullet.
*
* This routine itself draws each bullet, using the coordinates and image
* specified in tis structure, before doing other processing on it.
*
********

Enemy_Bullets:
        lea     enemy_bullets(a5),a4    ; A4 -> Enemy bullet entry
        moveq   #num_eb-1,d7  
loop_draw_enemy_bullets:
        move.w  (a4),d6                 ; Test for bullet's presence
        beq.s   ebd_no_bullet_here      

        move.w  eb_x(a4),d0             ; Draw the bullet
        move.w  eb_y(a4),d1
        move.w  eb_image(a4),d2 
        bsr     Draw_Sprite_D2

        bsr     do_enemy_bullet
        cmp.w   #4,difficulty(a5)
        blt.s   ebd_no_bullet_here
        move.w  (a4),d6                 ; Test for bullet's presence
        beq.s   ebd_no_bullet_here      
        bsr     do_enemy_bullet

ebd_no_bullet_here:
        lea     eb_size(a4),a4   
        dbra    d7,loop_draw_enemy_bullets      
        rts

do_enemy_bullet:
        lea     player_type(a5),a3
        lea     (a4),a1
        bsr     Test_Collision
        lea     (a1),a4
        beq.s   ebd_no_collision        

        move.w  eb_hit(a4),d0
        jsr     Enemy_Bullets(pc,d0.w)
        clr.w   (a4)
        rts
ebd_no_collision:
        jmp     Enemy_Bullets(pc,d6.w)

******************************************** ENEMY BULLET SUBROUTINES

ebx_kill:
        clr.w   (a4)
        rts

ebx_smart:
        move.w  player_yc(a5),d0
        sub.w   eb_y(a4),d0             ; D0 = target - current
        bgt.s   \forcedown              ; if above top, aim down
        add.w   #16<<4,d0                             
        bge.s   ebx_simple              ; if not below bottom, continue             
\forceup:
        move.w  #-8,eb_yv(a4)           ; if below bottom, aim up
        bra.s   ebx_simple
\forcedown:

        move.w  #8,eb_yv(a4)
ebx_simple:            
        move.w  eb_xv(a4),d0
        add.w   d0,eb_x(a4)
        blt.s   ebx_kill
        move.w  eb_yv(a4),d0
        add.w   eb_y(a4),d0
        cmp.w   #56<<4,d0
        blt.s   ebx_kill
        cmp.w   #196<<4,d0
        bge.s   ebx_kill
        move.w  d0,eb_y(a4)
        rts

******************************************** ENEMY BULLET TYPES
*
* The EBULLET macro assigns an enemy bullet type to each type of enemy bullet
* used in the game.  The first argument is the symbol that is created for the
* type, and the second is the bullet's code.  The enemy bullet type is a
* relative pointer, and is used in the type field of the enemy bullet array.
*
* As this table is only used to set symbols to equal the offsets, this table
* takes absolutely no space in the executable code.
*
*******

EBULLET MACRO   
\1      equ     \2-Enemy_Bullets        
        ENDM    

        EBULLET EB_SIMPLE,ebx_simple
        EBULLET EB_SMART,ebx_smart
