****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Game over routines)
**
**  Copyright 2004 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated August 11, 2004
**
****************************************************************************
****************************************************************************

EG_FONT set     2-IS89                  ; 2 = large, 1 = normal
EG_YS   set     13-3*IS89               ; Line spacing

EG_CX   set     48-25*IS89              ; 'Game Completed' X coordinate
EG_CY   set     2                       ; 'Game Completed' Y coordinate
EG_FX   set     65-30*IS89              ; 'Final Scoring' X coordinate

EG_SX   set     18-16*IS89              ; X coordinate of score lines
EG_SY   set     35-10*IS89              ; Y coordinate of first score line

EG_RX   set     18-16*IS89
EG_RY   set     98-20*IS89              ; results lines

HS_X    set     15-15*IS89              ; high score initial X
HS_SX   set     170-48*IS89             ; score number X
HS_TY   set     19-5*IS89               ; Y coordinate of table start
HS_YS   set     11-2*IS89               ; space between HS lines
HS_BY   set     116-25*IS89             ; Y coordinate of bottom

******************************************** GAME FINISHED

Clear_Screen:
        lea     LCD_MEM,a0
        move.w  #959,d0
\l:     clr.l   (a0)+
        dbra    d0,\l
        rts

Game_Finished:
        bsr.s   Clear_Screen

        moveq   #EG_FONT,d0     
        bsr     Set_Font                ; Set font to very large

        lea     endt1(pc),a0            ; Mercury - Game Completed
        moveq   #EG_CY,d0   
        moveq   #EG_CX,d1  
        bsr     Display_String  

        lea     endt2(pc),a0            ; Final Scoring:
        moveq   #EG_CY+EG_YS,d0       
        moveq   #EG_FX,d1       
        bsr     Display_String  

        lea     endt3(pc),a0            ; Base Score
        move.l  score(a5),d0
        moveq   #EG_SY,d7       
        bsr     Display_Score   

        lea     endt5(pc),a0            ; Shield score
        move.w  player_dmg(a5),d0
        bge.s   \x
        moveq   #0,d0
\x:     ext.l   d0
        lsl.l   #4,d0
        moveq   #EG_SY+EG_YS,d7    
        move.l  d0,(a5)
        bsr     Display_Score
        lea     score+4(a5),a1
        lea     4(a5),a0
        moveq   #3,d5
        bsr     Add_BCD

        tst.w   tricheur(a5)     
        beq.s   did_not_cheat   
        clr.l   score(a5)
did_not_cheat:

        lea     endt7(pc),a0            ; Total score
        move.l  score(a5),d6
        move.l  d6,d0
        moveq   #EG_SY+EG_YS*3,d7    
        bsr     Display_Score   

        move.l  score(a5),d6
        lea     High_Score_Data+192(pc),a2      ; See if player entered table
        moveq   #-7,d4                  ; D4 = # longs to shift down
find_place_loop:
        cmp.l   -(a2),d6        
        ble.s   not_beaten      
        addq.w  #6,d4   
        lea     -20(a2),a2      
        bra.s   find_place_loop 
not_beaten:
        cmp.w   #-7,d4  
        beq.s   no_high_score   

        tst.w   d4      
        blt.s   no_shift_scores 
        lea     High_Score_Data+192(pc),a4      
        lea     High_Score_Data+168(pc),a3      
shift_scores:
        move.l  -(a3),-(a4)     
        dbra    d4,shift_scores 
no_shift_scores:
        move.l  d6,24(a2)       
        addq.l  #4,a2                   ; A2 -> Name entry place
        bsr     Input_Name      
        bra.s   Display_High_Scores 

no_high_score:
        moveq   #EG_RY,d0               ; Sorry - No Highscore
        moveq   #EG_RX,d1   
        lea     endt8(pc),a0    
        bsr     Display_String  

        moveq   #EG_RY+EG_YS,d0         ; Press enter to continue
        moveq   #EG_RX,d1   
        lea     endt10(pc),a0   
        bsr     Display_String  

gf_wait_enter:
        bsr     Get_Key 
        cmp.w   #13,d0  
        bne.s   gf_wait_enter   

******************************************** DISPLAY HIGH SCORES

Display_High_Scores:
        bsr     Clear_Screen            ; Display high scores

        moveq   #EG_FONT,d0     
        bsr     Set_Font            
        lea     endt11(pc),a0   
        moveq   #EG_CX,d1   
        moveq   #1,d0        
        bsr     Display_String  
                 
        moveq   #HS_BY,d0               ; Press enter to continue
        moveq   #HS_X,d1   
        lea     endt10(pc),a0   
        bsr     Display_String  

        lea     High_Score_Data(pc),a3      
        moveq   #HS_TY,d7 
        moveq   #7,d6   
hs_show_loop:
        move.l  d7,d0   
        moveq   #HS_X,d1   
        lea     (a3),a0
        bsr     Display_String  
        lea     20(a3),a3       
        move.l  (a3)+,-(sp)     
        pea     endt8-5(pc)     
        pea     _string_buffer(a5)      
        jsr     _sprintf   
        lea     12(sp),sp       
        lea     _string_buffer(a5),a0   
        move.l  d7,d0   
        move.w  #HS_SX,d1       
        bsr     Display_String  
        add.w   #HS_YS,d7 
        dbra    d6,hs_show_loop 

hs_wait_enter:
        bsr     Get_Key 
        cmp.w   #13,d0  
        bne.s   hs_wait_enter   
        rts

Display_Score:
        lea     _string_buffer(a5),a4   ; A4 -> string buffer
        move.l  d0,-(sp)                ; Push number
        pea     (a0)                    ; Push string
        pea     (a4)                    ; Push buffer address
        jsr     _sprintf   
        lea     12(sp),sp       
        lea     (a4),a0 
        moveq   #EG_SX,d1   
        move.l  d7,d0   
        bra     Display_String  

******************************************** GET PLAYER'S NAME

Input_Name:
        lea     (a2),a4                 ; A4 -> Entry area
        moveq   #19,d0  
in_loop_clear:
                                        ; Blank out the name
        move.b  #32,(a2)+       
        dbra    d0,in_loop_clear        
        lea     (a4),a1 
        moveq   #0,d6                   ; D6 = Character number

        moveq   #EG_RY,d0                   ; Please enter name
        moveq   #EG_RX,d1   
        lea     endt9(pc),a0    
        bsr     Display_String  

inpuths:
        lea     (a4),a0                 ; Display text
        moveq   #EG_RY+EG_YS,d0      
        moveq   #EG_RX,d1   
        move.w  #4,-(sp)        
        pea     (a0)
        move.w  d0,-(sp)        
        move.w  d1,-(sp)
        JSR_ROM DrawStr
        lea     10(sp),sp       
        bsr     Get_Key                 ; Read a keypress
        cmp.w   #13,d0                  ; Done if [ENTER] pressed
        beq.s   done_hs 
        cmp.w   #255,d0 
        ble.s   char    
        cmp.w   #257,d0 
        beq.s   backsp  
        bra.s   inpuths 
backsp: tst.w   d6      
        beq.s   inpuths 
        sub.w   #1,d6   
        move.b  #32,0(a4,d6.w)  
        bra.s   inpuths 
char:   cmp.w   #20,d6  
        beq.s   inpuths 
        move.b  d0,0(a4,d6.w)   
        addq.w  #1,d6   
        bra.s   inpuths 
done_hs:
        rts     

******************************************** SCORING DATA

endt1:  dc.b    'Mercury - Game Over',0
endt2:  dc.b    'Final Scoring:',0
endt3:  dc.b    'Base score          %6lx',0      
endt5:  dc.b    'Shield level * 10   %6lx',0     
endt7:  dc.b    'Total score         %6lx',0     
endt8:  dc.b    'You don''t have a highscore.',0        
endt9:  dc.b    'Highscore! Enter your name',0 
endt10: dc.b    'Press [ENTER] to continue.',0 
endt11: dc.b    'Mercury High Scores',0 
        CNOP    0,2     

        dc.l    $79999999 
High_Score_Data:
        dc.b    'Patrick Davidson :)',0 
        dc.l    $20000              
        dc.b    'Madonna            ',0 
        dc.l    $17500
        dc.b    'Britney            ',0 
        dc.l    $15000 
        dc.b    'Flavie             ',0 
        dc.l    $12500
        dc.b    'Alize             ',0 
        dc.l    $10000
        dc.b    'LaMarmotte         ',0 
        dc.l    $7500
        dc.b    'Jean-Marie Le Pen  ',0 
        dc.l    $5000 
        dc.b    'no one             ',0 
        dc.l    $2000
