****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Enemies)
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**                       
**  Last updated August 29, 2005
**
****************************************************************************
****************************************************************************

Locate_Empty_Enemy:
        lea     enemies_data(a5),a4
        move.w  #num_en-1,d0
\l:     tst.w   (a4)
        beq.s   \f
        lea     e_size(a4),a4
        dbra    d0,\l
\f:     Rts

******************************************** MOVE THE ENEMIES
*
* This enemy routine moves every enemy.  It uses the enemy's type in each
* enemy structure to select a routine from the table of actual enemy
* routines.  The table itself, as well as the routines, are in the file
* ENEMIES2.ASM.
*
* Each enemy routine will be called with A4 pointing to that enemy's enemy
* structure, and D7 holding the number of enemies after this one.
*
* The enemy handling routines should preserve the A3, A4, and D7 registers.
* Their purpose is to move the enemy by updating its coordinates, and make
* other changes to the data as needed (e.g. changing the image if the enemy
* is animated).  It should NOT draw the enemy to the screen.
*
********

Move_Enemies:
        lea     enemies_data(a5),a4     ;A4 -> enemy structure
        move.w  enemycount(a5),lastcount(a5)
        clr.w   enemycount(a5)
        moveq   #num_en-1,d7    
\loop_move_enemies:
        move.w  (a4),d0 
        beq.s   \no_enemy_here
        addq.w  #1,enemycount(a5)
        jsr     Move_Enemies(pc,d0.w)   
\no_enemy_here:
        lea     e_size(a4),a4   
        dbra    d7,\loop_move_enemies    
        rts     

******************************************** DRAW/ERASE THE ENEMIES
*
* Quite simply, this runs through the enemy array, and draws each enemy on
* the screen using the standard sprite display code.
*
********

Draw_Enemies:
        lea     enemies_data(a5),a6     
        moveq   #num_en-1,d7

\loop_draw_enemies:
        tst.w   (a6)    
        beq.s   \no_enemy_here

        move.w  e_x(a6),d0
        move.w  e_y(a6),d1
        move.w  e_image(a6),d2  
        bsr     Draw_Sprite_D2

        move.l  a6,a4
        lea     player_type(a5),a3
        bsr     Test_Collision
        beq.s   \no_enemy_here

        lea     one(pc),a0
        bsr     Damage_Player

        subq.w  #1,e_dmg(a6)
        bgt.s   \no_enemy_here
        move.l  a6,a4
        bsr     Enemy_Destroyed

\no_enemy_here:
        lea     e_size(a6),a6   
        dbra    d7,\loop_draw_enemies    
        rts     
