****************************************************************************
****************************************************************************
**
**  Mercury (Specific enemy control code)
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated August 30, 2005
**                    
****************************************************************************
****************************************************************************

*************************************** RANDOMIZED FIRE DECISION
*
* Takes base firing rate in D0.  Returns with the zero flag set if the
* enemy should shoot.  In normal difficulty levels the fire probability is
* 1/D0, but it increased to 1/(D0-20) at advanced or higher.
*
********

Fire_Decision:
        cmp.w   #2,difficulty(a5)
        ble.s   \not_difficult
        sub.w   #20,d0
\not_difficult:
        bsr     random
        tst.w   d0
        rts

*************************************** DIAMOND-SHAPED BASE

E_DIAMOND_BASE:
        tst.w   open_space(a5)
        bne.s   \s
        sub.w   #16,e_x(a4)
        ble     esl_kill

\s:     move.w  game_timer(a5),d0
        and.w   #63,d0
        bne.s   \done

        lea     \smart(pc),a1
\ok:    bra     Fire_Generic_Bullet

\done:  rts

\smart: dc.w    EB_SMART,5,4<<4,10,5<<4,4,spbullet_2-Draw_Sprite,0,-32,0

*************************************** BOUNCING SEMI-SQUARE

E_BOUNCE_SQUARE:
        bsr     Bounce_Movement

        tst.w   e_timer(a4)             ; fire when countdown reaches 20
        beq.s   \not_counting_down
        subq.w  #1,e_timer(a4)
        cmp.w   #20,e_timer(a4)
        beq.s   Launch_Aimed
\done:  rts

\not_counting_down:
        moveq   #100,d0                  ; fire 1/100 of the time
        bsr     Fire_Decision
        bne.s   \done
        move.w  #35,e_timer(a4)         ; set countdown timer to 30
        bra.s   Launch_Aimed

*************************************** SPINNING TRIANGLE

E_SPIN_TRIANGLE:
        bsr     Bounce_Movement
        move.w  game_timer(a5),d0       ; cycle image
        and.w   #3,d0
        bne.s   \no_cycle
        bsr     Next_Sprite
\no_cycle:

        moveq   #80,d0                  ; fire 1/80 of the time
        bsr     Fire_Decision
        tst.w   d0
        bne.s   rtse2t
Launch_Aimed:
        lea     aimed_shot(pc),a1
        bsr     Fire_Generic_Bullet
        bra     Aim_Bullet
rtse2t: rts

aimed_shot:
        dc.w    EB_SIMPLE,3,0<<4,4,3<<4,4,spbullet_1-Draw_Sprite,0,-32,0

Bounce_Movement:
        move.w  e_x(a4),d6
        add.w   e_x2(a4),d6
        move.w  d6,e_x(a4)
        tst.w   e_x2(a4)
        blt.s   \no_right

        cmp.w   #170<<4,d6
        blt.s   \no_right
        moveq   #4,d0
        bsr     random
        subq.w  #1,d0
        bne.s   \a
        moveq   #-2,d0
\a:     asl.w   #4,d0
        move.w  d0,e_y2(a4)
        moveq   #2,d0
        bsr     random
        subq.w  #2,d0
        asl.w   #4,d0
        move.w  d0,e_x2(a4)
        move.w  #169<<4,e_x(a4)
\no_right:

        cmp.w   #100<<4,d6
        bGE.s   \no_left
        moveq   #4,d0
        bsr     random
        subq.w  #1,d0
        bne.s   \b
        moveq   #-2,d0
\b:     asl.w   #4,d0
        move.w  d0,e_y2(a4)
        moveq   #2,d0
        bsr     random
        addq.w  #1,d0
        asl.w   #4,d0
        move.w  d0,e_x2(a4)
        move.w  #100<<4,e_x(a4)
\no_left:

        move.w  e_y(a4),d6
        add.w   e_y2(a4),d6
        move.w  d6,e_y(a4)

        cmp.w   #175<<4,d6
        blt.s   \no_bottom
        moveq   #4,d0
        bsr     random
        subq.w  #1,d0
        bne.s   \c
        moveq   #-2,d0
\c:     asl.w   #4,d0
        move.w  d0,e_x2(a4)
        moveq   #2,d0
        bsr     random
        subq.w  #2,d0
        asl.w   #4,d0
        move.w  d0,e_y2(a4)
        move.w  #174<<4,e_y(a4)
\no_bottom:

        cmp.w   #66<<4,d6
        bge.s   \no_top
        moveq   #4,d0
        bsr     random
        subq.w  #1,d0
        bne.s   \d
        moveq   #-2,d0
\d:     asl.w   #4,d0
        move.w  d0,e_x2(a4)
        moveq   #2,d0
        bsr     random
        addq.w  #1,d0
        asl.w   #4,d0
        move.w  d0,e_y2(a4)
        move.w  #66<<4,e_y(a4)
\no_top:
        rts

*************************************** ENEMY MAKING A SINGLE LOOP

E_SINGLE_LOOP_ENTER:
        cmp.w   #150<<4,e_x(a4)
        ble.s   \next_stage
        sub.w   #32,e_x(a4)
        bra.s   esl_generic
\next_stage:
        move.w  #SINGLE_LOOP,(a4)
        clr.w   e_misc(a4)

E_SINGLE_LOOP:
        move.w  e_misc(a4),d0
        addq.w  #8,d0
        cmp.w   #512,d0
        beq.s   \next_stage
        move.w  d0,e_misc(a4)
        btst    #8,d0
        bne.s   \second_half

        bsr     sin_cos
        asr.w   #7,d0
        sub.w   d0,e_x(a4)
        asr.w   #7,d1
        add.w   d1,e_y(a4)
        bra.s   esl_generic

\second_half:
        bsr     sin_cos
        mulu    #3,d0
        asr.w   #8,d0
        asr.w   #1,d0
        sub.w   d0,e_x(a4)
        mulu    #3,d1
        asr.w   #8,d1
        asr.w   #1,d1
        add.w   d1,e_y(a4)
        bra.s   esl_generic

\next_stage:
        move.w  #SINGLE_LOOP_EXIT,(a4)

E_SINGLE_LOOP_EXIT:
        sub.w   #32,e_x(a4)
        blt.s   esl_kill

esl_generic:
        move.w  game_timer(a5),d0       ; cycle image
        and.w   #3,d0
        bne.s   \no_cycle
        bsr     Next_Sprite
\no_cycle:

        moveq   #70,d0                  ; fire 1/70 of the time
        bsr     Fire_Decision
        bne.s   rts2

        lea     aimed_shot(pc),a1
        bsr     Fire_Generic_Bullet
        bra     Aim_Bullet

esl_kill:
        clr.w   (a4)
rts2:   rts

*************************************** ENEMY SPINNING AND IN SINE WAVE

E_SINE_SPIN:
        sub.w   #24,e_x(a4)
        ble.s   esl_kill
        addq.w  #8,e_misc(a4)
        move.w  e_misc(a4),d0
        bsr     sin_cos
        asr.w   #4,d0
        add.w   #120<<4,d0
        move.w  d0,e_y(a4)
        bra.s   esl_generic

*************************************** EXPLODING ENEMY

E_EXPLODING:
        bchg    #0,e_timer(a4)
        beq.s   \done
        bsr     Next_Sprite             ; advance to next image
        bge.s   \done
        
        clr.w   (a4)                    ; if at end, clear enemy
        lea     score+4(a5),a1          ; add to score

        move.w  difficulty(a5),d0
        lsl.w   #4,d0                   ; in BCD, multiplies by 10
        add.w   #$15,d0                 ; 15 + 10 * difficulty (25 to 65)
        
        lea     twentyfive+3(pc),a0
        move.b  d0,(a0)+                ; save this in BCD number
        moveq   #3,d5
        bsr     Add_BCD

        move.w  e_x(a4),d0              ; exit if < 32 pixels right of player
        sub.w   player_xc(a5),d0
        cmp.w   #32<<4,d0
        ble.s   \done

        moveq   #32,d0                  ; choose bonus type in D0
        bsr     random
        cmp.w   #4,d0
        bgt.s   \done
        bne.s   \ni
        add.w   level(a5),d0
\ni:
        add.w   d0,d0
        add.w   d0,d0
        lea     \bonus_list(pc,d0.w),a1

        bsr     Find_Enemy_Bullet       ; find bullet for bonus

        move.w  #EB_SIMPLE,(a0)+
        move.w  e_x(a4),d0              ; eb_type
        add.w   #2<<4,d0
        move.l  d0,(a0)+                ; eb_dmg (unused), eb_x
        moveq   #13,d1
        move.w  d1,(a0)+                ; eb_w
        move.w  e_y(a4),d0
        add.w   #2<<4,d0
        move.w  d0,(a0)+                ; eb_y
        move.w  d1,(a0)+                ; eb_h
        move.w  (a1)+,(a0)+             ; eb_image
        addq.w  #2,a0                   ; skip data
        move.l  #$FFE80000,(a0)+        ; xv / yv
        move.w  (a1),(a0)               ; hit type

\done:  rts

\bonus_list:
        dc.w    spbonus_shield-Draw_Sprite,H_SHIELD
        dc.w    spbonus_points-Draw_Sprite,H_POINTS
        dc.w    spbonus_energy-Draw_Sprite,H_ENERGY
        dc.w    spbonus_energy-Draw_Sprite,H_ENERGY
        dc.w    spbonus_2-Draw_Sprite,H_WEAPON2
        dc.w    spbonus_3-Draw_Sprite,H_WEAPON3
        dc.w    spbonus_4-Draw_Sprite,H_WEAPON4
        dc.w    spbonus_m-Draw_Sprite,H_WEAPONM
        dc.w    spbonus_5-Draw_Sprite,H_WEAPON5

twentyfive:
        dc.l    $00000025

*************************************** ENEMY 3 (LIGHTNING LAUNCHER)

E_ENEMY_3:
        moveq   #100,d0
        bsr     Fire_Decision
        bne.s   \ns
        lea     \lightning(pc),a1
        bsr     Fire_Generic_Bullet
\ns:    sub.w   #16,e_x(a4)
        bge.s   \ok
        clr.w   (a4)
\ok:    rts

\lightning:
        dc.w    EB_SIMPLE,4,-2<<4,13,3<<4,6,splightning-Draw_Sprite,0,-48,0

*************************************** ENEMY 4 (NORMAL HOLDING)

E_ENEMY_4_ENTERING:
        addq.w  #1,e_misc(a4)
        beq.s   \done_entering
        move.w  e_misc(a4),d0
        cmp.w   #-32,d0
        bge.s   \not_too_fast
        moveq   #-32,d0
\not_too_fast:
        add.w   d0,e_x(a4)
        bra.s   E_ENEMY_4_MAIN
\done_entering:
        move.w  #ENEMY_4_MAIN,(a4)

E_ENEMY_4_MAIN:
        move.w  e_timer(a4),d0
        addq.w  #2,d0
        move.w  d0,e_timer(a4)
        bsr     sin_cos
        asr.w   #3,d0
        add.w   e_y2(a4),d0
        move.w  d0,e_y(a4)

        moveq   #127,d0
        bsr     random
        tst.w   d0
        bne.s   \r
        lea     enemy_2_shot(pc),a1
        bra     Fire_Generic_Bullet
\r:     rts

*************************************** ENEMY 2 (SWOOPING)

E_ENEMY_2:
        sub.w   #32,e_x(a4)
        blt.s   \kill
        cmp.w   #208<<4,e_x(a4)
        bgt.s   \r
        move.w  e_misc(a4),d0
        cmp.w   #8,d0
        beq.s   \final
        addq.w  #1,d0
        move.w  d0,e_misc(a4)
\final: add.w   d0,e_y(a4)
        blt.s   \kill

        moveq   #110,d0
        bsr     Fire_Decision
        bne.s   \r
        lea     enemy_2_shot(pc),a1
        bra     Fire_Generic_Bullet

\kill:  clr.w   (a4)
\r:     rts

enemy_2_shot:
        dc.w    EB_SIMPLE,2,-5<<4,9,4<<4,4,spbullet_2-Draw_Sprite,0,-48,0

*************************************** LIGHTNING CANNON

E_HEAVY_CANNON:
        tst.w   open_space(a5)
        bne.s   \s
        sub.w   #16,e_x(a4)
   IFD ti89
        cmp.w   #32<<4,e_x(a4)
   ENDIF
        ble.s   \kill

\s:     move.w  game_timer(a5),d0
        and.w   #63,d0
        bne.s   \done

        lea     \lightning(pc),a1
        clr.w   18(a1)
        move.w  player_yc(a5),d0
        sub.w   e_y(a4),d0
        cmp.w   #30<<4,d0
        blt.s   \ok
        move.w  #16,18(a1)
\ok:    bra     Fire_Generic_Bullet

\done:  rts

\kill:  clr.w   (a4)
        rts

\lightning:
        dc.w    EB_SIMPLE,6,-2<<4,13,3<<4,6,splightning-Draw_Sprite,0,-48,0

*************************************** DIAGONAL LIGHTNING CANNON

E_DIAG_GUN:
        tst.w   open_space(a5)
        bne.s   \s
        sub.w   #16,e_x(a4)
   IFD ti89
        cmp.w   #32<<4,e_x(a4)
   ENDIF
        ble.s   \kill

\s:     move.w  game_timer(a5),d0
        and.w   #31,d0
        bne.s   \done

        lea     \lightning(pc),a1
\ok:    bra     Fire_Generic_Bullet
\done:  rts

\kill:  clr.w   (a4)
        rts

\lightning:
        dc.w    EB_SIMPLE,8,-2<<4,13,0,13,spdiaglightning-Draw_Sprite,0,-48,-48

*************************************** TANK

E_ARTILLERY:
        move.w  e_x(a4),d2
        sub.w   #16,d2

        cmp.w   #150<<4,d2
        bne.s   \a
        GETSPR  artillery_1,e_image(a4)
        addq.w  #2,e_misc(a4)
        sub.w   #1<<4,e_y(a4)
\a:
        cmp.w   #110<<4,d2
        bne.s   \b
        GETSPR  artillery_2,e_image(a4)
        addq.w  #2,e_misc(a4)
        sub.w   #2<<4,e_y(a4)
\b:
        move.w  d2,e_x(a4)
   IFD ti89
        cmp.w   #32<<4,d2
   ENDIF
        bge.s   \ok
        clr.w   (a4)
\q:     rts

\ok:    move.w  d2,d3
        and.w   #31<<3,d3
        bne.s   \q

        move.w  e_misc(a4),d0
        mulu    #10,d0
        lea     \shoot_types(pc,d0.w),a1
        bra     Fire_Generic_Bullet

\shoot_types:
        dc.w    EB_SIMPLE,4,0<<4,4,3<<4,4,spbullet_1-Draw_Sprite,0,-32,0
        dc.w    EB_SIMPLE,4,2<<4,4,-1<<4,4,spbullet_1-Draw_Sprite,0,-28,-12
        dc.w    EB_SIMPLE,4,7<<4,4,0<<4,4,spbullet_1-Draw_Sprite,0,-16,-16

*************************************** WOBBLING ENEMY ON ENTRY ARC

E_CIRCLING_ENTRY:
        move.w  e_misc(a4),d0
        cmp.w   #128,d0
        beq.s   \next
        lea     sines_table(pc),a0
        add.w   d0,a0
        addq.w  #2,d0
        move.w  d0,e_misc(a4)

        move.w  128(a0),d0              ; D0 = cosine
        asr.w   #2,d0
        add.w   e_x2(a4),d0
        move.w  d0,e_x(a4)

        move.w  (a0),d1                 ; D1 = sine
        asr.w   #2,d1
        move.w  e_y2(a4),d0
        sub.w   #1024,d0
        add.w   d1,d0
        move.w  d0,e_y(a4)
        rts

\next:  move.w  #CIRCLING_SLOW,(a4)
        move.w  #-26,e_misc(a4)

*************************************** WOBBLING ENEMY SLOWING INTO POSITION

E_CIRCLING_SLOW:
        move.w  e_misc(a4),d0
        addq.w  #1,d0
        move.w  d0,e_misc(a4)
        cmp.w   #-2,d0
        beq.s   \next
        add.w   d0,e_x(a4)
        rts

\next:  move.w  #CIRCLING_MAIN,(a4)
        clr.w   e_misc(a4)

*************************************** WOBBLING ENEMY SLOWLY CROSSING SCREEN

E_CIRCLING_MAIN:
        move.w  e_misc(a4),d0
        addq.w  #4,d0
        bclr    #9,d0
        move.w  d0,e_misc(a4)
        lea     sines_table(pc),a0
        move.w  0(a0,d0.w),d1
        asr.w   #4,d1
        add.w   e_y2(a4),d1
        move.w  d1,e_y(a4)
        subq.w  #2,e_x(a4)
   IFD ti89
        cmp.w   #32<<4,e_x(a4)
   ENDIF
        ble.s   \kill

        move.w  d7,d0
        mulu    d0,d0
        and.w   #127,d0
        move.w  game_timer(a5),d1
        and.w   #127,d1
        cmp.w   d0,d1
        bne.s   \q
        lea     enemy_2_shot(pc),a1
        bra     Fire_Generic_Bullet

\kill:  clr.w   (a4)
\q:     rts

*************************************** SMALL BASE

E_BASE: tst.w   open_space(a5)
        bne.s   \s
        sub.w   #16,e_x(a4)
        ble     esl_kill
\s:     move.w  game_timer(a5),d0
        and.w   #31,d0
        bne.s   rts1

        lea     base_shot(pc),a1
        bsr     Fire_Generic_Bullet

Aim_Bullet:
        bne.s   rts1
        lea     -eb_size(a0),a0

        move.w  player_xc(a5),d0
        sub.w   eb_x(a0),d0
        add.w   #64,d0
        move.w  d0,d5
        asr.w   #5,d0
        addq.w  #1,d0
        muls    d0,d0

        move.w  player_yc(a5),d1
        sub.w   eb_y(a0),d1
        add.w   #128,d1
        move.w  d1,d6
        asr.w   #5,d1
        muls    d1,d1
        add.w   d1,d0

        bsr     Square_Root_D0

        ext.l   d5
        divs    d2,d5
        move.w  d5,eb_xv(a0)
        ext.l   d6
        divs    d2,d6
        move.w  d6,eb_yv(a0)

rts1:   rts

base_shot:
        dc.w    EB_SIMPLE,4,6<<4,4,6<<4,4,spbullet_1-Draw_Sprite

*************************************** BASE GUARD (GENERIC ROUTINES)

Base_Guard:
        tst.w   open_space(a5)          ; go left if scrolling
        bne.s   \n
        sub.w   #16,e_x(a4)

\n:     move.w  game_timer(a5),d0       ; cycle image
        and.w   #3,d0
        bne.s   \q
        bsr     Next_Sprite
        move.w  screenx(a5),d0          ; this part should be unncessary
        lsl.w   #4,d0
        cmp.w   e_x(a4),d0
        ble.s   \q
        clr.w   (a4)
\q:     rts

*************************************** BASE GAURD (ENTERING)

E_GUARD_ENTRY:
        move.w  e_y(a4),d0 
        cmp.w   e_y2(a4),d0
        beq.s   \next
        add.w   #32,e_y(a4)
        bra.s   Base_Guard

\next:  move.w  #GUARD_CIRCLING,(a4)

*************************************** BASE GUARD (CIRCLING)

E_GUARD_CIRCLING:
        bsr     \get_offset             ; undo circle offset
        sub.w   d0,e_x(a4)
        sub.w   d1,e_y(a4)
        bsr.s   Base_Guard              ; do standard movement
        addq.w  #4,e_misc(a4)           ; add new circle offset
        bsr     \get_offset
        add.w   d0,e_x(a4)
        add.w   d1,e_y(a4)

        moveq   #70,d0                  ; fire 1/70 of the time
        bsr     Fire_Decision
        bne.s   \q

        lea     aimed_shot(pc),a1
        bra     Fire_Generic_Bullet

\get_offset:                            ; compute position in circle
        move.w  e_misc(a4),d0
        bsr     sin_cos
        neg.w   d0
        asr.w   #3,d0
        asr.w   #3,d1
\q:     rts

*************************************** FOURTH TYPE OF BOSS (FIVE LAUNCHERS)

E_BOSS4:
        moveq   #28,d0
        bsr     random
        tst.w   d0
        bne.s   \no_deploy
        cmp.w   #10,lastcount(a5)
        bge.s   \no_deploy

        move.l  a4,a3
        bsr     Locate_Empty_Enemy
        bne.s   \not_found

        addq.w  #4,e_path(a3)
        move.w  e_path(a3),d0
        and.w   #%11100,d0
        lea     launchers(pc,d0.w),a0   ; A0 -> launch position description

        STORE2  SPIN_TRIANGLE,30
        move.b  (a0)+,d0
        ext.w   d0
        lsl.w   #4,d0
        add.w   e_x(a3),d0
        move.w  d0,(a4)+
        move.w  #14,(a4)+
        move.b  (a0)+,d0
        ext.w   d0
        lsl.w   #4,d0
        add.w   e_y(a3),d0
        move.w  d0,(a4)+
        move.w  #14,(a4)+
        move.w  (a0)+,(a4)+             ; e_image
        addq.l  #8,a4
        STORE2  -32,0                   ; e_x2, e_y2
\not_found:
        move.l  a3,a4

\no_deploy:
        move.w  #115<<4,d1              ; maximum Y coordinate
        bra     Boss_Generic_Move

LAUNCH  MACRO
        dc.b    \1,\2
        dc.w    sp\3-Draw_Sprite
        ENDM

launchers:
        LAUNCH  4,0,triangle_2
        LAUNCH  1,15,triangle_1
        LAUNCH  0,30,triangle_1
        LAUNCH  1,45,triangle_1
        LAUNCH  4,60,triangle_4
        LAUNCH  1,45,triangle_1
        LAUNCH  0,30,triangle_1
        LAUNCH  1,15,triangle_1
                     
*************************************** THIRD TYPE OF BOSS (SQUARE LAUNCHER)

E_BOSS3:
        cmp.w   #105<<4,e_y(a4)
        bne.s   \no_deploy
        cmp.w   #10,lastcount(a5)
        bge.s   \no_deploy

        move.l  a4,a3
        bsr     Locate_Empty_Enemy
        bne.s   \not_found
        STORE2  BOUNCE_SQUARE,40
        move.w  e_x(a3),(a4)+
        STORE2  14,119<<4
        STORE2  14,spsemi_round-Draw_Sprite
        addq.l  #6,a4
        clr.w   (a4)+             
        STORE2  -32,0                   ; e_x2, e_y2
\not_found:
        move.l  a3,a4

\no_deploy:
        move.w  #36<<4,d4               ; bottom lightning offset
        moveq   #67,d5                  ; max Y distance for shooting                  
        moveq   #30,d6                  ; which lightning threshold
        move.w  #145<<4,d1              ; maximum Y coordinate
        bra     Boss_Generic

*************************************** SECOND TYPE OF BOSS

E_BOSS2:
        cmp.w   #105<<4,e_y(a4)
        bne.s   \no_deploy
        cmp.w   #10,lastcount(a5)
        bge.s   \no_deploy

        move.l  a4,a3
        bsr     Locate_Empty_Enemy
        bne.s   \not_found
        STORE2  SPIN_TRIANGLE,30        ; e_type, e_dmg
        move.w  e_x(a3),(a4)+
        STORE2  14,119<<4               ; e_w, e_y
        STORE2  14,sptriangle_1-Draw_Sprite
        addq.l  #8,a4
        STORE2  -32,0                   ; e_x2, e_y2
\not_found:
        move.l  a3,a4

\no_deploy:
        move.w  #36<<4,d4               ; bottom lightning offset
        moveq   #67,d5                  ; max Y distance for shooting                  
        moveq   #30,d6                  ; which lightning threshold
        move.w  #145<<4,d1              ; maximum Y coordinate
        bra.s   Boss_Generic

*************************************** FIRST TYPE OF BOSS

E_BOSS1:
        moveq   #80,d0
        bsr     Fire_Decision
        bne.s   \no_center_shoot
        not.w   e_path(a4)
        moveq   #5,d0
        and.w   e_path(a4),d0
        add.w   #10<<4,d0
        lea     ball_shot(pc),a1
        move.w  d0,8(a1)
        bsr     Fire_Generic_Bullet
        bsr     Aim_Bullet
\no_center_shoot:

        move.w  #21<<4,d4               ; bottom lightning offset
        moveq   #45,d5                  ; max Y distance for shooting                  
        moveq   #23,d6                  ; which lightning threshold
        move.w  #160<<4,d1              ; maximum Y coordinate

Boss_Generic:
        tst.w   e_timer(a4)             ; shoot lightning
        beq.s   \ready_to_shoot
        subq.w  #1,e_timer(a4)
        bra.s   \lightning_done
\ready_to_shoot:
        move.w  player_yc(a5),d0
        sub.w   e_y(a4),d0
        asr.w   #4,d0
        add.w   #19,d0
        ble.s   \lightning_done
        cmp.w   d5,d0
        bge.s   \lightning_done
        lea     b_lightning(pc),a1
        clr.w   8(a1)
        cmp.w   d6,d0
        blt.s   \no_below
        move.w  d4,8(a1)
\no_below:
        bsr     Fire_Generic_Bullet
        move.w  #40,e_timer(a4)
\lightning_done:

Boss_Generic_Move:
        tst.w   open_space(a5)          ; scroll left with space
        bne.s   \n
        sub.w   #16,e_x(a4)
\n:

        move.w  e_misc(a4),d0           ; move up/down
        add.w   d0,e_y(a4)
        cmp.w   e_y(a4),d1
        ble.s   \force_up
        cmp.w   #70<<4,e_y(a4)
        ble.s   \force_down
        moveq   #70,d0
        bsr     random
        tst.w   d0
        bne.s   \q
        neg.w   e_misc(a4)
\q:     rts

\force_up:
        move.w  #-16,e_misc(a4)
        rts

\force_down:
        move.w  #16,e_misc(a4)
        rts

b_lightning:
        dc.w    EB_SIMPLE,6,-2<<4,13,0,6,splightning-Draw_Sprite,0,-64,0

ball_shot:
        dc.w    EB_SIMPLE,4,0,4,3<<4,4,spbullet_1-Draw_Sprite

*************************************** FIND THE NEXT SPRITE INDEX
*
* Take a sprite index at the object in (A4) as input.  Advances this index to
* point to the following sprite.  If a -1 is found, jumps to the position
* in the following word, useful for looping, and also sets negative sign,
* useful for termination.
*
********

Next_Sprite:
        move.w  e_image(a4),d0          ; D0 = old image
        lea     Draw_Sprite(pc),a0
        move.w  0(a0,d0.w),d1           ; D1 = old image height
        lsl.w   #3,d1
        add.w   #10,d1                  ; D1 = old image size
        add.w   d1,d0                   ; D0 = new offset
        move.w  d0,e_image(a4)  
        tst.w   0(a0,d0.w)
        blt.s   \restart_image
        rts

\restart_image:
        move.w  2(a0,d0.w),e_image(a4)  ; load position from next word
        moveq   #-1,d0
rts56:  rts

*************************************** ENEMY ROTATING AROUND PIVOT

E_WHEEL_MAIN:
        addq.w  #4,e_misc(a4)
        move.w  e_misc(a4),d0
        bsr     sin_cos

        move.w  e_x2(a4),d2
        muls    d0,d2
        move.w  e_y2(a4),d3
        muls    d1,d3
        sub.l   d3,d2
        asr.l   #8,d2
        asr.w   #4,d2 
        add.w   #146<<4,d2
        move.w  d2,e_x(a4)

        muls    e_x2(a4),d1
        muls    e_y2(a4),d0
        add.l   d0,d1
        asr.l   #8,d1
        asr.w   #4,D1
        add.w   #124<<4,d1
        move.w  d1,e_y(a4)

wheel_shoot:
        moveq   #95,d0                  ; fire 1/95 of the time
        bsr     Fire_Decision
        bne.s   rts56

        lea     base_shot(pc),a1
        bsr     Fire_Generic_Bullet
        bra     Aim_Bullet
E_WHEEL_ENTER:
        move.w  e_y2(a4),e_y(a4)
        addq.w  #1,e_misc(a4)
        beq.s   \done_entering
        move.w  e_misc(a4),d0
        cmp.w   #-32,d0
        bge.s   \not_too_fast
        moveq   #-32,d0
\not_too_fast:
        add.w   d0,e_x(a4)
        bra.s   wheel_shoot  
\done_entering:
        move.w  #WHEEL_MAIN,(a4)
        move.w  e_x(a4),d0
        sub.w   #146<<4,d0
        move.w  d0,e_x2(a4)
        move.w  e_y(a4),d0
        sub.w   #124<<4,d0
        move.w  d0,e_y2(a4)
        bra.s   wheel_shoot

wheel_shot:
        dc.w    EB_SIMPLE,4,4<<4,4,4<<4,8,spbullet_1-Draw_Sprite

*************************************** ENEMY TYPES
*
* The ETYPE macro assigns an eneny type value to each type of enemy in the
* game.  The only argument is the enemy "name"; this symbol is assigned to
* the offset of the enemy's code, which is at E_name.  This enemy type is a
* relative pointer to the enemy's code.
*
* As this table is only used to set symbols to equal the offsets, this table
* takes \absolutely no space in the executable code.
*
********

ETYPE   MACRO   
\1      equ     E_\1-Move_Enemies   
        ENDM    

        ETYPE   ARTILLERY
        ETYPE   ENEMY_2
        ETYPE   EXPLODING
        ETYPE   CIRCLING_ENTRY
        ETYPE   CIRCLING_SLOW
        ETYPE   CIRCLING_MAIN
        ETYPE   BASE
        ETYPE   GUARD_ENTRY
        ETYPE   GUARD_CIRCLING
        ETYPE   ENEMY_3
        ETYPE   BOSS1
        ETYPE   ENEMY_4_ENTERING
        ETYPE   ENEMY_4_MAIN
        ETYPE   HEAVY_CANNON
        ETYPE   SINGLE_LOOP
        ETYPE   SINGLE_LOOP_ENTER
        ETYPE   SINGLE_LOOP_EXIT
        ETYPE   SINE_SPIN
        ETYPE   BOSS2
        ETYPE   SPIN_TRIANGLE
        ETYPE   WHEEL_ENTER
        ETYPE   WHEEL_MAIN
        ETYPE   DIAMOND_BASE
        ETYPE   BOSS3
        ETYPE   BOUNCE_SQUARE
        ETYPE   DIAG_GUN
        ETYPE   BOSS4
