****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Enemy firing)
**
**  Copyright 2002 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated May 24, 2002
**
****************************************************************************
****************************************************************************

******************************************** FIRE GENERIC BULLET
*
* Fire one shot of given type.  Uses coordinates of enemy at (A4).
* Type is specified by A1, which points to the following structure:
*
* dc.w type, damage, x-offset, width, y-offset, height, image, data, xv, yv 
*
*******

Fire_Generic_Bullet:
        bsr     Find_Enemy_Bullet
        move.l  (a1)+,(a0)+             ; type, dmg
        move.w  e_x(a4),d2
        add.w   (a1)+,d2
        move.w  d2,(a0)+                ; x
        move.w  (a1)+,(a0)+             ; w
        move.w  e_y(a4),d3
        add.w   (a1)+,d3
        move.w  d3,(a0)+                ; y
        move.w  (a1)+,(a0)+             ; h
        move.l  (a1)+,(a0)+             ; image/data
        move.l  (a1)+,(a0)+             ; xv/yv
        move.w  #H_BULLET,(a0)+
        moveq   #0,d0
        rts

******************************************** LOCATE AN ENEMY BULLET
*
* This routine finds the first unused enemy bullet structure, and returns a
* pointer to the beginning of it in A0.  This routine modifies only A0 and
* D0.  If there are no free enemy bullets, this routine will return two
* levels, exiting the routine that called it.  For this reason, it is not
* necessary for the routines using this to check if it finds anything, as
* they will only continue if a bullet has been found.
*
********

Find_Enemy_Bullet:
        lea     enemy_bullets(a5),a0    
        moveq   #num_eb-1,d0  
\loop_find_enemy_bullet:
        tst.w   (a0)    
        beq.s   \found_enemy_bullet      
        lea     eb_size(a0),a0  
        dbra    d0,\loop_find_enemy_bullet       
        addq.l  #4,sp   
\found_enemy_bullet:
        rts     
