****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Player/item hits)
**
**  Copyright 2008 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated August 28, 2005
**
****************************************************************************
****************************************************************************

******************************************** HANDLE ITEM COLLECTION / HIT
*
* These routines are called when the player collides with an enemy
* bullet or bonus.  The routine should damage the ship or add the bonus
* item as appropriate.  The routine is called with A4 pointing to the
* enemy bullet structure, and must preserve A4 and D7.
*
********

Bullet_Hit:
        cmp.w   #5,difficulty(a5)
        bne.s   \bh
        bsr     \bh
\bh:    lea     eb_dmg+2(a4),a0
        cmp.w   #1,difficulty(a5)
        bne.s   Damage_Player
        subq.w  #1,-2(a0)
Damage_Player:
        lea     player_dmg+2(a5),a1
        moveq   #1,d5
        bsr     Sub_BCD
        bcc.s   \ok
        clr.w   player_dmg(a5)
        st      show_end(a5)
\ok:    rts

Shield_Bonus:
        cmp.w   #$100,player_dmg(a5)
        bge.s   \ok
        lea     player_dmg+2(a5),a1
        lea     ten+2(pc),a0
        moveq   #1,d5
        bsr     Add_BCD
        cmp.w   #$100,player_dmg(a5)
        ble.s   \ok
        move.w  #$100,player_dmg(a5)
\ok:    rts

Score_Bonus:
        move.w  difficulty(a5),d0
        subq.b  #1,d0
        lsl.b   #5,d0                   ; 20 (BCD) * (difficulty - 1)
        lea     score+4(a5),a1          ; add base of 200 to score
        lea     twohundred+3(pc),a0
        move.b  d0,(a0)+                ; adds 20 to 80 depending on diff.
        moveq   #3,d5
        bra     Add_BCD

ten:    dc.w    $0010

Energy_Bonus:   
        cmp.w   #16,generation(a5)
        bge.s   \done
        addq.w  #1,generation(a5)
\done:  rts

twohundred:
        dc.l    $00000200

Weapon_2_Bonus:
        move.w  #4,player_weapon(a5)
        rts

Weapon_3_Bonus:
        move.w  #8,player_weapon(a5)
        rts

Weapon_4_Bonus:
        move.w  #12,player_weapon(a5)
        rts

Weapon_5_Bonus:
        move.w  #16,player_weapon(a5)
        rts

Weapon_M_Bonus:
        addq.w  #4,missile_count(a5)
        rts

********************************************** ITEM HIT TYPES
*
* The ITEMHIT macro assigns an item hit type for each type of item used in
* the game.  The first argument is the symbol that is created for the
* type, and the second is the hit code.  The item hit type is a relative
* pointer, and is used in the eb_hit field of the enemy bullet array.
*
* As this table is only used to set symbols to equal the offsets, this table
* takes absolutely no space in the executable code.
*
*******

ITEMHIT MACRO   
\1      equ     \2-Enemy_Bullets        
        ENDM
                       
        ITEMHIT H_BULLET,Bullet_Hit
        ITEMHIT H_SHIELD,Shield_Bonus
        ITEMHIT H_POINTS,Score_Bonus
        ITEMHIT H_ENERGY,Energy_Bonus
        ITEMHIT H_WEAPON2,Weapon_2_Bonus
        ITEMHIT H_WEAPON3,Weapon_3_Bonus
        ITEMHIT H_WEAPON4,Weapon_4_Bonus
        ITEMHIT H_WEAPONM,Weapon_M_Bonus
        ITEMHIT H_WEAPON5,Weapon_5_Bonus
