****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Event Handling)
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated August 30, 2005
**
****************************************************************************
****************************************************************************

Handle_Events:
        add.w   d4,d4
        move.w  Event_Table(pc,d4.w),d4
        jmp     Event_Table(pc,d4.w)

EVENT   MACRO
        dc.w    Event_\1-Event_Table
        ENDM

Event_Table:
        EVENT   None
        EVENT   Enter_Artillery         ; 1
        EVENT   Enter_Enemy2_Line       ; 2
        EVENT   Enter_Open_Space        ; 3
        EVENT   Enter_Circling          ; 4
        EVENT   Enter_Base              ; 5
        EVENT   Still_Terrain           ; 6
        EVENT   Lightning_Attack        ; 7
        EVENT   Enter_Boss_1            ; 8
        EVENT   Cross_Formation         ; 9
        EVENT   Heavy_Cannon            ; 10
        EVENT   Single_Loop             ; 11
        EVENT   Enter_Base_Unguarded    ; 12
        EVENT   Top_Bottom_Lightning    ; 13
        EVENT   Sigma_Attack            ; 14
        EVENT   Sine_Attack             ; 15
        EVENT   Enter_Boss_2            ; 16
        EVENT   Wheel                   ; 17
        EVENT   Repeat_10               ; 18
        EVENT   Repeat_5                ; 19
        EVENT   Diamond_Base            ; 20
        EVENT   Square_Boss             ; 21
        EVENT   Wheel_2                 ; 22
        EVENT   Wheel_Stars             ; 23
        EVENT   Diagonal_Lightning      ; 24
        EVENT   Five_Boss               ; 25

*************************************** REPEAT THIS COLUMN 5/10 TIMES

Event_Repeat_5:
        addq.w  #1,repeat_count(a5)
        cmp.w   #5,repeat_count(a5)
        bra.s   erc

Event_Repeat_10:
        addq.w  #1,repeat_count(a5)
        cmp.w   #10,repeat_count(a5)
erc:    bne.s   \repeat
        clr.w   repeat_count(a5)
        rts
\repeat:
        sub.w   #16,fg_x(a5)
        move.l  column_map(a5),map_offset(a5)
        rts

*************************************** WHEEL OF ENEMIES (LINE)

Event_Wheel:
        lea     wheel_positions(pc),a0
        GETSPR  blob_0,d1               ; D1 = image number
        moveq   #20,d2                  ; D2 = damage
Event_Wheel_C1:
        moveq   #12,d3                  ; D3 = width
        moveq   #12,d4                  ; D4 = height
        move.w  #WHEEL_ENTER,d5         ; D5 = enemy type
        bra     Install_Formation

wheel_positions:
        dc.b    90,45
        dc.b    86,65
        dc.b    73,80
        dc.b    55,89
        dc.b    35,89
        dc.b    17,80
        dc.b    4,65
        dc.b    0,45
        dc.b    4,25
        dc.b    17,10
        dc.b    35,1
        dc.b    55,1
        dc.b    73,10
        dc.b    85,25
        dc.b    18,45
        dc.b    36,45
        dc.b    54,45
        dc.b    72,45
        dc.w    -1

*************************************** WHEEL OF ENEMIES (CROSS)

Event_Wheel_2:
        lea     wheel_2_positions(pc),a0
Event_Wheel_C2
        GETSPR  blob_1,d1               ; D1 = image number
        moveq   #30,d2                  ; D2 = damage
        bra.s   Event_Wheel_C1

wheel_2_positions:
        dc.b    90,45
        dc.b    86,65
        dc.b    73,80
        dc.b    55,89
        dc.b    35,89
        dc.b    17,80
        dc.b    4,65
        dc.b    0,45
        dc.b    4,25
        dc.b    17,10
        dc.b    35,1
        dc.b    55,1
        dc.b    73,10
        dc.b    85,25
        dc.b    22,45
        dc.b    45,45
        dc.b    68,45
        dc.b    45,68
        dc.b    45,22
        dc.w    -1

*************************************** WHEEL OF ENEMIES (STARS)

Event_Wheel_Stars:
        lea     wheel_star_positions(pc),a0
        bra.s   Event_Wheel_C2

wheel_star_positions:
        dc.b    45,45 ; center enemy
        dc.b    45,60 ; first ring, 15 pixels out
        dc.b    59,49
        dc.b    53,32
        dc.b    36,32
        dc.b    30,49
        dc.b    50,75 ; second ring, 30 pixels out, rotated .2 radians
        dc.b    74,48
        dc.b    57,17
        dc.b    22,24
        dc.b    18,59
        dc.b    62,86 ; third ring, 45 pixels out, rotated .4 radians
        dc.b    89,41 
        dc.b    55,1
        dc.b    6,21
        dc.b    10,74
        dc.w    -1

*************************************** SPINNIGN SINE WAVE ENEMIES

Event_Sine_Attack:
        moveq   #5,d4                   ; D0 = number left to insert
        move.w  #208<<4,d1              ; D1 = X coordinate
        move.w  #(64+30)<<4,d2          ; D2 = Y coordinate
        moveq   #0,d3
        moveq   #11,d5                  
\l:     bsr     Locate_Empty_Enemy
        bne     Event_None
        STORE2  SINE_SPIN,10            ; e_type, e_dmg
        move.w  d1,(a4)+                ; e_x
        move.w  d5,(a4)+                ; e_w
        add.w   #20<<4,d1
        move.w  d2,(a4)+                ; e_y
        add.w   #1<<4,d2
        move.w  d5,(a4)+                ; e_h
        GETSPR  spin_0a,(a4)+           ; e_img
        move.w  d3,(a4)+                ; e_misc
        add.w   #-122,d3
        dbra    d4,\l
        rts

*************************************** SIGMA ENEMIES IN SIGMA PATTERN

Event_Sigma_Attack:
        lea     \positions(pc),a0
        GETSPR  enemy_sigma,d1          ; D1 = image number
        moveq   #20,d2                  ; D2 = damage
        moveq   #12,d3                  ; D3 = width
        moveq   #16,d4                  ; D4 = height
        move.w  #ENEMY_4_ENTERING,d5    ; D5 = enemy type
        bra     Install_Formation

\positions:
        dc.b    0,0
        dc.b    18,0
        dc.b    36,0
        dc.b    54,0
        dc.b    72,0
        dc.b    90,0
        dc.b    67,67
        dc.b    45,45
        dc.b    67,23
        dc.b    0,90
        dc.b    18,90
        dc.b    36,90
        dc.b    54,90
        dc.b    72,90
        dc.b    90,90
        dc.w    -1

*************************************** LIGHTNING ATTACK ON TOP/BOTTOM

Event_Top_Bottom_Lightning:
        lea     \positions(pc),a0
        bra     Put_Lightning_Attack

\positions:
        dc.w    208<<4,65<<4
        dc.w    208<<4,175<<4
        dc.w    0

*************************************** ENEMIES THAT FOLLOW SINGLE LOOP

Event_Single_Loop:
        moveq   #5,d4                   ; D0 = number left to insert
        move.w  #208<<4,d1              ; D1 = X coordinate
        move.w  #(64+30)<<4,d2          ; D2 = Y coordinate
        moveq   #11,d5
\l:     bsr     Locate_Empty_Enemy
        bne     Event_None
        STORE2  SINGLE_LOOP_ENTER,10    ; e_type, e_dmg
        move.w  d1,(a4)+                ; e_x
        add.w   #30<<4,d1
        move.w  d5,(a4)+                ; e_w
        move.w  d2,(a4)+                ; e_y
        add.w   #1<<4,d2
        move.w  d5,(a4)+                ; e_h
        GETSPR  spin_0a,(a4)+           ; e_image
        dbra    d4,\l
        rts

*************************************** LOCATE A BRICK
*
* Searches for brick of type D0 in the current column.
*
* Returns result in D5 as Y coordinate (fixed point).
* Modifies A3, D0 - D4.
*
********

Locate_Brick:
        lsl.w   #6,d0
        move.w  column_map(a5),d2
        move.w  column_map+2(a5),d1
        move.w  #(64)<<4,d5

\search_loop:
        bsr     Read_Byte
        cmp.w   d0,d4
        beq.s   \done

        add.w   #16<<4,d5
        cmp.w   #(64+128)<<4,d5
        bne.s   \search_loop

\fail:  move.w  #(64)<<4,d5
\done:  rts

*************************************** DIAGONAL LIGHTNING GUN

Event_Diagonal_Lightning:
        lea     Diag_Lightning_Data(pc),a0
        bra     Install_Terrain_Enemy

Diag_Lightning_Data:
        dc.w    58              ; brick to match
        dc.w    DIAG_GUN        ; e_type
        dc.w    120             ; e_dmg
        dc.w    210<<4          ; e_x
        dc.w    16              ; e_w
        dc.w    0               ; e_y offset
        dc.w    16              ; e_h
        dc.w    spdiaggun-Draw_Sprite

*************************************** DIAMOND-SHAPED BASE

Event_Diamond_Base:
        lea     Diamond_Base_Data(pc),a0
        bra     Install_Terrain_Enemy

Diamond_Base_Data:
        dc.w    46              ; brick to match
        dc.w    DIAMOND_BASE    ; e_type
        dc.w    80              ; e_dmg
        dc.w    208<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    -8<<4           ; e_y offset
        dc.w    15              ; e_h
        dc.w    spdiamond_base-Draw_Sprite

*************************************** HEAVY CANNON

Event_Heavy_Cannon:
        lea     Heavy_Cannon_Data(pc),a0

Install_Terrain_Enemy:
        move.w  (a0)+,d0
        bsr.s   Locate_Brick
        bne.s   tedone
        bsr     Locate_Empty_Enemy
        bne.s   tedone

        move.l  (a0)+,(a4)+     ; e_type,e_dmg
        move.l  (a0)+,(a4)+     ; e_x, w_w
        add.w   (a0)+,d5
        move.w  d5,(a4)+        ; e_y
        move.l  (a0)+,(a4)+     ; e_h, e_image
        clr.w   (a4)            ; e_misc
tedone: rts

Heavy_Cannon_Data:
        dc.w    30              ; brick to match
        dc.w    HEAVY_CANNON    ; e_type
        dc.w    30              ; e_dmg
        dc.w    208<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    6<<4            ; e_y offset
        dc.w    12              ; e_h
        dc.w    spcannon-Draw_Sprite

*************************************** INSERT SMALL BASE AND 4 GUARDS

Event_Enter_Base_Unguarded:
        lea     Small_Base_Data(pc),a0
        bra     Install_Terrain_Enemy

Small_Base_Data:
        dc.w    29              ; brick to match
        dc.w    BASE            ; e_type
        dc.w    20              ; e_dmg
        dc.w    208<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    0               ; e_y offset
        dc.w    18              ; e_h
        dc.w    spbase_0-Draw_Sprite

Event_Enter_Base:
        bsr     Event_Enter_Base_Unguarded
        bne.s   \q

        add.w   #4<<4,d5
        moveq   #0,d2                   ; add guards
        moveq   #3,d1
\l:     bsr     Locate_Empty_Enemy
        bne.s   \q
        STORE2  GUARD_ENTRY,5           ; e_type, e_dmg
        STORE2  179<<4,11               ; e_x, e_w
        move.w  d2,(a4)+                ; e_y
        sub.w   #64<<4,d2
        STORE2  11,spspin_0a-Draw_Sprite
        clr.w   (a4)+                   ; e_misc
        addq.l  #8,a4
        move.w  d5,(a4)                 ; e_y2

        dbra    d1,\l

\q:     rts

*************************************** CROSS FORMATION

Event_Cross_Formation:
        lea     cross_positions(pc),a0
        GETSPR  enemy_4,d1              ; D1 = image number
        moveq   #8,d2                   ; D2 = damage
        moveq   #12,d3                  ; D3 = width
        moveq   #10,d4                  ; D4 = height
        move.w  #ENEMY_4_ENTERING,d5    ; D5 = enemy type

Install_Formation:
        bsr     Locate_Empty_Enemy
        bne.s   \done

        clr.w   d0                      ; read X from table
        move.b  (a0)+,d0                ; D0 = timer value
        blt.s   \done

        move.w  d0,d6
        lsl.w   #4,d6
        add.w   #208<<4,d6              ; D6 = X coord

        clr.w   d7
        move.b  (a0)+,d7
        add.w   #79,d7
        lsl.w   #4,d7                   ; D7 = Y2 value 

        move.w  d5,(a4)+                ; e_type
        move.w  d2,(a4)+                ; e_dmg
        move.w  d6,(a4)+                ; e_x
        move.w  d3,(a4)+                ; e_w
        addq.l  #2,a4
        move.w  d4,(a4)+                ; e_h
        move.w  d1,(a4)+                ; e_image
        move.w  #-70,(a4)               ; e_misc
        move.w  d0,e_timer-e_misc(a4)
        move.w  d7,e_y2-e_misc(a4)

        bra.s   Install_Formation
\done:  rts

cross_positions:
        dc.b    0,0
        dc.b    45,0
        dc.b    45,15
        dc.b    45,30
        dc.b    45,45
        dc.b    45,60
        dc.b    45,75
        dc.b    45,90 
        dc.b    0,45
        dc.b    15,45
        dc.b    30,45
        dc.b    60,45
        dc.b    75,45
        dc.b    90,45
        dc.b    0,90
        dc.b    90,0
        dc.b    90,90
        dc.w    -1

*************************************** FIRST TYPE OF BOSS

Event_Enter_Boss_1:
        lea     Boss_1(pc),a0
Load_Static_Boss:
        bsr     Locate_Empty_Enemy
        bne.s   \quit
        move.l  (a0)+,(a4)+
        move.l  (a0)+,(a4)+
        move.l  (a0)+,(a4)+
        move.l  (a0)+,(a4)+
\quit:  rts

Boss_1: dc.w    BOSS1           ; e_tpye
        dc.w    60              ; e_dmg
        dc.w    208<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    70<<4           ; e_y
        dc.w    27              ; e_h
        dc.w    spboss_1-Draw_Sprite
        dc.w    16

*************************************** SECOND TYPE OF BOSS (TRIANGLE)

Event_Enter_Boss_2:
        lea     Boss_2(pc),a0
        bra     Load_Static_Boss

Boss_2: dc.w    BOSS2           ; e_tpye
        dc.w    300             ; e_dmg
        dc.w    207<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    70<<4           ; e_y
        dc.w    42              ; e_h
        dc.w    spboss_2-Draw_Sprite
        dc.w    16

*************************************** THIRD TYPE OF BOSS (SQUARE)

Event_Square_Boss:
        lea     Boss_3(pc),a0
        bra     Load_Static_Boss

Boss_3: dc.w    BOSS3           ; e_tpye
        dc.w    500             ; e_dmg
        dc.w    207<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    70<<4           ; e_y
        dc.w    42              ; e_h
        dc.w    spboss_3-Draw_Sprite
        dc.w    16

*************************************** FOURTH TYPE OF BOSS (SQUARE)

Event_Five_Boss:
        lea     Boss_4(pc),a0
        bra     Load_Static_Boss

Boss_4: dc.w    BOSS4           ; e_tpye
        dc.w    700             ; e_dmg
        dc.w    207<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    70<<4           ; e_y
        dc.w    72              ; e_h
        dc.w    spboss_4-Draw_Sprite
        dc.w    16

*************************************** ENEMY 3 IN ZIG-ZAG PATTERNS

Event_Lightning_Attack:
        lea     lightning_positions(pc),a0
Put_Lightning_Attack:
\il:    bsr     Locate_Empty_Enemy
        bne.s   \done
        move.w  (a0)+,d0        ; X coord
        beq.s   \done

        STORE2  ENEMY_3,4       ; e_type, e_dmg
        move.w  d0,(a4)+        ; e_x
        move.w  #16,(a4)+       ; e_w
        move.w  (a0)+,(a4)+     ; e_y
        STORE2  12,spenemy_3-Draw_Sprite
        clr.l   (a4)+           ; e_misc, e_path
        clr.l   (a4)+           ; e_key, e_timer
        bra.s   \il
\done:  rts

lightning_positions:
        dc.w    208<<4,70<<4
        dc.w    208<<4,90<<4
        dc.w    208<<4,110<<4
        dc.w    208<<4,130<<4
        dc.w    240<<4,80<<4
        dc.w    240<<4,100<<4
        dc.w    240<<4,120<<4
        dc.w    0
        
*************************************** STOP TERRAIN MOTION

Event_Still_Terrain:
        st      open_space+1(a5)
        rts

*************************************** INSERT WOBBLING OVAL OF ENEMIES

Event_Enter_Circling:
        moveq   #18,d5                  ; D7 = # enemies remaining
        moveq   #0,d6                   ; D0 = angle in ellipse
\loop_enter_circle:
        bsr     Locate_Empty_Enemy
        bne.s   Event_None

        move.w  d6,d0
        add.w   #27,d6
        bsr     sin_cos
        ext.l   d0
        divs    #5,d0
        add.w   #(122)<<4,d0
        move.w  d0,e_y2(a4)
        ext.l   d1
        divs    #9,d1
        add.w   #180<<4,d1
        move.w  d1,e_x2(a4)

        moveq   #10,d0
        move.w  d0,e_w(a4)
        move.w  d0,e_h(a4)
        GETSPR  e_small_0,e_image(a4)
        clr.w   e_misc(a4)
        STORE2  CIRCLING_ENTRY,1        ; e_type, e_dmg

        dbra    d5,\loop_enter_circle
        rts

**************************************** ENTER OPEN SPACE GAME MODE

Event_Enter_Open_Space:
        st      open_space(a5)
Event_None:
        rts

**************************************** INSERT A TANK

Event_Enter_Artillery:
        lea     Artillery(pc),a0
        bra     Load_Static_Boss

Artillery:
        dc.w    ARTILLERY       ; e_tpye
        dc.w    2               ; e_dmg
        dc.w    208<<4          ; e_x
        dc.w    17              ; e_w
        dc.w    164<<4          ; e_y
        dc.w    13              ; e_h
        dc.w    spartillery_0-Draw_Sprite
        dc.w    0

**************************************** INSERT LINE OF SWOOPING ENEMY 2

Event_Enter_Enemy2_Line:
        moveq   #3,d6                   ; D0 = number left to insert
        move.w  #208<<4,d1              ; D1 = X coordinate
        move.w  #(64+30)<<4,d2          ; D2 = Y coordinate
\l:     bsr     Locate_Empty_Enemy
        bne.s   Event_None
        STORE2  ENEMY_2,1               ; e_type, e_dmg
        move.w  d1,(a4)+                ; e_x
        add.w   #30<<4,d1
        move.w  #15,(a4)+               ; e_w
        move.w  d2,(a4)+                ; e_y
        add.w   #13<<4,d2
        STORE2  10,spenemy_2-Draw_Sprite  
        move.w  #-16,(a4)               ; e_misc
        dbra    d6,\l
        rts
