****************************************************************************
****************************************************************************
**                                                               
**  Mercury for TI-89 (Miscellaneous routines)
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated August 27, 2005
**
****************************************************************************
****************************************************************************

******************************************** DISPLAY A HORIZONTAL BAR
*
* D0 = value to indicate
* D1 = width in bytes - 1
* D2 = height - 2
* A1 -> screen location to draw in
*
********

Display_Horiz_Bar:
        tst.w   d0
        beq.s   \empty
        cmp.w   #8,d0
        bge.s   \full

        move.w  #$ff,d3
        lsr.w   d0,d3
        bsr.s   \draw_column
        moveq   #0,d0
        bra.s   \next_column

\empty: moveq   #-1,d3
        bsr.s   \draw_column
        bra.s   \next_column

\full:  moveq   #0,d3
        bsr.s   \draw_column
        subq.w  #8,d0

\next_column:
        dbra    d1,Display_Horiz_Bar
        rts

\draw_column:
        move.w  d2,d4
        lea     30(a1),a2
\cl:    move.b  d3,(a2)
        lea     30(a2),a2
        dbra    d4,\cl
        move.b  d3,(a1)+
        rts

******************************************** COMPUTE SQUARE ROOT OF D0
*
* Assumes D0 is an integer between 0 and 2^21-1.
* Returns result in D2, modifies D1 and D2.
*
********

Square_Root_D0:
        moveq   #32,d1                  ; D1 = current guess
\loop_square_root:
        move.l  d0,d2
        divu    d1,d2                   ; D1 = number/guess           
        add.w   d1,d2
        lsr.w   #1,d2                   ; D2 = new guess
        sub.w   d2,d1                   ; D1 = difference between guesses
        addq.w  #1,d1
        blt.s   \try_again              ; If difference < -1, try again
        subq.w  #2,d1
        ble.s   \done                   ; If difference <= 1, close enough
\try_again:
        move.w  d2,d1
        bra.s   \loop_square_root
\done:  rts

******************************************** COMPUTE SINE AND COSINE

sin_cos:
        and.w   #510,d0                 ; input: D0 = angle (0..511)
        move.w  sines_table(pc,d0.w),d1 ; returns D1 with sine
        add.w   #128,d0
        bclr    #9,d0
        move.w  sines_table(pc,d0.w),d0 ; returns D0 with cosine
        rts

sines_table:                            
        INCLUDE sines.i

******************************************** TEST ENTER KEY

Test_Enter:
    IFND ti89
        GETEDGE THIS_IS_FOR,TI92_ONLY,6,6
        beq.s   \enter
    ENDIF
        GETEDGE 1,0,9,1                 ; ENTER    
\enter:
        rts
             
******************************************** READ ALL KEYS
*
* Reads all keys by hardware and places their values in the key_data buffer.
* Keypresses occuring on this read are indicated in the key_edge buffer.
*
********

Read_All_Keys:
    IFD ti89
        moveq   #7,d0
    ENDIF
    IFND ti89
        moveq   #9,d0
    ENDIF
        lea     key_data(a5),a4
        moveq   #-2,d2
read_keys_loop:
        move.w  d2,$600018
        moveq   #34,d1
rkl_waste_time:
        dbra    d1,rkl_waste_time
        move.b  (a4),d3                         ; D3 = old key data
        move.b  $60001b,d4                      ; D4 = new key data
        move.b  d4,(a4)+
        move.b  d3,9(a4)
        not.b   d3
        or.b    d4,d3                           ; 0 = - edge (key down)
        move.b  d3,19(a4)

        rol.w   #1,d2
        dbra    d0,read_keys_loop
        rts

Wait_No_Key:
        move.w  #0,$600018
        move.w  #200,d0
\loop:  dbra    d0,\loop
Wait_No_Key_Loop:
        MOVE.B  $60001b,D0
        not.b   d0
        bne.s   Wait_No_Key_Loop
        RTS     

******************************************** RANDOM-NUMBER GENERATOR

random: move.l  d1,-(sp)
        move.w  #31421,d1
        mulu    seed(a5),d1
        add.w   #6927,d1
        move.w  d1,seed(a5)
        mulu    d1,d0
        swap    d0
        move.l  (sp)+,d1
        rts

******************************************** BASIC TEXT DISPLAY ROUTINES

Set_Font:                               ; Set font to D0
        move.w  d0,-(sp)        
        JSR_ROM FontSetSys
        addq.w  #2,sp   
        rts     

Display_String:                         ; Display (A0) at (D1,D0)
        move.w  #2,-(sp)        
        pea     (a0)
        move.w  d0,-(sp)        
        move.w  d1,-(sp)
        JSR_ROM DrawStr
        lea     10(sp),sp       
        rts

_sprintf:
        JMP_ROM sprintf

******************************************* ADD BCD LONGWORDS
*
* Adds (A0) to (A1), changing A0 and A1.  Pointers should initially point
* point right past the end of the values.  D5 indicates the number of bytes
* to process minus 1, and will be changed.
*
********

Add_BCD:
        andi    #0,ccr
\l:     abcd    -(a0),-(a1)
        dbra    d5,\l
        rts

******************************************* SUBTRACT BCD LONGWORDS
*
* Subtracts (A0) from (A1), changing A0 and A1.  Pointers should initially
* point right past the end of the values.  D5 indicates the number of bytes
* to process1 minus , and will be changed.
*
********

Sub_BCD:
        andi    #0,ccr
\l:     sbcd    -(a0),-(a1)
        dbra    d5,\l
        rts

******************************************** TI-OS KEYBOARD READING

    IFND _nostub
Get_Key:
        lea     tios::kb_vars+$1c,a3    
        tst.w   (a3)                    ; See if a keypress is stored
        beq.s   Get_Key                 ; Continue waiting if not
        clr.w   (a3)                    ; Clear keypress counter
        move.w  2(a3),d0                ; Read keypress
        rts     

Test_Key:
        lea     tios::kb_vars+$1c,a3    
        tst.w   (a3)    
        beq.s   no_key  
        clr.w   (a3)    
        move.w  2(a3),d0        
        rts     
no_key: moveq   #0,d0
tios::OSContrastUp:
tios::OSContrastDn:
        rts     
    ENDIF

    IFD _nostub
Get_Key:
        bsr.s   Test_Key
        beq.s   Get_Key
        rts

Test_Key:
        moveq   #6,d0
        trap    #9                      ; Get pointer to keyboard queue in A0

        move.l  a0,-(sp)
        pea     _string_buffer(a5)
        move.l  ($c8).w,a0
        move.l  $3aa*4(a0),a0
        jsr     (a0)                    ; OSdequeue()
        addq.l  #8,sp
        tst.w   d0
        bne.s   no_key
        move.w  _string_buffer(a5),d0
        rts
no_key: moveq   #0,d0
        rts 
    ENDIF
