****************************************************************************
****************************************************************************
**
**  Mercury for TI-89 / TI-92 Plus - Map data and access functions
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated April 7, 2005
**                                      
****************************************************************************
****************************************************************************

*************************************** LOCATE CURRENT LEVEL DATA
*
* D1 = offset to level data (starting with size) from Level_Data.
* D1 = 0 if the end of the level list has been reached.
* A1 - pointer to the level data.
*
********

Get_Level:
        move.w  level(a5),d1
        add.w   d1,d1
        move.w  Level_Data(pc,d1.w),d1
        lea     Level_Data(pc,d1.w),a1
        rts
                                  
*************************************** RETURN CURRENT LEVEL WIDTH IN D0

Get_Level_Width:
        bsr     Get_Level
        moveq   #0,d0
        move.b  (a1),d0
        rts

*************************************** READ FROM A COMPRESSED MAP
*
* D1 = bit number (taken as input and updated as result)
* D2 = offset (taken as input and updated as result)
*
* Returns value * 64 in D4.  Modifies D1 - D4, A3.
*
********

Read_Byte:
        addq.w  #1,d1                   ; next bit
        cmp.w   #8,d1                   ; test if past end of this byte
        blt.s   \not_end_of_byte
        subq.w  #8,d1                   ; if so, back 8 bits
        addq.w  #1,d2                   ; and forward one byte
\not_end_of_byte:
        lea     Level_Data(pc),a3
        btst    d1,0(a3,D2.W)
        bne.s   \non_zero               ; non-zero bit = non-zero value

        moveq   #0,d4                   ; zero bit = tile is zero
        rts

\non_zero:
        move.b  1(a3,d2.w),d4
        lsl.w   #8,d4
        move.b  0(a3,d2.w),d4           ; D4 = bits 15 ... 0
        addq.w  #1,d1                   ; D1 = starting bit of data
        lsr.w   d1,d4                   ; shift result into low 6 bits
        and.w   #63,d4                  ; mask out all other data
        addq.w  #1,d4                   ; since tiles 1-64 stored
        lsl.w   #6,d4                   ; scale for tile offset
        addq.w  #5,d1                   ; pass over rest of data
        rts

*************************************** THE MAPS THEMSELVES

Level_Data:
        dc.w    map1-Level_Data
        dc.w    map2-Level_Data
        dc.w    map3-Level_Data
        dc.w    map4-Level_Data
        dc.w    map5-Level_Data
        dc.w    0

map1:   INCLUDE maps\m1.asm
map2:   INCLUDE maps\m2.asm
map3:   INCLUDE maps\m3.asm
map4:   INCLUDE maps\m4.asm
map5:   INCLUDE maps\m5.asm
BG_map: INCLUDE maps\m0.asm
        EVEN

FG_til: INCLUDE maps\ftile.asm
BG_til: INCLUDE maps\btile.asm
                
