#include <stdio.h>

int outsize = 0;
int bit = 0;
unsigned out_byte = 0;

void write_bit(int b)
{
    if (b)
        out_byte |= (1 << bit);
    bit++;
    if (bit == 8) {
        bit = 0;
        outsize++;
        printf(" dc.b %d\n", out_byte);
        out_byte = 0;
    }
}

int main(void)
{
    int map[256*9];
    int size = 0;
    char c;
    int data, x, y, n, b;
    int height = 9;

    while (1) {
        c = getchar();
        if (c == '$') {
            scanf("%xd", &data);
            map[size++] = data;
        }
        if (c == '8')
            break;
        if (feof(stdin))
            break;
    }

    if (size == 128)
        height = 8;

    size /= height;

    printf(" dc.b %d ;width of the map in columns (height %d)\n", size, height);

    for (x = 0; x < size; x++) {
        for (y = x; y < x + size * height; y += size) {
                if (map[y] == 0)
                    write_bit(0);
                else {
                    write_bit(1);
                    n = map[y] - 1;
                    for (b = 1; b <= (1<<5); b <<= 1)
                        write_bit(n & b);
                }
        }
    }

    if (bit != 0) {
        printf(" dc.b %d\n", out_byte);
        outsize++;
    }

    fprintf(stderr, "Original bytes: %d\n", size * height);
    fprintf(stderr, "Compressed bytes: %d\n", outsize + 1);
    return 0;
}
