****************************************************************************
****************************************************************************
**                                                               
**  Mercury for TI-89 / TI-92 Plus
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated April 15, 2012
**
****************************************************************************
****************************************************************************

        INCLUDE which.i

    IFD ti92
        INCLUDE tios.h
    ENDIF
    IFND ti92
        INCLUDE os.h
        XDEF    _nostub
    ENDIF

        XDEF    _main

        INCLUDE version.i
        INCLUDE mercury.i

        INCLUDE init.asm

        INCLUDE drawspr.asm
        INCLUDE sprites\sprites.i

*************************************** SET UP DATA / SCREEN LAYOUT

main_game:
        clr.w   esc_held(a5)
        clr.w   esc_presses(a5)
        bsr     Set_Up_Screen

        tst.w   saved_game(a5)
        bne     Resume_Saved

        lea     data_start(a5),a0
        move.w  #(data_end-data_start)/2-1,d0
\cd:    clr.w   (a0)+
        dbra    d0,\cd

*************************************** TITLE SCREEN / INITIALIZATION

        bsr     Title_Screen

        bsr     Zero_Foreground
    IFD ti89
        move.w  #48,screenx(a5)
    ENDIF
    IFND ti89
        move.w  #16,screenx(a5)
        move.w  #64,screeny(a5)
    ENDIF
        move.w  #50<<4,player_xc(a5)
        move.w  #118<<4,player_yc(a5)
        move.w  #17,player_w(a5)
        move.w  #20,player_h(a5)
        GETSPR  player_ship_1,player_image(a5)
        move.l  #$100,player_dmg-2(a5)
        move.w  #192,energy(a5)
        move.w  #2,generation(a5)
        cmp.w   #1,difficulty(a5)
        bne.s   \not_easy
        addq.w  #1,generation(a5)
\not_easy;

    IFD ON_PEUT_TRICHER
        GETKEY  2,5,4,3
        bne.s   \jz
        move.l  #$7999,player_dmg-2(a5) 
        move.w  #32,generation(a5)
        move.w  #1500,missile_count(a5)
        st      tricheur(a5)
\jz:
    ENDIF

        move.w  #-1,level(a5)
        bsr     Next_Level
        subq.w  #1,fg_x(a5)

*************************************** MAIN LOOP

main_loop:
        lea     esc_held(a5),a0

        GETKEY  6,0,8,6                 ; Test ESC key
        beq.s   \esc_held
        clr.b   (a0)+                   ; Not pressed, so clear timer
        addq.b  #1,(a0)                 ; And increment not pressed timer
        cmp.b   #30,(a0)+               ; Check for 1 second released
        bne.s   \esc_done
        clr.b   (a0)                    ; Clear press counter
        bra.s   \esc_done

\esc_held:
        addq.b  #1,(a0)
        cmp.b   #45,(a0)+               ; Exit if ESC held for 1.5 seconds  \
        beq.s   game_done
        clr.b   (a0)+                   ; Clear released counter
        GETEDGE 6,0,8,6                 ; Test if this is a new press
        bne.s   \esc_done
        addq.b  #1,(a0)                 ; Increment press counter
        cmp.b   #3,(a0)
        beq.s   game_done
\esc_done:
        

        addq.w  #1,game_timer(a5)
        bsr     Enemy_Collisions
        bsr     Scroll_Screen
        bsr     Adjust_Contrast
        bsr     Draw_Player
        bsr     Move_Enemies
        bsr     Draw_Enemies
        bsr     Enemy_Bullets
        bsr     Player_Bullets
        bsr     Wait_VBL
        BSR     Display_Game_Screen     ; Copy buffer to actual screen

        bsr     Read_All_Keys 
        GETKEY  5,0,7,6                 ; Test APPS
        beq     save_game
        GETKEY  3,0,9,6                 ; Test status of . key 
        beq.s   game_done
        tst.w   show_end(a5)
        beq.s   main_loop

game_done:
        rts

*************************************** RESUME A SAVED GAME

Resume_Saved:
        clr.w   saved_game(a5)
        bsr     Redraw_Foreground
        bsr     Redraw_Background
        bra     main_loop

*************************************** SAVE THE GAME

save_game:
        st      saved_game(a5)
        bra.s   game_done

*************************************** CONTRAST SELECTION

Adjust_Contrast:
        GETEDGE 1,1,8,4                 ; +
        bne.s   \nocup
        JSR_ROM OSContrastUp
\nocup: GETEDGE 1,2,9,0                 ; -
        bne.s   \nocdn        
        JSR_ROM OSContrastDn
\nocdn: rts

*************************************** INCLUDE SUBROUTINE FILES

    IFD ti89
        INCLUDE disp89.asm
    ENDIF
    IFND ti89
        INCLUDE disp92.asm
    ENDIF
        INCLUDE ebullets.asm
        INCLUDE lib.asm
        INCLUDE back.asm
        INCLUDE maps.asm
        INCLUDE startup.asm     
        INCLUDE gray.asm
        INCLUDE player.asm
        INCLUDE enemies.asm
        INCLUDE enemies2.asm
        INCLUDE levels.asm
        INCLUDE eshoot.asm
        INCLUDE collide.asm
        INCLUDE bullets.asm
        INCLUDE hitenemy.asm
        INCLUDE title.asm
    IFND ti92
        INCLUDE vars.asm
    ENDIF
        INCLUDE hityou.asm
        INCLUDE endgame.asm


        END     
