****************************************************************************
****************************************************************************
**                                                               
**  Mercury - Data Structure Definitons
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated April 15, 2012
**
****************************************************************************
****************************************************************************

        IFD     ti89
WIDTH_BYTES     set     20
IS89            set     1
IS92            set     0
SCR_HEIGHT      equ     95
        XDEF    _ti89
        ENDIF

        IFND    ti89
WIDTH_BYTES     set     24
IS89            set     0
IS92            set     1
SCR_HEIGHT      equ     128  
        ENDIF

        IFD     ti92plus
        XDEF    _ti92plus
        ENDIF

BUFFER_WIDTH    equ     WIDTH_BYTES+2
BUFFER_SIZE     equ     128*BUFFER_WIDTH
PLANE_SIZE      equ     SCR_HEIGHT*WIDTH_BYTES

******************************************** ENEMY DATA STRUCTURE

num_en  equ     21      
                            
e_type  equ     0                       ;offset into enemy table
e_dmg   equ     2                       ;strength of the enemy
e_x     equ     4                       ;X-coordinate
e_w     equ     6                       ;width
e_y     equ     8                       ;Y-coordinate
e_h     equ     10                      ;height
e_image equ     12                      ;offset into image table
e_misc  equ     14                      ;more data
e_path  equ     16                      ;offset into path data
e_key   equ     18                      ;for sorthing           
e_timer equ     20                      ;timer
e_x2    equ     22                      ;X destination / center
e_y2    equ     24                      ;Y destination / center
e_size  equ     26

STORE2  MACRO
        move.l  #((\1)<<16)+(\2),(a4)+
        ENDM

******************************************** ENEMY BULLET STRUCTURE

num_eb  equ     12

eb_type equ     0                       ;offset into jump table
eb_dmg  equ     2                       ;number of damage points
eb_x    equ     4                       ;X-coordinate
eb_w    equ     6                       ;width
eb_y    equ     8                       ;Y-coordinate
eb_h    equ     10                      ;height
eb_image equ    12                      ;offset into image table
eb_data equ     14                           
eb_xv   equ     16
eb_yv   equ     18
eb_hit  equ     20
eb_size equ     22

******************************************** BULLET STRUCTURE

num_b   equ     24

b_type  equ     0                       ;word offset into jump table
b_dmg   equ     2                       ;number of damage points
b_x     equ     4                       ;X-coordinate
b_w     equ     6                       ;width
b_y     equ     8                       ;Y-coordinate
b_h     equ     10                      ;height
b_image equ     12                      ;offset into image table
b_xv    equ     14
b_yv    equ     16
b_key   equ     18                      ;for sorting
b_size  equ     20      

*************************************** VARIABLES

offset  set     0       

rs      MACRO   
\1      set     offset  
offset  set     offset+\2       
        ENDM    

        rs      s,SCR_HEIGHT*WIDTH_BYTES
        rs      s2,SCR_HEIGHT*WIDTH_BYTES
   IFD ti89
        rs      i_love_to_waste_memory,296
   ENDIF
        rs      plane0,4
        rs      plane1,4
        rs      backbuffer,4
        rs      key_data,10
        rs      old_keys,10
        rs      key_edge,10
        rs      bg_x,2
        rs      temp,4
        rs      esc_held,1              ; how long ESC has been held
        rs      esc_released,1          ; how long ESC has been released
        rs      esc_presses,2           ; 1 byte long but padded

        rs      _string_buffer,40       ; String buffer (for sprintf)

        rs      data_start,0            ; Start of data to be saved
        rs      column_map,64           ; list of columns drawn (for restore)
        rs      repeat_count,2
        rs      score,4
        rs      enemycount,2
        rs      lastcount,2
        rs      bullets_data,num_b*b_size
        rs      enemies_data,e_size*num_en
        rs      enemy_bullets,num_eb*eb_size
        rs      fg_x,2
        rs      screenx,2
        rs      screeny,2
        rs      player_type,2
        rs      player_dmg,2
        rs      player_xc,2
        rs      player_w,2
        rs      player_yc,2
        rs      player_h,2
        rs      player_image,2
        rs      firecounter,2
        rs      game_timer,2
        rs      open_space,2
        rs      saved_game,2
        rs      energy,2
        rs      generation,2
        rs      player_weapon,2
        rs      show_end,2
        rs      level,2
        rs      missile_count,2
        rs      tricheur,2
        rs      difficulty,2
    IFND ti89
        rs      bcd_level,4
    ENDIF
        rs      map_offset,2            ; position in map data wrt Level_Data
        rs      map_bit,2
        rs      bmap_offset,2           ; position in map data wrt Level_Data
        rs      bmap_bit,2
        rs      seed,2
        
        rs      data_end,0              ; End of data to be saved

*************************************** HARDWARE KEY READING
*
* This macro tests a key, using data from the last call to Read_All_Keys.
* Its syntax is
*
* GETKEY row89,column89,row92,column92
*
* The zero flag is set if it is pressed, and clear otherwise.
*
* A5 must be pointing to the game's data structures.
*
********

GETKEY  MACRO
    IFD ti89
        btst    #\2,key_data+\1(a5)
    ENDIF
    IFND ti89
        btst    #\4,key_data+\3(a5)
    ENDIF
        ENDM

GETEDGE  MACRO
    IFD ti89
        btst    #\2,key_edge+\1(a5)
    ENDIF
    IFND ti89
        btst    #\4,key_edge+\3(a5)
    ENDIF
        ENDM

*************************************** ROM CALLING FUNCTIONS

    IFND ti92
JMP_ROM MACRO
        move.l  (200).w,a0
        move.l  \1*4(a0),a0
        jmp     (a0)
        ENDM

JSR_ROM MACRO
        move.l  (200).w,a0
        move.l  \1*4(a0),a0
        jsr     (a0)
        ENDM
    ENDIF

    IFD ti92
tios::DrawStr equ tios::DrawStrXY
tios::HeapAllocHigh equ tios::HeapAlloc

JMP_ROM MACRO
        jmp     tios::\1
        ENDM

JSR_ROM MACRO
        jsr     tios::\1
        ENDM
    ENDIF
