****************************************************************************
****************************************************************************
**                                                               
**  Mercury (Player handling routines)
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated August 30, 2005
**
****************************************************************************
****************************************************************************

MAX_X   set     80<<4
    IFD ti89
MIN_X   set     48<<4
    ENDIF
    IFND ti89
MIN_X   set     16<<4
    ENDIF
MIN_Y   set     64<<4     
MAX_Y   equ     MIN_Y+(108<<4)

******************************************** DRAW THE PLAYER'S SHIP

Draw_Player:
    IFD ON_PEUT_TRICHER
        tst.w   tricheur(a5)
        beq.s   \jz

        GETEDGE 2,5,4,3
        bne.s   \jz

        lea     enemies_data(a5),a4
        moveq   #num_en-1,d7
\le:    clr.w   (a4)
        lea     e_size(a4),a4
        dbra    d7,\le

        bsr     Next_Level
        subq.w  #1,fg_x(a5)
\jz:
    ENDIF

        move.w  player_xc(a5),d0        ; Load coordinates
        move.w  player_yc(a5),d1        
        moveq   #32,d2

        GETKEY  0,2,0,7                 ; Move down
        bne.s   player_notgoingdown     
        add.w   d2,d1     
        cmp.w   #MAX_Y,d1   
        ble.s   player_notgoingdown     
        move.w  #MAX_Y,d1

player_notgoingdown:

        GETKEY  0,0,0,5                 ; Move up
        bne.s   player_notgoingup       
        sub.w   d2,d1     
        cmp.w   #MIN_Y,d1       
        bge.s   player_notgoingup       
        move.w  #MIN_Y,d1       
player_notgoingup:

        GETKEY  0,3,0,6                 ; Move right
        bne.s   player_notgoingright    
        add.w   d2,d0     
        cmp.w   #MAX_X,d0   
        ble.s   player_notgoingright    
        move.w  #MAX_X,d0
player_notgoingright:

        GETKEY  0,1,0,4                 ; Move left
        bne.s   player_notgoingleft     
        sub.w   d2,d0     
        cmp.w   #MIN_X,d0       
        bge.s   player_notgoingleft     
        move.w  #MIN_X,d0       
player_notgoingleft:

        move.w  d0,player_xc(a5)
        move.w  d1,player_yc(a5)
    IFD ti89
        asr.w   #4,d1
        sub.w   #39,d1
        cmp.w   #64,d1
        bge.s   \a
        moveq   #64,d1
\a:     cmp.w   #97,d1
        ble.s   \b
        moveq   #97,d1
\b:     move.w  d1,screeny(a5)
        move.w  player_yc(a5),d1
    ENDIF

        move.w  player_image(a5),d2
        bsr     Draw_Sprite_D2

        bsr     Check_Foreground_Collision
        beq.s   \nohit
        lea     one(pc),a0
        bsr     Damage_Player
\nohit:

        move.w  generation(a5),d0
        add.w   energy(a5),d0           ; generate new energy
        cmp.w   #192,d0
        blt.s   \ok
        move.w  #192,d0
\ok:    move.w  d0,energy(a5)

        tst.w   firecounter(a5)         ; decrement fire delay
        beq.s   \ready
        subq.w  #1,firecounter(a5)
\r:     rts

\ready: GETKEY  0,6,0,1                 ; Test diamond (fire missile)
        bne.s   \no_fire_missile  

        tst.w   missile_count(a5)
        beq.s   \no_fire_missile
        subq.w  #1,missile_count(a5)
        move.w  #7,firecounter(a5)

        lea     weapon_m(pc),a2
        bra.s   fire_weapon_A2

\no_fire_missile:
        GETKEY  0,4,0,3                 ; Test 2nd/lock (fire)
        bne.s   \r

        move.w  #7,firecounter(a5)

        move.w  player_weapon(a5),d2
        lea     player_weapon_data(pc,d2.w),a0
        move.w  (a0)+,d1

        cmp.w   d1,d0                   ; test energy level
        blt.s   \r
        sub.w   d1,energy(a5)
        move.w  (a0)+,d1                ; D1 = offset to bullet list
        lea     player_weapon_data(pc,d1.w),a2

fire_weapon_A2:
        move.w  (a2)+,d2                ; D2 = number of bullets left
player_shoot_loop:
        lea     bullets_data(a5),a0
        moveq   #num_b-1,d0    
loop_find_bullet:
        tst.w   (a0)    
        beq.s   found_bullet    
        lea     b_size(a0),a0   
        dbra    d0,loop_find_bullet
        rts

found_bullet:
        move.l  (a2)+,(a0)+             ; b_type, b_dmg
        move.w  player_xc(a5),d0
        add.w   #10<<4,d0
        move.w  d0,(a0)+                ; b_x
        move.w  #9,(a0)+                ; b_w
        move.w  player_yc(a5),d0
        add.w   (a2)+,d0
        move.w  d0,(a0)+                ; b_y
        move.w  (a2)+,d0                ; D0 = b_image
        lea     Draw_Sprite(pc),a1
        add.w   d0,a1                   ; A1 = sprite pointer
        move.w  (a1),d1
        addq.w  #1,d1                   ; D1 = image height
        move.w  d1,(a0)+                ; b_h
        move.w  d0,(a0)+                ; b_img
        move.l  (a2)+,(a0)+             ; b_xv, b_yv
        dbra    d2,player_shoot_loop
        rts

player_weapon_data:
        dc.w    32,weapon_1-player_weapon_data
        dc.w    48,weapon_2-player_weapon_data
        dc.w    60,weapon_3-player_weapon_data
        dc.w    70,weapon_4-player_weapon_data
        dc.w    100,weapon_5-player_weapon_data

weapon_1:
        dc.w    0
        dc.w    PB_SIMPLE,3,7<<4,sppbullet_1-Draw_Sprite,48,0

weapon_2:
        dc.w    1
        dc.w    PB_SIMPLE,3,-1<<4,sppbullet_1-Draw_Sprite,48,0
        dc.w    PB_SIMPLE,3,14<<4,sppbullet_1-Draw_Sprite,48,0

weapon_3:
        dc.w    2
        dc.w    PB_SIMPLE,3,-1<<4,splightning-Draw_Sprite,56,-16
        dc.w    PB_SIMPLE,3,7<<4,splightning-Draw_Sprite,64,0
        dc.w    PB_SIMPLE,3,14<<4,splightning-Draw_Sprite,56,16

weapon_4:
        dc.w    1
        dc.w    PB_WOBBLE,6,-1<<4,spbullet_3-Draw_Sprite,64,-16
        dc.w    PB_WOBBLE,6,15<<4,spbullet_3-Draw_Sprite,64,16

weapon_m:
        dc.w    0
        dc.w    PB_SIMPLE,10,4<<4,sppbullet_m-Draw_Sprite,48,0

weapon_5:
        dc.w    4
        dc.w    PB_SIMPLE,4,-3<<4,spbullet_3-Draw_Sprite,80,-32
        dc.w    PB_SIMPLE,4,2<<4,spbullet_3-Draw_Sprite,88,-16
        dc.w    PB_SIMPLE,4,7<<4,spbullet_3-Draw_Sprite,96,0
        dc.w    PB_SIMPLE,4,12<<4,spbullet_3-Draw_Sprite,88,16
        dc.w    PB_SIMPLE,4,17<<4,spbullet_3-Draw_Sprite,80,32

        dc.b    $00,$01
one:

******************************************** TESTING PLAYER TO FOREGROUND

Check_Foreground_Collision:
        lea     Draw_Sprite(pc),a0
        add.w   player_image(a5),a0     ; A0 -> player ship image

        move.w  player_xc(a5),d0
        asr.w   #4,d0
        sub.w   screenx(a5),d0          ; D0 = X pixel coordinate
        move.w  d0,d2
        asr.w   #4,d2
        add.w   d2,d2                   ; D2 = X pixel word offset

        move.w  player_yc(a5),d1
        asr.w   #4,d1
        sub.w   #64,d1                  ; D1 = Y pixel coordinate

        move.l  backbuffer(a5),a1
        add.w   d2,a1
        mulu    #BUFFER_WIDTH,d1
        add.w   d1,a1                   ; A1 -> position on foreground

        move.w  (a0)+,d4                ; D4 = height - 1

        and.w   #15,d0                  ; D0 = low 4 bits of X coordinate
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        lsl.l   d0,d1
        move.l  d1,d2
        and.l   BUFFER_SIZE(a1),d2
        bne.s   \rts
        and.l   (a1),d1
        lea     BUFFER_WIDTH(a1),a1       
        dbra    d4,\leftloop
        rts

\cent:  move.l  (a0)+,d1
        move.l  d1,d2
        and.l   BUFFER_SIZE(a1),d2
        bne.s   \rts
        and.l   (a1),d1
        lea     BUFFER_WIDTH(a1),a1       
        dbra    d4,\cent
        rts

\right: move.l  (a0)+,d1
        lsr.l   d0,d1
        move.l  d1,d2
        and.l   BUFFER_SIZE(a1),d2
        bne.s   \rts
        and.l   (a1),d1
        lea     BUFFER_WIDTH(a1),a1       
        dbra    d4,\right                
\rts:   rts     
