***************************************************************************
****************************************************************************
**                                                               
**  Mercury - startup code
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**                  
**  Last updated April 15, 2012                     
**
****************************************************************************
****************************************************************************

data_size       equ     data_end-data_start
score_size      equ     24*8
var_size        equ     data_size+score_size+2+4+7

*************************************** CLEAR BASE DATA IF NONE SAVED

initialize_all:
        clr.w   saved_game(a5)
        bra.s   data_ready

*************************************** MAIN GAME STARTUP

start_program:
        lea     -offset(a7),a7          ; allocate local variables
        lea     (a7),a5

*************************************** PROCESS DATA FILE
    IFND ti92
        bsr     _get_data_file          ; attempt to load data file
        move.l  a0,d0
        beq.s   initialize_all          ; NULL -> nothing found

        cmp.w   #var_size-2,(a0)+
        bne.s   initialize_all          ; data invalid if wrong size

        move.l  (a0)+,d2                ; retrieve save game version
        cmp.l   #VERSION_SCORE,d2
        blt.s   initialize_all          ; data invalid if too old

        lea     data_start(a5),a1
        move.w  #(data_size/2)-1,d0     ; load variable data
\lvd:   move.w  (a0)+,(a1)+
        dbra    d0,\lvd

        lea     High_Score_Data(pc),a1  ; load score data
        move.w  #(score_size/2)-1,d0
\lsd:   move.w  (a0)+,(a1)+
        dbra    d0,\lsd

        cmp.l   #VERSION_SAVE,d2        ; exact match needed for save game
        bne.s   initialize_all
    ENDIF

*************************************** LOAD DATA FROM STACK (92)

    IFD ti92
        move.l  sp,d0
        and.l   #$1ffff,d0
        cmp.l   #$200+data_size+10,d0
        blt.s   initialize_all

        lea     ($200).w,a0
        lea     data_start(a5),a1
        move.w  #(data_size/2)-1,d0
        moveq   #0,d1
\vd:    move.w  (a0),(a1)+
        add.w   (a0)+,d1
        dbra    d0,\vd
        cmp.w   (a0),d1
        bne.s   initialize_all
        not.w   (a0)+
        cmp.l   #VERSION_SAVE,(a0)
        bne.s   initialize_all
        not.l   (a0)+
        cmp.l   #'Merc',(a0)
        bne.s   initialize_all
        not.l   (a0)
    ENDIF

*************************************** SET UP SCREEN AND RUN MAIN GAME

data_ready:
        bsr     Activate_Grayscale
        beq.s   \x
        bsr     Grayscale_Post_Init
        bsr     Invert_FG
        clr.w   show_end(a5)
        bsr     main_game
        bsr     Invert_FG
        bsr     Wait_No_Key

        bsr     Deactivate_Grayscale
        tst.w   show_end(a5)
        beq.s   \x
        bsr     Game_Finished
\x:

*************************************** SAVE DATA FILES AFTER EXIT

    IFND ti92
        move.w  #var_size,d6            ; attempt to create save file
        bsr     _create_save_file       
        move.l  a0,d0                   ; NULL -> unable to create
        beq.s   \no_save

        move.w  #var_size-2,(a0)+       ; put variable size

        move.l  #VERSION_SAVE,(a0)+

        lea     data_start(a5),a1       ; save variables
        move.w  #(data_size/2)-1,d0     
\svd:   move.w  (a1)+,(a0)+
        dbra    d0,\svd

        lea     High_Score_Data(pc),a1  ; save score data
        move.w  #(score_size/2)-1,d0
\ssd:   move.w  (a1)+,(a0)+
        dbra    d0,\ssd

        lea     final_data(pc),a1       ; put system junk at end of data
        moveq   #6,d0
\sfd:   move.b  (a1)+,(a0)+
        dbra    d0,\sfd
    ENDIF

    IFD ti92
        move.l  sp,d0
        and.l   #$1ffff,d0
        cmp.l   #$200+data_size+10,d0
        blt.s   \no_save
        lea     $200,a0
        lea     data_start(a5),a1
        move.w  #(data_size/2)-1,d0
        moveq   #0,d1
\sd:    move.w  (a1),(a0)+
        add.w   (a1)+,d1
        dbra    d0,\sd
        move.w  d1,(a0)+
        move.l  #VERSION_SAVE,(a0)+
        move.l  #'Merc',(a0)+
    ENDIF

\no_save:
        lea     offset(a5),a7
        rts

final_data:
        dc.b    0,'Merc',0,$F8

        EVEN
