****************************************************************************
****************************************************************************
**                                                               
**  Mercury for TI-89 / TI-92 Plus
**
**  Copyright 2012 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**
**  Last updated April 15, 2012
**
****************************************************************************
****************************************************************************

BASE_Y  set     16-16*IS89
BASE_X  set     16-16*IS89

Title_Screen:
        bsr     Redraw_Background

        st      enemycount(a5)
        st      open_space(a5)
        move.w  #64,screeny(a5)

        move.l  #((BUFFER_WIDTH*8-1)<<16)|127,-(sp)
        move.l  backbuffer(a5),a0
        pea     BUFFER_SIZE(a0)
        JSR_ROM PortSet
        addq.l  #8,sp

Draw_Main_Title:
        lea     title_main(pc),a6

Draw_Title_Screen:
        bsr     Draw_Title_A6
        
title_loop:
        bsr     Scroll_Screen
        bsr     Wait_VBL
        BSR     Display_Game_Screen     ; Copy buffer to actual screen

        bsr     Read_All_Keys
        bsr     Adjust_Contrast

        GETEDGE 5,7,6,4                 ; F1
        beq.s   Draw_Main_Title

        GETEDGE 4,7,4,4                 ; F2
        beq     \d2                    

        GETEDGE 3,7,2,4                 ; F3
        beq     \d3                   
           
        GETEDGE 2,7,9,4                 ; F4
        beq.s   \d4                   

        GETKEY  6,0,8,6                 ; Test status of ESC key
        beq.s   \quit
        GETKEY  3,0,9,6                 ; Test status of . key
        beq.s   \quit

        GETEDGE 0,4,0,3
        bne.s   title_loop

        lea     select_difficulty(pc),a6
        bsr     Draw_Title_A6
\speed_loop:
        bsr     Scroll_Screen
        bsr     Wait_VBL
        BSR     Display_Game_Screen     ; Copy buffer to actual screen

        bsr     Read_All_Keys
        bsr     Adjust_Contrast

        lea     keys_table(pc),a0       ; Table of #, Fn keys
        lea     key_data(a5),a1         ; Direct to key data table
        moveq   #0,d2
        moveq   #9,d0                   ; number of key codes remaining
\speed_check_loop:
        move.b  (a0),d1
        and.w   #15,d1                  ; D1 = column (bit) to check
        move.b  (a0)+,d2
        lsr.w   #4,d2                   ; D2 = row (offset) to check
        btst    d1,0(a1,d2.w)
        beq.s   \speed_selected
        dbra    d0,\speed_check_loop

        GETKEY  6,0,8,6                 ; Test status of ESC key
        beq.s   \quit
        GETKEY  3,0,9,6                 ; Test status of . key
        bne.s   \speed_loop

\quit:  move.l  (sp)+,a0
        rts

\speed_selected:
        lsr.w   #1,d0                   ; Halve table index giving 0 to 4
        addq.w  #1,d0                   ; Adjust to expect 1-5 range
        move.w  d0,difficulty(a5)
        rts

\d2:    lea     instructions_2(pc),a6
\g:     bra     Draw_Title_Screen

\d3:    lea     instructions_3(pc),a6
        bra.s   \g

\d4:    lea     instructions_4(pc),a6
        bra.s   \g

keys_table:                             ; high nybble is key row, low column
        IFD     ti89
        dc.w    $3217                   ; 5 first because we count down
        dc.w    $4227
        dc.w    $2137
        dc.w    $3147
        dc.w    $4157
        ENDIF
        IFND    ti89
        dc.w    $2674
        dc.w    $2594
        dc.w    $2417
        dc.w    $4416
        dc.w    $6415
        ENDIF  

Draw_Title_A6:
        bsr     Zero_Foreground

\loop:  moveq   #0,d0
        move.b  (a6)+,d0
        bsr     Set_Font

        moveq   #0,d1
        move.b  (a6)+,d1
        moveq   #0,d0
        move.b  (a6)+,d0
        lea     (a6),a0
        bsr     Display_String

\e:     tst.b   (a6)+
        bne.s   \e

        tst.b   (a6)
        bne.s   \loop

        move.l  backbuffer(a5),a0
        lea     BUFFER_SIZE-BUFFER_WIDTH(a0),a1
        move.w  #(127*BUFFER_WIDTH/2)-1,d0
\l:     move.w  (a1)+,(a0)+
        dbra    d0,\l
        rts

title_main:                                             
        dc.b    2,BASE_X+32,BASE_Y+15
        VERSION_STRING

        dc.b    2,BASE_X+4,BASE_Y+35
        dc.b    'by Patrick Davidson',0

        dc.b    1,BASE_X+6,BASE_Y+75
        dc.b    'Press F2 for instructions',0

        dc.b    0

instructions_2:
        dc.b    2,BASE_X+45,BASE_Y+1
        dc.b    'Controls:',0

        dc.b    1,BASE_X+2,BASE_Y+19
   IFND ti89
        dc.b    'Press LOCK to start game',0
   ENDIF
   IFD ti89
        dc.b    'Press 2nd to start game',0
   ENDIF
                                 
        dc.b    1,BASE_X+2,BASE_Y+29
        dc.b    'Press APPS to save & exit',0

        dc.b    1,BASE_X+2,BASE_Y+39
        dc.b    'Press . (dot) to quit game',0

        dc.b    1,BASE_X+2,BASE_Y+49
        dc.b    'Use arrows to move ship',0

        dc.b    1,BASE_X+2,BASE_Y+59
        dc.b    'Use +/- to adjust contrast',0

        dc.b    1,BASE_X+2,BASE_Y+69
   IFND ti89
        dc.b    'Press LOCK to shoot',0
   ENDIF
   IFD ti89
        dc.b    'Press 2nd to shoot',0
   ENDIF

        dc.b    1,BASE_X+2,BASE_Y+86
        dc.b    'Press F3 for next page',0

        dc.b    0

instructions_3:
        dc.b    1,BASE_X+1,BASE_Y+1
        dc.b    'I can be reached by E-Mail',0

        dc.b    1,BASE_X+2,BASE_Y+10
        dc.b    'at pad@ocf.berkeley.edu.',0

        dc.b    1,BASE_X+2,BASE_Y+19
        dc.b    'Please give the version',0

        dc.b    1,BASE_X+2,BASE_Y+28
        dc.b    'number of the game in all',0

        dc.b    1,BASE_X+2,BASE_Y+37
        dc.b    'messages about it.  If you',0

        dc.b    1,BASE_X+2,BASE_Y+46
        dc.b    'find a bug, be sure to',0

        dc.b    1,BASE_X+2,BASE_Y+55
        dc.b    'describe it in detail.',0

        dc.b    1,BASE_X+2,BASE_Y+66
        dc.b    'My web site is http://',0
                                 
        dc.b    1,BASE_X+2,BASE_Y+75
        dc.b    'www.ocf.berkeley.edu/~pad',0

        dc.b    1,BASE_X+2,BASE_Y+86
        dc.b    'Press F4 for next page',0

        dc.b    0

instructions_4:
        dc.b    2,BASE_X+12,BASE_Y+1
        dc.b    'The boring stuff:',0

        dc.b    1,BASE_X+2,BASE_Y+13
        dc.b    'This program is in the',0
                                 
        dc.b    1,BASE_X+2,BASE_Y+22
        dc.b    'public domain so it can be',0

        dc.b    1,BASE_X+2,BASE_Y+31
        dc.b    'copied or modified with no',0

        dc.b    1,BASE_X+2,BASE_Y+40
        dc.b    'restrictions.  The source',0

        dc.b    1,BASE_X+2,BASE_Y+49
        dc.b    'code is available on the',0

        dc.b    1,BASE_X+2,BASE_Y+58
        dc.b    'web site.  There is no',0

        dc.b    1,BASE_X+2,BASE_Y+67
        dc.b    'warranty of any kind for',0

        dc.b    1,BASE_X+2,BASE_Y+76
        dc.b    'this program.',0

        dc.b    1,BASE_X+2,BASE_Y+86
        dc.b    'Press F1 to conitnue.',0

        dc.b    0

select_difficulty:
        dc.b    2,BASE_X+8,BASE_Y+5
        dc.b    'Choose Skill Level',0

        dc.b    1,BASE_X+22,BASE_Y+29
        dc.b    '1 - Beginner',0

        dc.b    1,BASE_X+22,BASE_Y+39
        dc.b    '2 - Intermediate',0

        dc.b    1,BASE_X+22,BASE_Y+49
        dc.b    '3 - Advanced',0

        dc.b    1,BASE_X+22,BASE_Y+59
        dc.b    '4 - Expert',0

        dc.b    1,BASE_X+22,BASE_Y+69
        dc.b    '5 - You asked for it!',0

        dc.b    0

        EVEN
