***************************************************************************
****************************************************************************
**                                                               
**  Mercury (Variable handling)
**
**  Copyright 2002 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (eeulplek@hotmail.com)
**  http://www.ocf.berkeley.edu/~pad/
**                  
**  Last updated April 20, 2002
**
****************************************************************************
****************************************************************************

*************************************** locate data file VAT entry

find_it:
        pea     variable_name(pc)
        JSR_ROM SymFind                 ; get SYM_ENTRY in D0
        move.l  d0,-(sp)
        JSR_ROM DerefSym                ; get VAT entry pointer in A0
        addq.w  #8,sp
        rts

        dc.b    0
        dc.b    'mercsave'
variable_name:
        dc.b    0
        EVEN

*************************************** get variable pointer in A0

_get_data_file:
        bsr.s   find_it                 ; get VAT entry pointer in A0
        move.l  a0,d0
        beq.s   \failed
        move.w  12(a0),-(sp)            ; push handle of variable data
        JSR_ROM HeapDeref               ; dereference heap entry (A0->data)
        addq.w  #2,sp

\failed:
        rts

*************************************** Create save file
*
* Deletes file if it already exists.
* Takes size in D6.
* Returns pointer to variable start in A0.
*
********

_create_save_file:
        clr.l   -(sp)
        pea     variable_name(pc)
        JSR_ROM EM_moveSymFromExtMem    ; unarchive variable

        pea     variable_name(pc)
        JSR_ROM SymDel                  ; delete variable

        ext.l   d6
        move.l  d6,-(sp)
        JSR_ROM HeapAlloc               ; allocate memory (D0.w = handle)
        add.w   #16,sp
        move.w  d0,d3                   ; D3 = handle
        beq.s   \failed

        pea     variable_name(pc)
        JSR_ROM SymAdd                  ; create variable (D0 = SYM_ENTRY)
        move.l  d0,-(sp)
        JSR_ROM DerefSym                ; get VAT entry in A0
        move.l  a0,d4                 
        beq.s   \var_create_failed

        move.w  d3,12(a0)               ; save data handle in VAT entry

        move.w  d3,-(sp)
        JSR_ROM HeapDeref               ; get data pointer in A0
        add.w   #10,sp
        rts

\failed:
        suba.l  a0,a0
        rts

\var_create_failed:
        move.w  d3,-(sp)                ; free heap entry
        JSR_ROM HeapFree
        add.w   #10,sp
        suba.l  a0,a0
        rts
