****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Enemy destruction)
**
**  Copyright 2000 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated August 4, 2000
**
****************************************************************************
****************************************************************************

********************************************** ENEMY DESCTRUCTION ROUTINES
*
* This file consists of enemy destruction routines.  These routines are
* called when an enemy is destroyed, with A4 pointing to the address of the
* enemy structure.  The routine should "destroy" the enemy by changing its
* type to an explosion.  Also, special actions are possible, such as making
* the enemy become another enemy type, for enemies which must be destroyed
* in stages.  Each routine should preserve D3, D4, A2, A3, and A4.
*
* The address of the enemy destruction routine (as a word offset from the
* label Destroy_Base) is stored in the e_dstry field of each enemy structure.
*
********

EDestruct_MBL:
        move.w  e_dmg(a4),d0    
        add.w   d0,e_dmg-e_size(a4)     
        move.w  #1,e_dmg(a4)    
        rts     

EDestruct_MBR:
        move.w  e_dmg(a4),d0    
        add.w   d0,e_dmg-2*e_size(a4)   
        move.w  #1,e_dmg(a4)    
        rts     

EDestruct_MBC:
        move.w  #MEGABOSS_DIE,e_size(a4)        
        move.w  #MEGABOSS_DIE,2*e_size(a4)      
        move.w  #-2,e_data+e_size(a4)   
        move.w  #2,e_data+2*e_size(a4)  

EDestruct_Normal:
        cmp.w   #SPINNER3,(a4)
        beq.s   EDestruct_Solid           
        cmp.w   #SPINNER3M,(a4)
        beq.s   EDestruct_Solid           
EDestruct_Explode:                                        
        move.w  #-10000,e_h(a4) 
        cmp.w   #15,e_w(a4)     
        bge.s   edl     
        move.w  #EXPLODE,(a4)   
        move.w  #in_Explosion1,e_image(a4)      
        rts     

edl:    move.w  #EXPLODE2,(a4)  
        move.w  #in_LExplosion1,e_image(a4)     
        rts     

EDestruct_Solid:                        ; Solid enemy
        moveq   #6,d0   
        bsr     random  
        add.w   difficulty(a5),d0       ; D0 from diff to diff + 5
        cmp.w   #5,d0   
        ble.s   EDestruct_Explode       ; Use normal destruction

        move.w  #SPINNER4M,(a4) 
        subq.w  #2,e_h(a4)      
        subq.w  #2,e_w(a4)      
        move.w  #8,e_dmg(a4)    
        move.w  #$101,e_data(a4)        
        move.w  #EDestruct_Normal-Destroy_Base,e_dstry(a4)
        rts

EDestruct_Boss:
        move.w  #EXPLODE2,(a4)  
        move.w  #-10000,e_h(a4) 
        move.w  #in_LExplosion1,e_image(a4)     

        cmp.w   #18,-e_size(a4)         ; Previous/next superboss part
        bne.s   not_type_18_prev        
        addq.w  #8,-e_size+e_image(a4)  
        bra.s   boss_explode_done       
not_type_18_prev:
        cmp.w   #20,e_size(a4)  
        bne.s   boss_explode_done       
        addq.w  #8,e_size+e_image(a4)   

boss_explode_done:
        rts     

