****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Game over routines)
**
**  Copyright 2004 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated September 14, 2004
**
****************************************************************************
****************************************************************************

    IFND ti89d   
EG_FONT set     2       
EG_TY   set     16      
EG_TX   set     65      
EG_SY   set     36      
EG_SPACE set    11      
EG_FY   set     80      
EG_HS1  set     96      
EG_HS2  set     108     
IS89    set     0       
    ENDIF   

    IFD ti89d
EG_FONT set     1       
EG_TY   set     12      
EG_TX   set     45      
EG_SY   set     22      
EG_SPACE set    8       
EG_FY   set     56      
EG_HS1  set     80      
EG_HS2  set     90      
IS89    set     1       
    ENDIF   

******************************************** GAME FINISHED

Game_Finished:
        tst.b   game_finished(a5)       
        bne     Game_Restart    
        st      game_finished(a5)       

        moveq   #0,d0                   ; Re-enable interrupts
        trap    #1      
        bsr     Clear_Screen    

        moveq   #EG_FONT,d0     
        bsr     Set_Font                ; Set font to very large

        lea     endt1(pc),a0            ; Phoenix - Game Completed
        moveq   #2,d0   
        moveq   #14,d1  
        bsr     Display_String  

        lea     endt2(pc),a0            ; Final Scoring:
        moveq   #EG_TY,d0       
        moveq   #EG_TX,d1       
        bsr     Display_String  

        lea     endt3(pc),a0            ; Difficulty score
        move.w  difficulty(a5),d0       
        mulu    #50000,d0       
        add.l   #100000,d0      

    IFD ti89d   
        cmp.w   #$e1,speed(a5)  
        bne.s   No_Speed_Bonus  
        add.l   #75000,d0       
No_Speed_Bonus:
    ENDIF   

        move.l  d0,d6   
        moveq   #EG_SY,d7       
        bsr     Display_Score   

        lea     endt4(pc),a0            ; Time score
        move.l  time_bonus(a5),d0       
        add.l   d0,d6   
        moveq   #EG_SY+EG_SPACE,d7      
        bsr     Display_Score   

        lea     endt5(pc),a0            ; Shield score
        move.w  player_dmg(a5),d0       
        mulu    #4000,d0        
        add.l   d0,d6   
        moveq   #EG_SY+EG_SPACE*2,d7    
        bsr     Display_Score   

        lea     endt6(pc),a0            ; Cash score
        move.w  cash(a5),d0     
        mulu    #20,d0  
        add.l   d0,d6   
        moveq   #EG_SY+EG_SPACE*3,d7    
        bsr     Display_Score   

        tst.b   cheated(a5)     
        beq.s   did_not_cheat   
        moveq   #0,d6   
did_not_cheat:
        lea     endt7(pc),a0            ; Total score
        move.l  d6,d0   
        moveq   #EG_FY,d7       
        bsr.s   Display_Score   

        lea     High_Score_Data+192(pc),a2      ; See if player entered table
        moveq   #-7,d4                  ; D4 = # longs to shift down
find_place_loop:
        cmp.l   -(a2),d6        
        ble.s   not_beaten      
        addq.w  #6,d4   
        lea     -20(a2),a2      
        bra.s   find_place_loop 
not_beaten:
        cmp.w   #-7,d4  
        beq.s   no_high_score   

        tst.w   d4      
        blt.s   no_shift_scores 
        lea     High_Score_Data+192(pc),a4      
        lea     High_Score_Data+168(pc),a3      
shift_scores:
        move.l  -(a3),-(a4)     
        dbra    d4,shift_scores 
no_shift_scores:
        move.l  d6,24(a2)       
        addq.l  #4,a2                   ; A2 -> Name entry place
        bsr     Input_Name      
        bra.s   scores_ready    

no_high_score:
        moveq   #EG_HS1,d0              ; Sorry - No Highscore
        moveq   #0,d1   
        lea     endt8(pc),a0    
        bsr     Display_String  

        moveq   #EG_HS2,d0              ; Press enter to continue
        moveq   #0,d1   
        lea     endt10(pc),a0   
        bsr     Display_String  

gf_wait_enter:
        bsr     Get_Key 
        cmp.w   #13,d0  
        bne.s   gf_wait_enter   

scores_ready:
        bsr     Display_High_Scores     
    IFND ti89d   
        move.w  #$400,d0        
        trap    #1      
    ENDIF   
        bsr     Status_Prepare  
Game_Restart:
        clr.w   level_number(a5)        
        bra     Next_Level      

Display_Score:
        lea     _string_buffer(a5),a4   ; A4 -> string buffer
        move.l  d0,-(sp)                ; Push number
        pea     (a0)                    ; Push string
        pea     (a4)                    ; Push buffer address
        jsr     ____sprintf   
        lea     12(sp),sp       
        lea     (a4),a0 
        moveq   #3,d1   
        move.l  d7,d0   
        bra     Display_String  

******************************************** DISPLAY HIGH SCORES

Display_High_Scores:
        bsr     Clear_Screen            ; Display high scores
        moveq   #EG_FONT,d0     
        bsr     Set_Font                ; Set font
        lea     endt11(pc),a0   
        moveq   #2,d0   
        moveq   #34-(IS89*10),d1        
        bsr     Display_String  

        moveq   #EG_HS2,d0              ; Press enter to continue
        moveq   #0,d1   
        lea     endt10(pc),a0   
        bsr     Display_String  

        lea     High_Score_Data(pc),a3      
        moveq   #18-(IS89*4),d7 
        moveq   #7,d6   
hs_show_loop:
        move.l  d7,d0   
        moveq   #1,d1   
        lea     (a3),a0 
        bsr     Display_String  
        lea     20(a3),a3       
        move.l  (a3)+,-(sp)     
        pea     endt7-5(pc)     
        pea     _string_buffer(a5)      
        jsr     ____sprintf   
        lea     12(sp),sp       
        lea     _string_buffer(a5),a0   
        move.l  d7,d0   
        move.w  #156-(40*IS89),d1       
        bsr     Display_String  
        add.w   #11-(3*IS89),d7 
        dbra    d6,hs_show_loop 

hs_wait_enter:
        bsr     Get_Key 
        cmp.w   #13,d0  
        bne.s   hs_wait_enter   
        rts     

******************************************** GET PLAYER'S NAME

Input_Name:
        lea     (a2),a4                 ; A4 -> Entry area
        moveq   #18,d0  
in_loop_clear:
                                        ; Blank out the name
        move.b  #32,(a2)+       
        dbra    d0,in_loop_clear        
        lea     (a4),a1 
        moveq   #0,d6                   ; D6 = Character number

        moveq   #EG_HS1,d0              ; Sorry - No Highscore
        moveq   #0,d1   
        lea     endt9(pc),a0    
        bsr     Display_String  

inpuths:
        lea     (a4),a0                 ; Display text
        moveq   #EG_HS2,d0      
        moveq   #0,d1   
        bsr     Display_String  
        bsr     Get_Key                 ; Read a keypress
        cmp.w   #13,d0                  ; Done if [ENTER] pressed
        beq.s   done_hs 
        cmp.w   #255,d0 
        ble.s   char    
        cmp.w   #257,d0 
        beq.s   backsp  
        bra.s   inpuths 
backsp: tst.w   d6      
        beq.s   inpuths 
        sub.w   #1,d6   
        move.b  #32,0(a4,d6.w)  
        bra.s   inpuths 
char:   cmp.w   #19,d6  
        beq.s   inpuths 
        move.b  d0,0(a4,d6.w)   
        addq.w  #1,d6   
        bra.s   inpuths 
done_hs:
        rts     

******************************************** SCORING DATA

endt1:  dc.b    PHOENIX,' - Game Completed',0    
endt2:  dc.b    'Final Scoring:',0      
endt3:  dc.b    'Difficulty         %7ld',0     
endt4:  dc.b    'Time left          %7ld',0     
endt5:  dc.b    'Shield level       %7ld',0     
endt6:  dc.b    'Extra cash         %7ld',0     
endt7:  dc.b    'Total score        %7ld',0     
endt8:  dc.b    'You don''t have a highscore.',0        
endt9:  dc.b    'Highscore!  Enter',YOU,'r name',0 
endt10: dc.b    '> Press enter',_TO,'continue <',0 
endt11: dc.b    PHOENIX,' High Scores',0 
        CNOP    0,2     

        dc.l    2147483647      
High_Score_Data:
        dc.b    'Phoenix 7.5        ',0 
        dc.l    600000  
        dc.b    'Phoenix 7.42       ',0 
        dc.l    550000  
        dc.b    'Phoenix 7.4        ',0 
        dc.l    500000  
        dc.b    'Phoenix 7.3        ',0 
        dc.l    450000  
        dc.b    'Phoenix 7.2        ',0 
        dc.l    400000  
        dc.b    'Phoenix 7.02       ',0 
        dc.l    360000  
        dc.b    'Phoenix 7.01       ',0 
        dc.l    340000  
        dc.b    'Phoenix 7.0        ',0 
        dc.l    320000  
