****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Level Definitions)
**
**  Copyright 2000 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated July 30, 2000
**
****************************************************************************
****************************************************************************

******************************************** LEVEL DATA
*
* The tables below are the lists of levels that will be played in each
* difficulty level.  The use of these tables is described right before the
* level loader routine, which follows these tables.
*
********

level_table_easy:
        dc.b    LVL_1A,LVL_1B
        dc.b    LVL_1C,LVL_Shop
        dc.b    LVL_2A,LVL_2B,LVL_2C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_3A,LVL_3B,LVL_3C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_4A,LVL_4B,LVL_4C,LVL_Shop   
        dc.b    LVL_5A,LVL_5B,LVL_5C,LVL_Shop   
        dc.b    LVL_6A,LVL_6B,LVL_6C,LVL_Shop   
        dc.b    LVL_7A,LVL_7B,LVL_7C,LVL_Shop   
        dc.b    LVL_8A,LVL_8B,LVL_8C,LVL_Shop
        dc.b    LVL_Swoop,LVL_SuperBoss,LVL_Free_Ship,LVL_Shop  
        dc.b    LVL_Wheel5,LVL_MWheel8,LVL_Shop 
        dc.b    LVL_X1,LVL_X2,LVL_X3
        dc.b    LVL_MegaBoss,LVL_Restart        

level_table_medium:
        dc.b    LVL_1A,LVL_1B,LVL_1C,LVL_Shop   
        dc.b    LVL_2A,LVL_2B,LVL_2C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_3A,LVL_3B,LVL_3C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_4A,LVL_4B,LVL_4C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_5A,LVL_5B,LVL_5C,LVL_Shop   
        dc.b    LVL_6A,LVL_6B,LVL_6C,LVL_Shop   
        dc.b    LVL_7A,LVL_7B,LVL_7C,LVL_Shop   
        dc.b    LVL_8A,LVL_8B,LVL_8C,LVL_Shop   
        dc.b    LVL_Swoop,LVL_SuperBoss,LVL_Free_Ship,LVL_Shop  
        dc.b    LVL_Wheel5,LVL_Wheel8,LVL_MWheel10,LVL_Shop     
        dc.b    LVL_X1,LVL_X2,LVL_X3,LVL_Shop   
        dc.b    LVL_O,LVL_O3,LVL_O5,LVL_O5      
        dc.b    LVL_Swoop,LVL_SuperBoss_Plus    
        dc.b    LVL_MegaBoss,LVL_Restart        

level_table_hard:
        dc.b    LVL_1A,LVL_1B,LVL_1C,LVL_Shop   
        dc.b    LVL_2A,LVL_2B,LVL_2C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_3A,LVL_3B,LVL_3C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_4A,LVL_4B,LVL_4C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_5A,LVL_5B,LVL_5C,LVL_Shop   
        dc.b    LVL_6A,LVL_6B,LVL_6C,LVL_Shop   
        dc.b    LVL_7A,LVL_7B,LVL_7C,LVL_Shop   
        dc.b    LVL_8A,LVL_8B,LVL_8C,LVL_Shop   
        dc.b    LVL_Swoop,LVL_SuperBoss,LVL_Shop        
        dc.b    LVL_Wheel5,LVL_Wheel8,LVL_Wheel10,LVL_MWheel15,LVL_Shop 
        dc.b    LVL_X1,LVL_X2,LVL_X3,LVL_Shop   
        dc.b    LVL_O,LVL_O3,LVL_O5,LVL_O5      
        dc.b    LVL_Swoop,LVL_SuperBoss_Plus    
        dc.b    LVL_MegaBoss,LVL_Restart        

level_table_expert:
        dc.b    LVL_1A,LVL_1B,LVL_1C,LVL_Shop   
        dc.b    LVL_2A,LVL_2B,LVL_2C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_3A,LVL_3B,LVL_3C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_4A,LVL_4B,LVL_4C,LVL_Triangles,LVL_Shop     
        dc.b    LVL_5A,LVL_5B,LVL_5C,LVL_Shop   
        dc.b    LVL_6A,LVL_6B,LVL_6C,LVL_Shop   
        dc.b    LVL_7A,LVL_7B,LVL_7C,LVL_Shop   
        dc.b    LVL_8A,LVL_8B,LVL_8C,LVL_Shop   
        dc.b    LVL_Swoop,LVL_SuperBoss,LVL_Shop        
        dc.b    LVL_Wheel5,LVL_Wheel8,LVL_Wheel10,LVL_MWheel15,LVL_Shop 
        dc.b    LVL_X1,LVL_X2,LVL_X3,LVL_Shop   
        dc.b    LVL_O,LVL_O3,LVL_O5,LVL_O5      
        dc.b    LVL_Swoop,LVL_SuperBoss_Plus,LVL_Swoop,LVL_SuperBoss_Plus       
        dc.b    LVL_MegaBoss,LVL_Restart        

        EVEN    

******************************************** LIST OF LEVEL DATA TABLES
*
* This table is a list of pointers, which holds a level list for each
* difficulty level.
*
********

Level_Sets:
        dc.w    level_table_easy-Level_Sets     
        dc.w    level_table_medium-Level_Sets   
        dc.w    level_table_hard-Level_Sets     
        dc.w    level_table_expert-Level_Sets   

******************************************** LOAD NEXT LEVEL
*
* This routine initializes the next level.  It is called from the game's main
* loop whenever no enemies remain.  It is responsible for initializing the
* next level.  There are 2 types of level definitions:
*
* Code: For such levels, there is actually a section of executable code which
*       is used to set up the level.  This allows maximum flexibility in
*       initializing data structures.  It also allows special levels, such as
*       the shop, which do not contain any gameplay at all.
*
* Data: For most normal levels, simple data structures list the quantity and
*       types of enemies.
*
* These two are distinguished in the table by adding 1 to the offset of the
* level (since the levels must be word-aligned, all offsets would normally
* be even).
*
* The code levels themselves will be called with A1 pointing to enemies_data,
* and D6 containg the default enemy destuction routine (these values are
* useful as defaults for the enemy installation code).
*
* The first step in initializing a level is to find the level index (that
* is, the index in the level table).  First, the list of levels for the
* particular difficulty level is located.  This is done by using the
* difficulty level as in index into the Level_Sets table above to obtain the
* offset of the level table (as a word) and from that the address of the
* level table itself.  Then, the current position in the game (level_number)
* is added to that address, and the byte there is the level index.
*
* Once the level index is known, the level itself can then be located.  The
* next step is to get the level's offset.  This is done by indexing into
* Level_Table, which yields the level's address, as an offset from
* Level_Table.  If this offset is an odd number, it is decremented by 1 to
* find the real offset, and the data interpreter is called.  Otherwise, the
* level itself, which is executable code, will be run.
*
********

Next_Level:
        clr.w   special_weapon_delay(a5)        

        move.w  difficulty(a5),d0       ;D0 = difficulty level
        add.w   d0,d0                   ;D0 = index into Level_Sets + 2
        move.w  Level_Sets-2(pc,d0.w),d0        ;D0 = offset of level list
        lea     Level_Sets(pc,d0.w),a0  ;A0 -> level list

        add.w   level_number(a5),a0     ;A0 -> level index
        addq.w  #1,level_number(a5)     ;increment level number
        moveq   #0,d0   
        move.b  (a0),d0                 ;D0 = level index

        lea     enemies_data(a5),a1     
        move.w  #EDestruct_Normal-Destroy_Base,d6       

        add.w   d0,d0                   ;D0 = index into Level_Table
        move.w  Level_Table(pc,d0.w),d0 ;D0 = offset of level's code
        btst    #0,d0
        bne.s   Level_Interpreter
        jmp     Level_Table(pc,d0.w)    ;Jump to level's code

Level_Interpreter:
        lea     Level_Table-1(pc,d0.w),a3
        move.w  (a3)+,d7
        btst    #9,d7                   ;Bit 9 set = special wheel level
        bne     Wheel_Loader_Init
        btst    #8,d7                   ;Bit 8 set = use coordinate table
        beq.s   no_ldb
        move.w  (a3)+,d5
        lea     Level_Table(pc,d5.w),a4
no_ldb: and.w   #31,d7                  ;D1 = number of entries
lil:    move.w  (a3)+,d0                ;D0 = number of this enemy
        move.w  (a3)+,d1
        lea     Level_Table(pc,d1.w),a0
        bsr     Load_Enemy_Info
        dbra    d7,lil
        rts

********************************************* LEVEL TABLE
*
* This is the table of levels used to decode level number bytes, as is
* described in 'LEVELS.ASM'.  The LEVEL macro adds one entry to the table
* (as a word offset from the start of the table), sets a symbol of the level
* name to the current level number, then increments the number.  The LDATA
* macro does the same, except the offset is increased by 1 to denote that
* this level is described by a data table.
*
********

numlev  set     0       

LEVEL   MACRO   
        dc.w    \1-Level_Table  
\2      set     numlev  
numlev  set     numlev+1        
        ENDM

LDATA   MACRO
        dc.w    \1+1-Level_Table
\2      set     numlev  
numlev  set     numlev+1        
        ENDM

Level_Table:
        LEVEL   Game_Finished,LVL_Restart       
        LEVEL   Phoenix_Shop,LVL_Shop   

        LEVEL   Triangles,LVL_Triangles 

        LDATA   Level_1_Standard,LVL_1A 
        LDATA   Level_2_Standard,LVL_1B 
        LDATA   Level_3_Boss,LVL_1C     

        LDATA   Level_4_Standard,LVL_2A 
        LDATA   Level_5_Standard,LVL_2B 
        LDATA   Level_6_Boss,LVL_2C     

        LDATA   Level_4a_Standard,LVL_3A        
        LDATA   Level_5a_Standard,LVL_3B        
        LDATA   Level_6a_Boss,LVL_3C    

        LDATA   Level_7_Standard,LVL_4A 
        LDATA   Level_8_Standard,LVL_4B 
        LDATA   Level_9_Boss,LVL_4C     

        LDATA   Level_10_Standard,LVL_5A        
        LDATA   Level_11_Standard,LVL_5B        
        LDATA   Level_12_2Boss,LVL_5C   

        LDATA   Level_13_Standard,LVL_6A        
        LDATA   Level_14_Standard,LVL_6B        
        LEVEL   Level_15_3Boss,LVL_6C   

        LDATA   Level_7A,LVL_7A        
        LDATA   Level_7B,LVL_7B        
        LDATA   Level_7C,LVL_7C    

        LDATA   Level_19_Standard,LVL_8A        
        LDATA   Level_20_Standard,LVL_8B        
        LEVEL   Level_21_3Boss,LVL_8C   

        LEVEL   Level_Swoop,LVL_Swoop   
        LEVEL   Level_25_SuperBoss,LVL_SuperBoss        
        LEVEL   Level_25_SuperBoss_Hard,LVL_SuperBoss_Hard      
        LEVEL   Level_29_SuperBoss_Plus,LVL_SuperBoss_Plus      

        LEVEL   Free_Ship,LVL_Free_Ship 

        LDATA   MWheel_Loop_20,LVL_MWheel20     
        LDATA   MWheel_Loop_15,LVL_MWheel15     
        LDATA   MWheel_Loop_10,LVL_MWheel10     
        LDATA   MWheel_Loop_8,LVL_MWheel8       
        LDATA   Wheel_Loop_16,LVL_Wheel16       
        LDATA   Wheel_Loop_10,LVL_Wheel10       
        LDATA   Wheel_Loop_8,LVL_Wheel8 
        LDATA   Wheel_Loop_5,LVL_Wheel5 

        LEVEL   Level_33_RandX,LVL_X1   
        LEVEL   Level_34_RandX,LVL_X2   
        LEVEL   Level_35_RandX,LVL_X3   

        LEVEL   Level_26_Operators,LVL_O        
        LEVEL   Level_27_Operators_3Boss,LVL_O3 
        LEVEL   Level_28_Operators_5Boss,LVL_O5 

        LEVEL   MegaBoss,LVL_MegaBoss

******************************************** LEVEL DEFINITION MACROS

LVL     MACRO
        dc.w    \1-1
        ENDM

LVLDB   MACRO
        dc.w    $100+\1-1
        dc.w    \2-Level_Table
        ENDM

LENTRY  MACRO
        dc.w    \1
        dc.w    \2-Level_Table
        ENDM

LWHEEL  MACRO
        dc.w    $200
        dc.b    \1,\2
        ENDM

LMWHEEL MACRO
        dc.w    $300
        dc.b    \1,\2
        ENDM

Choose  equ     Level_Table-1

******************************************** LEVEL LOADERS
*
* These are the actual level loaders called to initialize each level.  The
* loaders for fake levels (the shop, etc.) are contained in their specific
* files.  For the levels specified by data, use the following macros:
*
* "LVL n" at the start of a level with n entries
* "LVLDB n,db" at the start of a level with n entries, using data bank db
*       for coordinate data
*
* "LENTRY n,type" to insert n enemies of type type
*
* "LWHEEL n,sep" wheel level, n wheels, separated by sep pixels
*
* "LMWHEEEL n,sep" as above, but with wheels in larger route
*
********

Level_1_Standard:
        LVLDB   1,standard_data_bank
        LENTRY  20,Enemy_1

Level_2_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_1

Level_3_Boss:
        LVLDB   2,low_data_bank
        LENTRY  10,Enemy_1
        LENTRY  1,E_Boss1

Level_4_Standard:
        LVLDB   2,standard_data_bank
        LENTRY  10,Enemy_2
        LENTRY  10,Enemy_1

Level_5_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_2

Level_6_Boss:
        LVLDB   2,low_data_bank
        LENTRY  10,Enemy_2
        LENTRY  1,E_Boss1

Level_4a_Standard:
        LVLDB   2,standard_data_bank
        LENTRY  10,Choose
        LENTRY  10,Enemy_1

Level_5a_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Choose

Level_6a_Boss:
        LVLDB   2,low_data_bank
        LENTRY  10,Choose
        LENTRY  1,E_Boss1

Level_7_Standard:
        LVLDB   1,standard_data_bank
        LENTRY  15,Enemy_5

Level_8_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_5

Level_9_Boss:
        LVLDB   2,low_data_bank
        LENTRY  10,Enemy_5
        LENTRY  1,E_Boss1

Level_10_Standard:
        LVLDB   1,standard_data_bank
        LENTRY  15,Enemy_3

Level_11_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_3

Level_12_2Boss:
        LVLDB   3,low_data_bank
        LENTRY  10,Enemy_5
        LENTRY  1,E_Boss1
        LENTRY  1,E_Boss2

Level_13_Standard:
        LVLDB   2,standard_data_bank
        LENTRY  10,Enemy_4
        LENTRY  10,Enemy_3

Level_14_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_4

Level_15_3Boss:
        lea     low_data_bank(pc),a4        
        lea     Enemy_4(pc),a0  
        moveq   #10,d0  
        bsr     Load_Enemy_Info 
        lea     E_Boss2(pc),a0  
        moveq   #3,d0   
        bsr     Load_Enemy_Info 
        move.w  #-210,-e_size+e_data(a1)        
        move.w  #-270,-(2*e_size)+e_data(a1)    
        rts     

Level_7A:
        LVLDB   1,standard_data_bank
        LENTRY  20,Enemy_6

Level_7B:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_6

Level_7C:
        LVLDB   2,multi_data_bank
        LENTRY  24,Enemy_6
        LENTRY  1,E_Boss3

Level_19_Standard:
        LVLDB   2,standard_data_bank
        LENTRY  10,Enemy_7
        LENTRY  10,Enemy_3

Level_20_Standard:
        LVLDB   1,swing_data_bank
        LENTRY  20,Enemy_7

Level_21_3Boss:
        lea     low_data_bank(pc),a4        
        lea     Enemy_7(pc),a0  
        moveq   #10,d0  
        move.w  #EDestruct_Solid-Destroy_Base,d6        
        bsr     Load_Enemy_Info 
        move.w  #EDestruct_Normal-Destroy_Base,d6       
        lea     E_Boss2(pc),a0  
        moveq   #3,d0   
        bsr     Load_Enemy_Info 
        move.w  #-210,-e_size+e_data(a1)        
        move.w  #-270,-(2*e_size)+e_data(a1)    
        rts     

Level_25_SuperBoss_Hard:
        lea     low_data_bank(pc),a4        
        lea     Enemy_9(pc),a0  
        moveq   #10,d0  
        bsr     Load_Enemy_Info 
Level_25_SuperBoss:
        move.w  #EDestruct_Boss-Destroy_Base,d6 
        lea     E_fake(pc),a0   
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        lea     E_SupL(pc),a0   
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        lea     E_SupR(pc),a0   
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        subq.w  #1,enemies_remaining(a5)        
        rts     

Level_26_Operators:
        move.b  #64,smct+1      
        lea     Enemy_0(pc),a0  
        moveq   #12,d0  
        bra     Load_Enemy_Info 

Level_27_Operators_3Boss:
        lea     Enemy_0(pc),a0  
        moveq   #12,d0  
        bsr     Load_Enemy_Info 
        lea     E_Boss2(pc),a0  
        moveq   #3,d0   
        bsr     Load_Enemy_Info 
        move.w  #-180,-e_size+e_data(a1)        
        move.w  #-120,-(2*e_size)+e_data(a1)    
        rts     

Level_28_Operators_5Boss:
        lea     Enemy_0(pc),a0  
        moveq   #20,d0  
        bsr     Load_Enemy_Info 
        lea     E_Boss2(pc),a0  
        moveq   #5,d0   
        bsr     Load_Enemy_Info 
        move.w  #-210,-e_size+e_data(a1)        
        move.w  #-240,-(2*e_size)+e_data(a1)    
        move.w  #-180,-(3*e_size)+e_data(a1)    
        move.w  #-120,-(4*e_size)+e_data(a1)    
        rts     

Level_29_SuperBoss:
        lea     E_fake(pc),a0   
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        lea     E_SupL(pc),a0   
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        lea     E_SupR(pc),a0   
L29_Common:
        moveq   #1,d0   
        move.w  #EDestruct_Boss-Destroy_Base,d6 
        bsr     Load_Enemy_Info 
        subq.w  #1,enemies_remaining(a5)        
        lea     Enemy_0(pc),a0  
        moveq   #22,d0  
        bra     Load_Enemy_Info 

Level_29_SuperBoss_Plus:
        lea     E_fake(pc),a0   
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        lea     E_SupL_(pc),a0  
        moveq   #1,d0   
        bsr     Load_Enemy_Info 
        lea     E_SupR_(pc),a0  
        bra.s   L29_Common      

Level_33_RandX:
        move.b  #98,smct+1      
        lea     E_X(pc),a0      
        moveq   #12,d0  
        bra     Load_Enemy_Info 

Level_34_RandX:
        lea     E_X(pc),a0      
        moveq   #12,d0  
        bsr     Load_Enemy_Info 
        lea     E_Boss2(pc),a0  
        moveq   #3,d0   
        bsr     Load_Enemy_Info 
        move.w  #-180,-e_size+e_data(a1)        
        move.w  #-120,-(2*e_size)+e_data(a1)    
        rts     

Level_35_RandX:
        lea     E_X(pc),a0      
        moveq   #20,d0  
        bsr     Load_Enemy_Info 
        lea     E_Boss2(pc),a0  
        moveq   #5,d0   
        bsr     Load_Enemy_Info 
        move.w  #-210,-e_size+e_data(a1)        
        move.w  #-240,-(2*e_size)+e_data(a1)    
        move.w  #-180,-(3*e_size)+e_data(a1)    
        move.w  #-120,-(4*e_size)+e_data(a1)    
        rts     

MWheel_Loop_20:
        LMWHEEL 20,18

MWheel_Loop_15:
        LMWHEEL 15,24

MWheel_Loop_10:
        LMWHEEL 10,36

MWheel_Loop_8:
        LMWHEEL 8,45

Wheel_Loop_16:
        LWHEEL  16,10

Wheel_Loop_10:
        LWHEEL  10,16

Wheel_Loop_8:
        LWHEEL  8,20

Wheel_Loop_5:
        LWHEEL  5,32

Wheel_Loader_Init:
        move.w  #WHEEL_WAIT,d4
        btst    #8,d0
        beq.s   nmw
        move.w  #MWHEEL_WAIT,d4         ; D4 = wheel type 
nmw:    move.b  (a3)+,d1
        ext.w   d1                      ; D1 = number of wheels  
        move.b  (a3)+,d2
        ext.w   d2                      ; D2 = space beteen wheels       
        move.w  d1,enemies_remaining(a5)        
        subq.w  #1,d1
        moveq   #1,d0
        moveq   #40,d3

Wheel_Loader:
        move.w  d4,(a1)+                ; Initial type
        move.w  d3,(a1)+                ; Enemy strength
        move.w  #-300,(a1)+             ; Dummy X-coord
        move.w  #15,(a1)+               ; Width
        move.w  #-300,(A1)+             ; Dummy X-coord
        move.w  #15,(A1)+               ; Height
        move.w  #in_Wheel_1,(a1)+       ; Image
        move.w  d0,(a1)+                ; Time counter
        move.w  d6,(a1)+        
        add.w   d2,d0                   ; Increment staggering level
        dbra    d1,Wheel_Loader 
        rts     

MegaBoss:
        lea     E_MBC(pc),a0    
        moveq   #1,d0   
        move.w  #EDestruct_MBC-Destroy_Base,d6  
        bsr     Load_Enemy_Info 
        move.w  difficulty(a5),d0       
        mulu    #400,d0 
        move.w  d0,e_dmg-e_size(a1)     
        lea     E_MBL(pc),a0    
        moveq   #1,d0   
        move.w  #EDestruct_MBL-Destroy_Base,d6  
        bsr     Load_Enemy_Info 
        lea     E_MBR(pc),a0    
        moveq   #1,d0   
        move.w  #EDestruct_MBR-Destroy_Base,d6  
        bra     Load_Enemy_Info 

Level_Swoop:
        move.w  difficulty(a5),d0       
        add.w   d0,d0   
        addq.w  #8,d0   
        lea     E_Swoop(pc),a0  
        bra.s   Load_Enemy_Info 

Triangles:
        move.w  level_number(a5),d0     
        lea     E_Tri(pc),a0    

******************************************** LEVEL LOADER SUBROUTINES
*
* This routine is used to install enemies in the enemy array.  It is called
* with the following arguments:
*
* A4 -> Table of coordinates (if any)
* D0 = Number of enemies to install
* D6 = Enemy destruction routine (see EDESTROY.ASM)
* A0 -> Enemy data block
* A1 -> Position in enemy array (should be enemies_data on first call)
*
* This routine will increase the number of enemies remaining by the given
* amount, and install the specified number of enemies at the specified type.
* The main level code will call the level loader with A1 set to enemies_data
* initially so it is usually unnecessary for the level loader to set that.
* Also, D6 is the "normal" destruction routine (for non-bosses) on entry to
* the loader, so it can often be ignored also.
*
* The X and Y coordinates are both set to -300, so enemies must move
* themselves into the screen at an appropriate time.
*
* This routine changes only D0, A1, and A2.
*
* If A0 points to an odd address (which is otherwise invalid) it will select
* Enemy_8 or Enemy_9 depending on difficulty level.
*
********

Load_Enemy_Info:
        swap    d0
        move.w  a0,d0
        btst    #0,d0
        beq.s   normal_enemy_type
        lea     Enemy_8(pc),a0  
        cmp.w   #3,difficulty(a5)       
        blt.s   normal_enemy_type
        lea     Enemy_9(pc),a0
normal_enemy_type:
        swap    d0
        move.l  a4,xy_pointer(a5)
        add.w   d0,enemies_remaining(a5)        
        subq.w  #1,d0   
_Load_Enemy_Info:
        lea     (a0),a2 
        move.w  (a2)+,(a1)+     
        move.w  (a2)+,(a1)+     
        move.w  #-300,(a1)+     
        move.w  (a2)+,(a1)+     
        move.w  #-300,(a1)+     
        move.w  (a2)+,(a1)+     
        move.w  (a2)+,(a1)+     
        move.w  (a2)+,(a1)+     
        move.w  d6,(A1)+        
        dbra    d0,_Load_Enemy_Info     
        rts

******************************************** COORDINATE DATA BANKS

standard_data_bank:
        dc.w    70,20,90,20,110,20,130,20,150,20        
        dc.w    70,35,90,35,110,35,130,35,150,35        
        dc.w    70,50,90,50,110,50,130,50,150,50        
        dc.w    70,65,90,65,110,65,130,65,150,65        

swing_data_bank:
        dc.w    67,20,87,20,107,20,127,20,147,20        
        dc.w    73,35,93,35,113,35,133,35,153,35        
        dc.w    67,50,87,50,107,50,127,50,147,50        
swing_data_bank_spread:
        dc.w    73,65,93,65,113,65,133,65,153,65        
        dc.w    63,20,83,20,103,20,123,20,143,20        
        dc.w    73,35,93,35,113,35,133,35,153,35        
        dc.w    63,50,83,50,103,50,123,50,143,50        

low_data_bank:
        dc.w    70,54,90,54,110,54,130,54,150,54        
        dc.w    70,69,90,69,110,69,130,69,150,69        

multi_data_bank:
        dc.w    64,52,76,52,88,52,100,52,112,52,124,52,136,52,148,52    
        dc.w    64,61,76,61,88,61,100,61,112,61,124,61,136,61,148,61    
        dc.w    64,70,76,70,88,70,100,70,112,70,124,70,136,70,148,70    

******************************************** ENEMY DATA BLOCKS

        ;type, strength, width, height, image, data

Enemy_1:
        dc.w    STANDARD,2,8,7,in_Enemy_1,-1    ; First normal enemy
Enemy_2:
        dc.w    STANDARD,4,11,8,in_Enemy_2,-1   ; Second norMal enemy
Enemy_3:
        dc.w    SPINNER1,8,10,10,in_Enemy3_1,-1 ; Spinning enemy
Enemy_4:
        dc.w    SPINNER2,12,10,10,in_Enemy4_1,-1        ; Tough spinning enemy
Enemy_5:
        dc.w    ARROW,6,7,13,in_Enemy_5,-1      ; Tall arrowing enemy
Enemy_6:
        dc.w    CROSS,16,7,7,in_Enemy_6,-1      ; First X enemy
Enemy_7:
        dc.w    SPINNER3,20,10,10,in_Enemy7_1,-1        ; Solid spinning enemy
Enemy_8:
        dc.w    STANDARD,6,6,5,in_Enemy_8,-1    ; Third normal enemy
Enemy_9:
        dc.w    MODIFIED,6,6,5,in_Enemy_8,-1    ; Third enemy (MkII)
Enemy_0:
        dc.w    OPERATOR_LOCATING,30,7,7,in_Enemy_0_5,-1        

E_Tri:  dc.w    TRIANGLE,16,13,11,in_Triangle,$101      
E_X:    dc.w    RANDOM_X,24,9,7,in_E_X,$101     

E_Boss1:
        dc.w    BOSS,40,17,14,in_Boss_1,-90     ; Standard boss
E_Boss2:
        dc.w    BOSS,50,17,14,in_Boss_2,-150    ; Second (fuzzy center) boss
E_Boss3:
        dc.w    BOSS,100,17,9,in_Boss_X,-100    ; Double-X Boss

E_SupL: dc.w    SUPERBOSS_L,150,17,11,in_SuperBoss_Left,-5      
E_SupR: dc.w    SUPERBOSS_R,150,17,11,in_SuperBoss_Right,-5     
E_SupL_:
        dc.w    SUPERBOSS_L,250,17,15,in_SuperBoss_Left_,-5     
E_SupR_:
        dc.w    SUPERBOSS_R,250,17,15,in_SuperBoss_Right_,-5    

E_fake: dc.w    FAKE1,32767,34,-10,in_fake,-5   ; Fake enemy for attaching

E_Swoop:
        dc.w    SWOOP,40,16,10,in_Swoop1        

E_MBL:  dc.w    MEGABOSS_L,1,17,17,in_MBL,1     
E_MBC:  dc.w    MEGABOSS_C,400,17,17,in_MBC,1   
E_MBR:  dc.w    MEGABOSS_R,1,17,17,in_MBR,1     

