****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Mega-boss code)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated January 31, 2001
**
****************************************************************************
****************************************************************************

********************************************** CENTRAL MEGABOSS CODE

C_MEGABOSS_C:
        tst.w   e_y(a4) 
        bge.s   MB_normal       
        clr.w   e_y(a4) 
        move.w  #1,e_data(a4)   
        move.w  #102,e_x(a4)    
        rts     

MB_normal:
        cmp.w   #38,e_y(a4)     
        beq.s   MB_sweeping     
        addq.w  #1,e_y(a4)      
        rts     

MB_sweeping:
        move.w  cycle_counter+2(a5),d0  
        lsr.w   #1,d0   
        bcc.s   MB_shoot        
        move.w  e_x(a4),d1      
        add.w   e_data(a4),d1   
        move.w  d1,e_x(a4)      
        cmp.w   #80,d1  
        bne.s   MB_nle  
        addq.w  #2,e_data(a4)   
        lea     3*e_size(a4),a1 
        tst.w   (a1)    
        bne.s   MB_no_move      
        lea     MBW_Wheel_Left(pc),a2   
        bra     Copy_Enemy      
MB_nle: cmp.w   #142,d1 
        bne.s   MB_no_move      
        subq.w  #2,e_data(a4)   
        lea     4*e_size(a4),a1 
        tst.w   (a1)    
        bne.s   MB_no_move      
        lea     MBW_Wheel_Right(pc),a2  
        bra     Copy_Enemy      
MB_no_move:
        rts     

MB_shoot:
        move.w  d0,d1   
        and.w   #3,d1   
        add.w   d1,d1   
        jmp     MB_which_shot(pc,d1.w)  

MB_which_shot:
        rts     
        rts     
        rts     

MB_shoot_bomb:
        and.w   #$1C,d0 
        bne.s   MB_no_move      
        bsr     Locate_Free_Enemy       
        move.w  e_x(a4),d1      
        addq.w  #5,d1   
        move.w  e_y(a4),d2      
        addq.w  #8,d2   
        lea     esdata_bomb(pc),a1      
        lea     (a0),a2 
        bsr     enemy_cannon_located
        tst.w   (a2)
        beq.s   shooting_failed
        addq.w  #1,enemies_remaining(a5)
        move.w  #BOMB,(a2)      
        move.w  #EDestruct_Normal-Destroy_Base,e_dstry(a2)      
shooting_failed:
        rts

esdata_bomb:
        dc.w    20,7,in_Ball    

********************************************** ENEMY INSTALLERS

Locate_Free_Enemy:
        lea     enemies_data+5*e_size(a5),a0    
        moveq   #20,d0  
loop_find_enemy:
        tst.w   (a0)    
        beq.s   found_enemy     
        lea     e_size(a0),a0   
        dbra    d0,loop_find_enemy      
        addq.l  #4,sp   
found_enemy:
        rts     

Copy_Enemy:
        move.l  (a2)+,(a1)+     
        move.l  (a2)+,(a1)+     
        move.l  (a2)+,(a1)+     
        move.l  (a2)+,(a1)+     
        move.w  #EDestruct_Normal-Destroy_Base,(a1)+    
        addq.w  #1,enemies_remaining(a5)
        rts     

MBW_Wheel_Left:
        dc.w    MBW_Ascend,70,81,15,34,15,in_Wheel_1,-1 
MBW_Wheel_Right:
        dc.w    MBW_Ascend,70,143,15,34,15,in_Wheel_1,1 

********************************************** LEFT MEGABOSS CODE

C_MEGABOSS_R:
        move.w  e_x-2*e_size(a4),d0     
        add.w   #17,d0  
        move.w  d0,e_x(a4)      
        move.w  e_y-2*e_size(a4),e_y(a4)        
        rts     

********************************************** RIGHT MEGABOSS CODE

C_MEGABOSS_L:
        move.w  e_x-e_size(a4),d0       
        sub.w   #17,d0  
        move.w  d0,e_x(a4)      
        move.w  e_y-e_size(a4),e_y(a4)  
        rts     

********************************************** DYING MEGABOSS SIDES

C_MEGABOSS_DIE:
        move.w  e_x(a4),d0      
        add.w   e_data(a4),d0   
        move.w  d0,e_x(a4)      
        ble.s   MB_dead 
        cmp.w   #222,d0 
        bge.s   MB_dead 
        rts     
MB_dead:
        clr.w   (a4)    
        subq.w  #1,enemies_remaining(a5)        
        rts     

********************************************** GUARDING WHEEL CODE

MBW_spin:
        add.w   #in_Wheel_2-in_Wheel_1,e_image(a4)      
        cmp.w   #in_Wheel_4,e_image(a4) 
        bgt.s   MBW_rotate_start        
        rts     
MBW_rotate_start:
        move.w  #in_Wheel_1,e_image(a4) 
        rts     

C_MBW_Ascend:
        bsr.s   MBW_spin        
        subq.w  #2,e_y(a4)      
        cmp.w   #22,e_y(a4)     
        beq.s   MBW_start_slide 
        rts     

MBW_start_slide:
        move.w  #MBW_Slide,(a4) 
C_MBW_Slide:
        bsr.s   MBW_spin        
        move.w  e_x(a4),d0      
        add.w   e_data(a4),d0   
        move.w  d0,e_x(a4)      
        cmp.w   #49,d0  
        beq.s   MBW_start_descent       
        cmp.w   #193,d0 
        beq.s   MBW_start_descent       
        rts     

MBW_start_descent:
        move.w  #MBW_Descend,(a4)       
C_MBW_Descend:
        bsr.s   MBW_spin        
        addq.w  #1,e_y(a4)      
        cmp.w   #71,e_y(a4)     
        beq.s   MBW_placed      
        rts     

MBW_placed:
        move.w  #MBW_Defend,(a4)        
C_MBW_Defend:
        bsr.s   MBW_spin        
        move.w  cycle_counter+2(a5),d0  
        addq.w  #1,d0                   ; Fire on counter odd, so it
        and.w   #63,d0                  ; won't be in same frame as
        bne.s   MBW_nothing             ; main megaboss firing

        move.w  e_x(a4),d1      
        addq.w  #4,d1   
        moveq   #75,d2  
        lea     esdata_ball(pc),a1      
        bra     enemy_cannon_common     
MBW_nothing:
        rts     

********************************************** SEMI-SMART BOMB

C_BOMB: move.w  e_y(a4),d0      
        cmp.w   player_yc(a5),d0        
        bgt     EDestruct_Normal
        lea     eb_y(a4),a3
        bsr     ebx_aimed_bullet
        tst.w   (a4)
        bne.s   rts423
        subq.w  #1,enemies_remaining(a5)
rts423: rts

********************************************** MEGABOSS ENEMY TYPES

        ETYPE   MEGABOSS_L      
        ETYPE   MEGABOSS_C      
        ETYPE   MEGABOSS_R      
        ETYPE   MEGABOSS_DIE    
        ETYPE   MBW_Ascend      
        ETYPE   MBW_Slide       
        ETYPE   MBW_Descend     
        ETYPE   MBW_Defend      
        ETYPE   BOMB
