****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Player firing routines)
**
**  Copyright 2000 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated July 31, 2000
**
****************************************************************************
****************************************************************************

******************************************** SELECT PLAYER WEAPON
*
* Reads the function/number keys, and sets the selected weapon to the key
* pressed if that weapon is available.  Below are tables for both
* calculators.  The TI-89 table contains the masks as well as the bit numbers
* for each function key.  The TI-92 table contains only the masks becasue the
* bit is always 4 on it.
*
********

fkeys_table:
        IFND    ti89    
        dc.w    %1111111111111101       
        dc.w    %1111111111110111       
        dc.w    %1111111111011111       
        dc.w    %1111111101111111       
        dc.w    %1111110111111111       
        dc.w    %1111111111111011       
        dc.w    %1111111111101111       
        dc.w    %1111111110111111       
        ENDIF   
        IFD     ti89    
        dc.w    %1111111111110111,3     
        dc.w    %1111111111101111,3     
        dc.w    %1111111111111011,2     
        dc.w    %1111111111110111,2     
        dc.w    %1111111111101111,2     
        dc.w    %1111111111111011,1     
        dc.w    %1111111111110111,1     
        dc.w    %1111111111101111,1     
        ENDIF   

Player_Weapon_Select:
        lea     fkeys_table(pc),a0      
        moveq   #7,d0   
loop_pws:
        IFND    ti89    
        move.w  (a0)+,$18(a6)   
        nop     
        nop     
        nop     
        btst    #4,$1b(a6)      
        ENDIF   
        IFD     ti89    
        move.w  (a0)+,$18(a6)   
        bsr     wait_keyport    
        move.w  (a0)+,d1        
        btst    d1,$1b(a6)      
        ENDIF   

        beq.s   select_weapon   
        dbra    d0,loop_pws     
        rts     

select_weapon:
        btst    d0,weapons_available(a5)        
        beq.s   not_available   
        add.w   d0,d0   
        move.w  d0,weapon_selected(a5)  
not_available:
        rts     

********************************************** FIRE PLAYER'S BULLETS
*
* If the a bullet should be fired (e.g. the player presses the fire button,
* or holds it long enough for a repeat), calls the routine from the table
* below to insert bullets into the bullet data structure.
*
********

Player_Bullets_Shoot:
        btst    #3+IS89,$1b(a6) 
        beq.s   player_fired    
        clr.w   lock_status(a5) 
        rts     
already_fired:
        addq.w  #1,lock_status(a5)      
        rts     
player_fired:
        tst.w   lock_status(a5) 
        bne.s   already_fired   
        move.w  fire_delay(a5),lock_status(a5)  
        move.w  weapon_selected(a5),d0  
        move.w  player_xc(a5),d7        
        move.w  player_yc(a5),d6        
        add.w   player_weaponx(a5),d7   
        move.w  Player_Weapon_Jump_Table(pc,d0.w),d0    
        jmp     Player_Weapon_Jump_Table(pc,d0.w)       

Player_Weapon_Jump_Table:
        dc.w    normal_weapon-Player_Weapon_Jump_Table  
        dc.w    Double_Shoot-Player_Weapon_Jump_Table   
        dc.w    Triple_Shoot-Player_Weapon_Jump_Table   
        dc.w    Quadruple_Shoot-Player_Weapon_Jump_Table        
        dc.w    Dual_Plasma_Cannon-Player_Weapon_Jump_Table     
        dc.w    Golden_Arches-Player_Weapon_Jump_Table  
        dc.w    Triple_Plasma_Cannon-Player_Weapon_Jump_Table   
        dc.w    Ultimate_Weapon-Player_Weapon_Jump_Table        

********************************************* NORMAL WEAPON HANDLERS

Ultimate_Weapon:
        move.w  #$600,d5   
        subq.w  #4,d6   
        subq.w  #3,d7   
        lea     Bullet_Ultimate2(pc),a1 
        bsr     Fire_Bullet     

        addq.w  #4,d7   
        lea     Bullet_Ultimate3(pc),a1 
        bsr     Fire_Bullet     

        subq.w  #8,d7   
        lea     Bullet_Ultimate1(pc),a1 
        bsr     Fire_Bullet     

        add.w   #12,d7  
        lea     Bullet_Ultimate4(pc),a1 
        bra     Fire_Bullet     

Dual_Plasma_Cannon:
        moveq   #0,d4   
        subq.w  #4,d6   
        subq.w  #6,d7   
        bsr.s   place_plasma_bullet     
        addq.w  #8,d7   
place_plasma_bullet:
        lea     Bullet_Plasma(pc),a1
        move.b  d4,(a1)    
        bra     Fire_Bullet     

Triple_Plasma_Cannon:
        subq.w  #2,d7   
        subq.w  #4,d6   
        moveq   #0,d4 
        bsr.s   place_plasma_bullet     
        subq.w  #4,d7   
        moveq   #-1,d4   
        bsr.s   place_plasma_bullet     
        addq.w  #8,d7   
        moveq   #1,d4 
        bra.s   place_plasma_bullet     

Golden_Arches:
        addq.w  #3,d7   
        addq.w  #4,d6   
        lea     Bullet_Arch_Right(pc),a1         
        bsr     Fire_Bullet     
        sub.w   #9,d7   
        lea     Bullet_Arch_Left(pc),a1 
        bra     Fire_Bullet     

Quadruple_Shoot:
        moveq   #0,d5
        subq.w  #7,d7   
        bsr     QS_TwoShots     
        add.w   #12,d7  
QS_TwoShots:
        lea     Bullet_Quad_Left(pc),a1 
        bsr     Fire_Bullet     
        lea     Bullet_Quad_Right(pc),a1        
        bra     Fire_Bullet     

Triple_Shoot:
        subq.w  #1,d7   
        subq.w  #5,d6   
        lea     Bullet_Triple_Left(pc),a1       
        bsr     Fire_Bullet     
        lea     Bullet_Triple_Middle(pc),a1     
        bsr     Fire_Bullet     
        lea     Bullet_Triple_Right(pc),a1      
        bra     Fire_Bullet     

Double_Shoot:
        subq.w  #6,d6   
        subq.w  #6,d7   
        bsr.s   place_standard_bullet   
        add.w   #10,d7  
        bra.s   place_standard_bullet   

normal_weapon:
        subq.w  #1,d7   
        subq.w  #5,d6   
place_standard_bullet:
        lea     Bullet_Standard(pc),a1  

********************************************* FIRE A BULLET
*
* Insert bullet described at (A1) at coordinates (D7, D6) with data = D5
* Modifies D0, A0, A1, D5
*
********

Fire_Bullet:
        lea     bullets_data(a5),a0     
        move.w  num_b(a5),d0    
loop_find_bullet:
        tst.w   (a0)    
        beq.s   found_bullet    
        lea     b_size(a0),a0   
        dbra    d0,loop_find_bullet     
rts420: rts     

found_bullet:
        move.w  (a1)+,(a0)+             ; Bullet type
        bsr.s   extend_copy             ; damage
        move.w  d7,(a0)+                ; X-Coordinate
        bsr.s   extend_copy             ; Width
        move.w  d6,(a0)+                ; Y-Coordinate
        bsr.s   extend_copy             ; Height
        move.b  (a1)+,d5
        move.w  (a1)+,(a0)+             ; Image
        move.w  d5,(a0)+                ; Misc. data
        rts

extend_copy:
        move.b  (a1)+,d1
        ext.w   d1
        move.w  d1,(a0)+
        rts

********************************************* BULLET DESCRIPTIONS
*
* X-Velocity, Y-Velocity * 2, damage, width, height, type (bytes)
* Then image (word) 
*
********

Bullet_Standard:
        dc.b    0,-8,2,3,10,0
        dc.w    in_Disruptor_Blast
Bullet_Triple_Middle:
        dc.b    0,-10,2,4,4,0
        dc.w    in_Triple_Shot  
Bullet_Triple_Left:
        dc.b    -3,-8,2,4,4,0
        dc.w    in_Triple_Shot  
Bullet_Triple_Right:
        dc.b    3,-8,2,4,4,0
        dc.w    in_Triple_Shot      
Bullet_Quad_Left:
        dc.b    -4,-12,2,5,7,1
        dc.w    in_Quad_Blast       
Bullet_Quad_Right:
        dc.b    4,-12,2,5,7,1
        dc.w    in_Quad_Blast      
Bullet_Plasma:
        dc.b    0,-12,8,5,11,0
        dc.w    in_Plasma_Blast  
Bullet_Arch_Left:
        dc.b    -1,5,16,4,16,2
        dc.w    in_Blob_Blast       
Bullet_Arch_Right:
        dc.b    1,5,16,4,16,2
        dc.w    in_Blob_Blast      
Bullet_Ultimate1:
        dc.b    -4,-18,20,5,10,1
        dc.w    in_Ultimate_Bullet        
Bullet_Ultimate2:
        dc.b    -1,-18,20,5,10,1
        dc.w    in_Ultimate_Bullet        
Bullet_Ultimate3:
        dc.b    1,-18,20,5,10,1
        dc.w    in_Ultimate_Bullet        
Bullet_Ultimate4:
        dc.b    4,-18,20,5,10,1
        dc.w    in_Ultimate_Bullet        
Bullet_Bomb:
        dc.w    $1868
        dc.b    24,7,7,3
        dc.w    in_Ball  

********************************************* HANDLE SPECIAL WEAPONS

Special_Weapon_Shoot:
        IFND    ti89    
        move.w  #$ffef,$18(a6)  
        ENDIF   
        IFD     ti89    
        move.w  #$fffe,$18(a6)  
        ENDIF   
        cmp.w   #2,player_ship(a5)      
        beq.s   Special_Weapon_2        
        cmp.w   #1,player_ship(a5)      
        beq.s   Special_Weapon_1        
        rts     

********************************************* SPECIAL WEAPON FOR SHIP II

Special_Weapon_1:
        tst.w   special_countdown(a5)   
        bne.s   counting_down   
        move.w  special_weapon_delay(a5),d0     
        beq.s   swr1    
        subq.w  #1,special_weapon_delay(a5)     
        rts     

counting_down:
        subq.w  #1,special_countdown(a5)        
        beq.s   Launch_Special_1        
        rts     

swr1:   btst    #6*IS89,$1b(a6) 
        bne.s   swq     

        move.w  #96,special_weapon_delay(a5)    
        move.w  #6,special_countdown(a5)        

Launch_Special_1:
        lea     enemies_data(a5),a3     ; A3 -> current enemy
        move.w  #num_en-1,d4    
        moveq   #0,d3                   ; D5 = offset of best so far
        moveq   #0,d6                   ; D6 = dmg of best so far
        moveq   #0,d7                   ; D7 = offset of current enemy
loop_search_toughest:
        tst.w   (a3)    
        ble.s   not_this_enemy  
        cmp.w   e_dmg(a3),d6    
        bge.s   not_this_enemy  
        move.w  e_dmg(a3),d6    
        move.w  d7,d3   
not_this_enemy:
        add.w   #e_size,d7      
        lea     e_size(a3),a3   
        dbra    d4,loop_search_toughest 

        move.w  player_xc(a5),d7        
        addq.w  #3,d7   
        move.w  player_yc(a5),d6        
        subq.w  #3,d7   
        lea     Bullet_Bomb(pc),a1      
        bsr     Fire_Bullet
        move.w  d3,-(a0)
swq:    rts     

********************************************* SPECIAL WEAPON FOR SHIP III

Special_Weapon_2:
        move.w  special_weapon_delay(a5),d0     
        beq.s   swr     
        subq.w  #1,special_weapon_delay(a5)     
        rts     

swr:    btst    #6*IS89,$1b(a6) 
        bne.s   swq     

        move.w  #96,special_weapon_delay(a5)    

        lea     enemy_bullets(a5),a0    
        moveq   #7,d0   
kill_ebullets:
        tst.w   eb_dmg(a0)      
        ble.s   noebd   
        clr.w   (a0)    
noebd:  lea     eb_size*2(a0),a0        
        dbra    d0,kill_ebullets        

        lea     bullets_data(a5),a0     
        move.w  num_b(a5),d0    
        subq.w  #7,d0   
        lsl.w   #4,d0   
        add.w   d0,a0   

        moveq   #7,d0   
        lea     sw3_angles(pc),a1       
        move.w  player_xc(a5),d2        
        subq.w  #6,d2   
        move.w  player_yc(a5),d1        
        subq.w  #5,d1   
sw3_deploy:
        move.w  (a1)+,(a0)+                     ;Velocity  
        move.w  #8,(a0)+                        ;damage
        move.w  d2,(a0)+                        ;X-coordinate
        addq.w  #2,d2   
        move.w  #7,(a0)+                        ;Width
        move.w  d1,(a0)+                        ;Y-coordinate
        move.w  #7,(a0)+                        ;height
        move.w  #in_Ball,(a0)+                  ;image
        clr.w   (a0)+                           ;Type (standard)     
        dbra    d0,sw3_deploy   
        rts     

sw3_angles:
        dc.b    -5,-4,-4,-6,-3,-10,-1,-10 
        dc.b    1,-10,3,-10,4,-6,5,-4     
        rts     
