****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Sprite Routines and Images)
**
**  Copyright 2000 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated July 1, 2000
**
****************************************************************************
****************************************************************************

******************************************** IMAGES
*
* These are the actual sprites images.  The first part of a sprite is a word
* which holds the sprites height, minus one.  There then follow that number
* of longwords of image data.  The image data starts in the 9th bit (from
* the right) and can be up to 17 pixels wide (images wider than that will
* have their left sides disappear in some positions, and images starting left
* of bit 9 will have their right sides disappear in some positions).  Bits
* in unused columns should be all zero.
*
* Sprites are normally referenced by their image handles, which are defined
* by the IMAGE macro at the bottom of this file.  The labels for such
* sprites are intended to be "sName", where "Name" will be used to identify
* its image handle.
*
* IMPORTANT WARNING FOR ANYONE EDITING THESE IMAGES:  Beginning with version
* 6.0 of Phoenix, there are some special rules you must follow if you modify
* any images.  If you don't follow them, Phoenix is likely to crash:
*
* 1) If you do anything that changes the size of any image, you must update
*    the version number in the PHOENIX.ASM file.  This is to identify saved
*    games correctly.  If you don't do this, then someone might restore a
*    game saved from another version in this version, and this will probably
*    lead to crashes or other problems.
*
* 2) There are restrictions on the sizes of certain enemies; in particular,
*    most enemies that have changing images must have all images the same
*    size, and in original order.  For each such set of images, there is a
*    preceding comment explaining the requirement.  If you don't follow
*    them, the images will be corrupted and the calculator might crash.
*
*    Unless otherwise specified, a restriction on height refers to the
*    actual distance between the images, not the given value.  Therefore,
*    you can make some images smaller (and specify a smaller number for
*    height) if you leave the appropriate number of blank lines.
*
********

******************************************** NORMAL IMAGES
*
* These images have no restrictions on size or ordering.
*
********

sPlayer_Ship_Normal:
        dc.w    7       
        dc.l    %00000000110000000001100000000000       
        dc.l    %00000000110000100001100000000000       
        dc.l    %00000000110001110001100000000000       
        dc.l    %00000000110011011001100000000000       
        dc.l    %00000000110110001101100000000000       
        dc.l    %00000000111100000111100000000000       
        dc.l    %00000000111000000011100000000000       
        dc.l    %00000000110000000001100000000000       

sPlayer_Ship_II:
        dc.w    7       
        dc.l    %00000000010000111000010000000000       
        dc.l    %00000000111001111100111000000000       
        dc.l    %00000000111111000111111000000000       
        dc.l    %00000000111110000011111000000000       
        dc.l    %00000000111000000000111000000000       
        dc.l    %00000000111000111000111000000000       
        dc.l    %00000000111111111111111000000000       
        dc.l    %00000000111000111000111000000000       

sPlayer_Ship_III:
        dc.w    6       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000100010100010000000000000       
        dc.l    %00000000100100010010000000000000       
        dc.l    %00000000111100011110000000000000       
        dc.l    %00000000111101011110000000000000       
        dc.l    %00000000100100010010000000000000       
        dc.l    %00000000100111110010000000000000       

sUltimate_Bullet:
        dc.w    11      
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       

sDisruptor_Blast:
        dc.w    8       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       

sQuad_Blast:
        dc.w    6       
        dc.l    %00000000011100000000000000000000       
        dc.l    %00000000101010000000000000000000       
        dc.l    %00000000110110000000000000000000       
        dc.l    %00000000101010000000000000000000       
        dc.l    %00000000110110000000000000000000       
        dc.l    %00000000101010000000000000000000       
        dc.l    %00000000110110000000000000000000       

sPlasma_Blast:
        dc.w    10      
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000011100000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000111110000000000000000000       

sEnemy_1:
        dc.w    6       
        dc.l    %00000000100000010000000000000000       
        dc.l    %00000000100000010000000000000000       
        dc.l    %00000000110000110000000000000000       
        dc.l    %00000000111111110000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000000110000000000000000000       

sMissile:
        dc.w    8       
        dc.l    %00000000101000000000000000000000       
        dc.l    %00000000101000000000000000000000       
        dc.l    %00000000101000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000010000000000000000000000       

sEnemy_2:
        dc.w    7       
        dc.l    %00000000100000000010000000000000       
        dc.l    %00000000110000000110000000000000       
        dc.l    %00000000111011101110000000000000       
        dc.l    %00000000111111111110000000000000       
        dc.l    %00000000111111111110000000000000       
        dc.l    %00000000111011101110000000000000       
        dc.l    %00000000110000000110000000000000       
        dc.l    %00000000100000000010000000000000       

sEnemy_8:
        dc.w    4       
        dc.l    %00000000100001000000000000000000       
        dc.l    %00000000111111000000000000000000       
        dc.l    %00000000100001000000000000000000       
        dc.l    %00000000010010000000000000000000       
        dc.l    %00000000001100000000000000000000       

sTriple_Shot:
        dc.w    3       
        dc.l    %00000000011000000000000000000000       
        dc.l    %00000000111100000000000000000000       
        dc.l    %00000000111100000000000000000000       
        dc.l    %00000000011000000000000000000000       

sBoss_1:
        dc.w    13      
        dc.l    %00000000100000000000000010000000       
        dc.l    %00000000110000000000000110000000       
        dc.l    %00000000111000000000001110000000       
        dc.l    %00000000111111111111111110000000       
        dc.l    %00000000111111111111111110000000       
        dc.l    %00000000110000111110000110000000       
        dc.l    %00000000110000011100000110000000       
        dc.l    %00000000110000001000000110000000       
        dc.l    %00000000110000001000000110000000       
        dc.l    %00000000110000001000000110000000       
        dc.l    %00000000111000001000001110000000       
        dc.l    %00000000011100001000011100000000       
        dc.l    %00000000001111111111111000000000       
        dc.l    %00000000000111111111110000000000       

sMBL:
sMBC:
sMBR:
sBoss_2:
        dc.w    13      
        dc.l    %00000000111100000000011110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111100101010011110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111100101010011110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111100101010011110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111100101010011110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111100101010011110000000       
        dc.l    %00000000111000010100001110000000       
        dc.l    %00000000110000001000000110000000       
        dc.l    %00000000100000000000000010000000       

sEnemy_Bomb:
        dc.w    4       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000010000000000000000000000       

sEnemy_Bullet:
        dc.w    2       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000010000000000000000000000       
sEnemy_6:
        dc.w    6       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000111011100000000000000000       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000001110000000000000000000       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000111011100000000000000000       
        dc.l    %00000000110001100000000000000000       

sE_X:   dc.w    6       
        dc.l    %00000000111000111000000000000000       
        dc.l    %00000000111101111000000000000000       
        dc.l    %00000000011111110000000000000000       
        dc.l    %00000000001111100000000000000000       
        dc.l    %00000000011111110000000000000000       
        dc.l    %00000000111101111000000000000000       
        dc.l    %00000000111000111000000000000000       

sBoss_X:
        dc.w    8       
        dc.l    %00000000110000011100000111000000       
        dc.l    %00000000111000111110001110000000       
        dc.l    %00000000011101110111011100000000       
        dc.l    %00000000001111100011111000000000       
        dc.l    %00000000000111000001110000000000       
        dc.l    %00000000001111100011111000000000       
        dc.l    %00000000011101110111011100000000       
        dc.l    %00000000111000111110001110000000       
        dc.l    %00000000110000011100000111000000       

sEnemy_5:
        dc.w    12      
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000111111100000000000000000       
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000111111100000000000000000       
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000100000100000000000000000       
        dc.l    %00000000111111100000000000000000       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000001110000000000000000000       

sBlob_Blast:
        dc.w    5       
        dc.l    %00000000011000000000000000000000       
        dc.l    %00000000111100000000000000000000       
        dc.l    %00000000111100000000000000000000       
        dc.l    %00000000111100000000000000000000       
        dc.l    %00000000111100000000000000000000       
        dc.l    %00000000011000000000000000000000       


sBubble_Weapon:
        dc.w    4       
        dc.l    %00000000011100000000000000000000       
        dc.l    %00000000100010000000000000000000       
        dc.l    %00000000100010000000000000000000       
        dc.l    %00000000100010000000000000000000       
        dc.l    %00000000011100000000000000000000       

sTriangle:
        dc.w    10      
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000000001010000000000000000       
        dc.l    %00000000000010001000000000000000       
        dc.l    %00000000000010001000000000000000       
        dc.l    %00000000000100000100000000000000       
        dc.l    %00000000001000000010000000000000       
        dc.l    %00000000001000000010000000000000       
        dc.l    %00000000010000000001000000000000       
        dc.l    %00000000100000000000100000000000       
        dc.l    %00000000111111111111100000000000       

sArrow_Bullet:
        dc.w    10      
        dc.l    %00000000100010000000000000000000       
        dc.l    %00000000110110000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000011100000000000000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000111110000000000000000000       
        dc.l    %00000000011100000000000000000000       
        dc.l    %00000000001000000000000000000000       

sCash_10:
        dc.w    6       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000010100000000000000000000       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000000101000000000000000000       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000000100000000000000000000       
sCash_100:
        dc.w    6       
        dc.l    %00000000000100000100000000000000       
        dc.l    %00000000011111011111000000000000       
        dc.l    %00000000010100010100000000000000       
        dc.l    %00000000011111011111000000000000       
        dc.l    %00000000000101000101000000000000       
        dc.l    %00000000011111011111000000000000       
        dc.l    %00000000000100000100000000000000       

sCash_1000:
        dc.w    6       
        dc.l    %00000000000100011110000000000000       
        dc.l    %00000000011111010011000000000000       
        dc.l    %00000000010100010001000000000000       
        dc.l    %00000000011111010001000000000000       
        dc.l    %00000000000101010001000000000000       
        dc.l    %00000000011111010011000000000000       
        dc.l    %00000000000100011110000000000000       

sGuided_Left:
        dc.w    4       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000010010000000000000000000       
        dc.l    %00000000010100000000000000000000       
        dc.l    %00000000011000000000000000000000       
        dc.l    %00000000011110000000000000000000       
sGuided_Right:
        dc.w    4       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000001001000000000000000000       
        dc.l    %00000000000101000000000000000000       
        dc.l    %00000000000011000000000000000000       
        dc.l    %00000000001111000000000000000000       
sGuided_Down:
        dc.w    4       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000010101000000000000000000       
        dc.l    %00000000001110000000000000000000       
        dc.l    %00000000000100000000000000000000       

sSuperBoss_Left:
        dc.w    10      
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000110000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111111111111111100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000111010101010101100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000111010101010101100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000011010101010101100000000       
        dc.l    %00000000001111111111111100000000       
sSuperBoss_Right:
        dc.w    10      
        dc.l    %00000000000000000000000100000000       
        dc.l    %00000000000000000000001100000000       
        dc.l    %00000000000000000000011100000000       
        dc.l    %00000000111111111111111100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011000000000       
        dc.l    %00000000111111111111110000000000       
sSuperBoss_Left_Dmg:
        dc.w    10      
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000110000000000000000000000       
        dc.l    %00000000111000000000000110000000       
        dc.l    %00000000111111111111111101000000       
        dc.l    %00000000111101010101010110100000       
        dc.l    %00000000111010101010101100100000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111010101010111101000000       
        dc.l    %00000000111101010101011101000000       
        dc.l    %00000000011010101010111100000000       
        dc.l    %00000000001111111111111110000000       
sSuperBoss_Right_Dmg:
        dc.w    10      
        dc.l    %00000000000000000000000010000000       
        dc.l    %00000000000000000000000110000000       
        dc.l    %00000000000000000000001110000000       
        dc.l    %00000000011111111111111110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000011010101010101110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000011010101010101110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000001111101010101100000000       
        dc.l    %00000000000111111111111000000000       

sSuperBoss_Left_:
        dc.w    14      
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000110000000000000000000000       
        dc.l    %00000000111000000000000000000000       
        dc.l    %00000000111111111111111100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000111010101010101100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000111010101010101100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000111010101010101100000000       
        dc.l    %00000000111101010101010100000000       
        dc.l    %00000000011010101010101100000000       
        dc.l    %00000000001111111111111100000000       
        dc.l    %00000000000111111111111100000000       
        dc.l    %00000000000011111111111100000000       
sSuperBoss_Right_:
        dc.w    14      
        dc.l    %00000000000000000000000100000000       
        dc.l    %00000000000000000000001100000000       
        dc.l    %00000000000000000000011100000000       
        dc.l    %00000000111111111111111100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011100000000       
        dc.l    %00000000101010101010111100000000       
        dc.l    %00000000110101010101011000000000       
        dc.l    %00000000111111111111110000000000       
        dc.l    %00000000111111111111100000000000       
        dc.l    %00000000111111111111000000000000       
sSuperBoss_Left_Dmg_:
        dc.w    14      
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000110000000000000000000000       
        dc.l    %00000000111000000000000110000000       
        dc.l    %00000000111111111111111101000000       
        dc.l    %00000000111101010101010110100000       
        dc.l    %00000000111010101010101100100000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111010101010111101000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000111010101010111101000000       
        dc.l    %00000000111101010101011101000000       
        dc.l    %00000000011010101010111100000000       
        dc.l    %00000000001111111111111110000000       
        dc.l    %00000000000101110001010110000000       
        dc.l    %00000000000011111101010110000000       
sSuperBoss_Right_Dmg_:
        dc.w    14      
        dc.l    %00000000000000000000000010000000       
        dc.l    %00000000000000000000000110000000       
        dc.l    %00000000000000000000001110000000       
        dc.l    %00000000011111111111111110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000011010101010101110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000011010101010101110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000011010101010101110000000       
        dc.l    %00000000111101010101011110000000       
        dc.l    %00000000001111101010101100000000       
        dc.l    %00000000000111111111111000000000       
        dc.l    %00000000011111111011110000000000       
        dc.l    %00000000011101010101000000000000       

sBall:  dc.w    6       
        dc.l    %00000000001110000000000000000000       
        dc.l    %00000000010101000000000000000000       
        dc.l    %00000000101010100000000000000000       
        dc.l    %00000000110101100000000000000000       
        dc.l    %00000000101010100000000000000000       
        dc.l    %00000000010101000000000000000000       
        dc.l    %00000000001110000000000000000000       

sSwoop1:
        dc.w    9       
        dc.l    %00000000101000000000010100000000       
        dc.l    %00000000111001000010011100000000       
        dc.l    %00000000101001100110010100000000       
        dc.l    %00000000111001011010011100000000       
        dc.l    %00000000101001111110010100000000       
        dc.l    %00000000111111000011111100000000       
        dc.l    %00000000101111000011110100000000       
        dc.l    %00000000111000100110011100000000       
        dc.l    %00000000101000011000010100000000       
        dc.l    %00000000111000000000011100000000       

sSwoop2:
        dc.w    9       
        dc.l    %00000000111000000000011100000000       
        dc.l    %00000000101001000010010100000000       
        dc.l    %00000000111001100110011100000000       
        dc.l    %00000000101001011010010100000000       
        dc.l    %00000000111001111110011100000000       
        dc.l    %00000000101111000011110100000000       
        dc.l    %00000000111111000011111100000000       
        dc.l    %00000000101000100100010100000000       
        dc.l    %00000000111000011000011100000000       
        dc.l    %00000000101000000000010100000000       

sfake:  dc.w    0       
        dc.l    0       

******************************************** "WHEEL" ENEMY
*
* All four images of this enemy must be the same size and in order
*
********

sWheel_1:
        dc.w    14      
        dc.l    %00000000000111111111000000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000011100010001110000000000       
        dc.l    %00000000111000010000111000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000111111111111111000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000111000010000111000000000       
        dc.l    %00000000011100010001110000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000000111111111000000000000       
sWheel_2:
        dc.w    14      
        dc.l    %00000000000111111111000000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000011100000101110000000000       
        dc.l    %00000000111000001000111000000000       
        dc.l    %00000000110000001000011000000000       
        dc.l    %00000000111000001000011000000000       
        dc.l    %00000000110111010000011000000000       
        dc.l    %00000000110000111000011000000000       
        dc.l    %00000000110000010111011000000000       
        dc.l    %00000000110000100000111000000000       
        dc.l    %00000000110000100000011000000000       
        dc.l    %00000000111000100000111000000000       
        dc.l    %00000000011101000001110000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000000111111111000000000000       
sWheel_3:
        dc.w    14      
        dc.l    %00000000000111111111000000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000011100000001110000000000       
        dc.l    %00000000111100000001111000000000       
        dc.l    %00000000110010000010011000000000       
        dc.l    %00000000110001000100011000000000       
        dc.l    %00000000110000101000011000000000       
        dc.l    %00000000110000010000011000000000       
        dc.l    %00000000110000101000011000000000       
        dc.l    %00000000110001000100011000000000       
        dc.l    %00000000110010000010011000000000       
        dc.l    %00000000111100000001111000000000       
        dc.l    %00000000011100000001110000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000000111111111000000000000       
sWheel_4:
        dc.w    14      
        dc.l    %00000000000111111111000000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000011101000001110000000000       
        dc.l    %00000000111000100000111000000000       
        dc.l    %00000000110000100000011000000000       
        dc.l    %00000000110000100000111000000000       
        dc.l    %00000000110000010111011000000000       
        dc.l    %00000000110000111000011000000000       
        dc.l    %00000000110111010000011000000000       
        dc.l    %00000000111000001000011000000000       
        dc.l    %00000000110000001000011000000000       
        dc.l    %00000000111000001000111000000000       
        dc.l    %00000000011100000101110000000000       
        dc.l    %00000000001111111111100000000000       
        dc.l    %00000000000111111111000000000000       

******************************************** OPERATOR ENEMY
*
* Materialization sequence for the operator enemy.  These images must be
* in order (with the full image at the top) and must all be 6 lines tall.
*
********

sEnemy_0:
        dc.w    6       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000111111100000000000000000       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000111111100000000000000000       
        dc.l    %00000000011111000000000000000000       
sEnemy_0_1:
        dc.w    6       
        dc.l    %00000000011111000000000000000000       
        dc.l    %00000000110111100000000000000000       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000010001100000000000000000       
        dc.l    %00000000110000100000000000000000       
        dc.l    %00000000110111100000000000000000       
        dc.l    %00000000011011000000000000000000       
sEnemy_0_2:
        dc.w    6       
        dc.l    %00000000011011000000000000000000       
        dc.l    %00000000010110100000000000000000       
        dc.l    %00000000110001100000000000000000       
        dc.l    %00000000010001000000000000000000       
        dc.l    %00000000110000100000000000000000       
        dc.l    %00000000100101100000000000000000       
        dc.l    %00000000011011000000000000000000       
sEnemy_0_3:
        dc.w    6       
        dc.l    %00000000011011000000000000000000       
        dc.l    %00000000000100100000000000000000       
        dc.l    %00000000110001000000000000000000       
        dc.l    %00000000010001000000000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000100100000000000000000000       
        dc.l    %00000000011010000000000000000000       
sEnemy_0_4:
        dc.w    6       
        dc.l    %00000000010011000000000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000100100000000000000000000       
        dc.l    %00000000000010000000000000000000       
sEnemy_0_5:
        dc.w    6       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000000010000000000000000000       

******************************************** EXPLOSION SEQUENCES
*
* Sequence of images displayed when a ship is destroyed.  Each successive
* image of the sequence is located using the height of the previous one,
* so the specified height must be exactly correct.  You can change the
* length of the sequences by inserting additional images between the start
* and end of the sequence.  It should be obvious that they also must be in
* the order they're to be displayed in, with nothing in between.
*
********
sExplosion1:
        dc.w    8       
        dc.l    %00000000001001100000000000000000       
        dc.l    %00000000010010001000000000000000       
        dc.l    %00000000011010101000000000000000       
        dc.l    %00000000111000110000000000000000       
        dc.l    %00000000001000001100000000000000       
        dc.l    %00000000000110001000000000000000       
        dc.l    %00000000010101010100000000000000       
        dc.l    %00000000001111100000000000000000       
        dc.l    %00000000000010001000000000000000       
sExplosion2:
        dc.w    8       
        dc.l    %00000000001001100000000000000000       
        dc.l    %00000000110010001000000000000000       
        dc.l    %00000000011010101100000000000000       
        dc.l    %00000000011001011100000000000000       
        dc.l    %00000000111011110000000000000000       
        dc.l    %00000000011001011100000000000000       
        dc.l    %00000000011101010100000000000000       
        dc.l    %00000000001111100000000000000000       
        dc.l    %00000000000011001000000000000000       
sExplosion3:
        dc.w    8       
        dc.l    %00000000001001100000000000000000       
        dc.l    %00000000110110001100000000000000       
        dc.l    %00000000010010100100000000000000       
        dc.l    %00000000011000011010000000000000       
        dc.l    %00000000100000101100000000000000       
        dc.l    %00000000011000011010000000000000       
        dc.l    %00000000010101010100000000000000       
        dc.l    %00000000001101110000000000000000       
        dc.l    %00000000000011001000000000000000       
sExplosion4:
        dc.w    8       
        dc.l    %00000000001001100000000000000000       
        dc.l    %00000000100010001000000000000000       
        dc.l    %00000000001010101110000000000000       
        dc.l    %00000000010100001000000000000000       
        dc.l    %00000000100000000100000000000000       
        dc.l    %00000000001000010010000000000000       
        dc.l    %00000000010100001000000000000000       
        dc.l    %00000000010100100100000000000000       
        dc.l    %00000000100011001000000000000000       
sExplosion5:
        dc.w    8       
        dc.l    %00000000001001100000000000000000       
        dc.l    %00000000100000001010000000000000       
        dc.l    %00000000001000100100000000000000       
        dc.l    %00000000010001001000000000000000       
        dc.l    %00000000100000000010000000000000       
        dc.l    %00000000001000010100000000000000       
        dc.l    %00000000010001001000000000000000       
        dc.l    %00000000010000000010000000000000       
        dc.l    %00000000000011001000000000000000       
sExplosion6:
        dc.w    9       
        dc.l    %00000000001000100000000000000000       
        dc.l    %00000000100010000100000000000000       
        dc.l    %00000000000000001000000000000000       
        dc.l    %00000000100000000010000000000000       
        dc.l    %00000000001000010100000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000001000000000000000       
        dc.l    %00000000010000000100000000000000       
        dc.l    %00000000000001001010000000000000       
        dc.l    %00000000000010010000000000000000       
sExplosion7:
        dc.w    9       
        dc.l    %00000000001000100000000000000000       
        dc.l    %00000000100001001000000000000000       
        dc.l    %00000000000000000101000000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000101000000010000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000010000000000000000000000       
        dc.l    %00000000000000001010000000000000       
        dc.l    %00000000000100010000000000000000       
sExplosion8:
        dc.w    9       
        dc.l    %00000000001000100000000000000000       
        dc.l    %00000000100000000010000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000000000000010000000000000       
        dc.l    %00000000010000000100000000000000       
        dc.l    %00000000000001010000000000000000       

sLExplosion1:
        dc.w    10      
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000001100101000000000000000       
        dc.l    %00000000011000100001000000000000       
        dc.l    %00000000001110001000000000000000       
        dc.l    %00000000010111010001000000000000       
        dc.l    %00000000001100100100000000000000       
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000001000000100000000000000       
        dc.l    %00000000000000000001000000000000       
sLExplosion2:
        dc.w    11      
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000010000000000000000       
        dc.l    %00000000001001000000000000000000       
        dc.l    %00000000101100101000000000000000       
        dc.l    %00000000011000100001000000000000       
        dc.l    %00000000000100001000000000000000       
        dc.l    %00000000110110010101000000000000       
        dc.l    %00000000001100100110000000000000       
        dc.l    %00000000000000000001000000000000       
        dc.l    %00000000101010100100000000000000       
        dc.l    %00000000000001000001000000000000       
        dc.l    %00000000000010000000000000000000       
sLExplosion3:
        dc.w    12      
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000010000000000000000       
        dc.l    %00000000001001000000000000000000       
        dc.l    %00000000101100101000000000000000       
        dc.l    %00000000011000100001100000000000       
        dc.l    %00000000110100000101100000000000       
        dc.l    %00000000000100000111000000000000       
        dc.l    %00000000100010100100000000000000       
        dc.l    %00000000000100000001001000000000       
        dc.l    %00000000101010100100010000000000       
        dc.l    %00000000001001001000100000000000       
        dc.l    %00000000000010100000000000000000       
        dc.l    %00000000000000100000000000000000       
sLExplosion4:
        dc.w    12      
        dc.l    %00000000000010000100000000000000       
        dc.l    %00000000000000010000000000000000       
        dc.l    %00000000001001001000100000000000       
        dc.l    %00000000101100101000000000000000       
        dc.l    %00000000011000100001101000000000       
        dc.l    %00000000001001001000100000000000       
        dc.l    %00000000110100000000101000000000       
        dc.l    %00000000000101000100100000000000       
        dc.l    %00000000000100110000010000000000       
        dc.l    %00000000101010100100100000000000       
        dc.l    %00000000001001001001001000000000       
        dc.l    %00000000000010100000000000000000       
        dc.l    %00000000000000100100000000000000       
sLExplosion5:
        dc.w    12      
        dc.l    %00000000000010000100000000000000       
        dc.l    %00000000010000010000000000000000       
        dc.l    %00000000001001001000100000000000       
        dc.l    %00000000101100100000001000000000       
        dc.l    %00000000011000000001101000000000       
        dc.l    %00000000001000001000100100000000       
        dc.l    %00000000110100000000001000000000       
        dc.l    %00000000000000000100100000000000       
        dc.l    %00000000100100000000010000000000       
        dc.l    %00000000101000110100101000000000       
        dc.l    %00000000001000110001010000000000       
        dc.l    %00000000000010100000000000000000       
        dc.l    %00000000000000100111000000000000       
sLExplosion6:
        dc.w    12      
        dc.l    %00000000000010000100000000000000       
        dc.l    %00000000100000010000000000000000       
        dc.l    %00000000000001001000100000000000       
        dc.l    %00000000100100100000001000000000       
        dc.l    %00000000000000000010001000000000       
        dc.l    %00000000110100000000001000000000       
        dc.l    %00000000000000000100100000000000       
        dc.l    %00000000100100000000010000000000       
        dc.l    %00000000000001000100100000000000       
        dc.l    %00000000101000100000001000000000       
        dc.l    %00000000001000010001010000000000       
        dc.l    %00000000000010100100000000000000       
        dc.l    %00000000000000100111000000000000       
sLExplosion7:
        dc.w    13      
        dc.l    %00000000000010000100000000000000       
        dc.l    %00000000100000010000000000000000       
        dc.l    %00000000000001001000100000000000       
        dc.l    %00000000100000000000001000000000       
        dc.l    %00000000000000000010000000000000       
        dc.l    %00000000000100000000001000000000       
        dc.l    %00000000000000000100100000000000       
        dc.l    %00000000100100000000000000000000       
        dc.l    %00000000000000000000010000000000       
        dc.l    %00000000100000000000001000000000       
        dc.l    %00000000001000010001010000000000       
        dc.l    %00000000000000100100000000000000       
        dc.l    %00000000000000100001000000000000       
        dc.l    %00000000000100000000001000000000       
sLExplosion8:
        dc.w    13      
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000100000010000001000000000       
        dc.l    %00000000000000000100000000000000       
        dc.l    %00000000100100000000000000000000       
        dc.l    %00000000000000000000001000000000       
        dc.l    %00000000100000000000000100000000       
        dc.l    %00000000000000010000000010000000       
        dc.l    %00000000000000000000010000000000       
        dc.l    %00000000100000000000000100000000       
        dc.l    %00000000000000000001000000000000       
        dc.l    %00000000000100010000001000000000       
        dc.l    %00000000000000100100000000000000       
        dc.l    %00000000000000000001000000000000       
        dc.l    %00000000000100000000010000000000       
sLExplosion9:
        dc.w    13      
        dc.l    %00000000000000100000000000000000       
        dc.l    %00000000100000000000000100000000       
        dc.l    %00000000000000000001000000000000       
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000100000000       
        dc.l    %00000000001000000000001000000000       
        dc.l    %00000000100000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000001000000000       
        dc.l    %00000000001000000000000000000000       
        dc.l    %00000000000000000001000000000000       
        dc.l    %00000000000100000000010000000000       

******************************************** SMALL SPINNING ENEMIES
*
* Several small spinning enemy sequences.  Each of these sequences must be
* in order, and all images (even in different sequences) must be the same
* size.
*
********

sEnemy4_1:
        dc.w    9       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000011100111100000000000000       
        dc.l    %00000000011000011000000000000000       
        dc.l    %00000000011000011000000000000000       
        dc.l    %00000000111100111000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000000000100000000000000000       
sEnemy4_2:
        dc.w    9       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001111010000000000000000       
        dc.l    %00000000011100111000000000000000       
        dc.l    %00000000111000011000000000000000       
        dc.l    %00000000011000011100000000000000       
        dc.l    %00000000011100111000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000000010000000000000000000       
sEnemy4_3:
        dc.w    9       
        dc.l    %00000000000000010000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000101111110000000000000000       
        dc.l    %00000000011100111000000000000000       
        dc.l    %00000000011000011000000000000000       
        dc.l    %00000000011000011000000000000000       
        dc.l    %00000000011100111000000000000000       
        dc.l    %00000000001111110100000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001000000000000000000000       
sEnemy4_4:
        dc.w    8       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000010111101000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000011100111000000000000000       
        dc.l    %00000000011000011000000000000000       
        dc.l    %00000000011000011000000000000000       
        dc.l    %00000000011100111000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000010111101000000000000000       
        dc.l    %00000000000000000000000000000000       

sEnemy_Small_1:
        dc.w    7       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000110000000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000111111100000000000000000       
        dc.l    %00000000011111110000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000000110000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       

sEnemy_Small_2:
        dc.w    7       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000010110000000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000000110100000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       

sEnemy_Small_3:
        dc.w    7       
        dc.l    %00000000000010000000000000000000       
        dc.l    %00000000000110000000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000000110000000000000000000       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       

sEnemy_Small_4:
        dc.w    7       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000110100000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000011111100000000000000000       
        dc.l    %00000000001111000000000000000000       
        dc.l    %00000000010110000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000000000000000000000000000       

sEnemy7_1:
        dc.w    9       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000011111111100000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000111111111000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000000000100000000000000000       

sEnemy7_2:
        dc.w    9       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000111111111000000000000000       
        dc.l    %00000000011111111100000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000000010000000000000000000       
sEnemy7_3:
        dc.w    9       
        dc.l    %00000000000000010000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000101111110000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000001111110100000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001000000000000000000000       
sEnemy7_4:
        dc.w    8       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000010111101000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000011111111000000000000000       
        dc.l    %00000000001111110000000000000000       
        dc.l    %00000000010111101000000000000000       
        dc.l    %00000000000000000000000000000000       

sEnemy3_1:
        dc.w    9       
        dc.l    %00000000000100000000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001000010000000000000000       
        dc.l    %00000000010000001100000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000110000001000000000000000       
        dc.l    %00000000001000010000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000000000100000000000000000       
sEnemy3_2:
        dc.w    9       
        dc.l    %00000000000001000000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001000010000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000110000001000000000000000       
        dc.l    %00000000010000001100000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000001000010000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000000010000000000000000000       
sEnemy3_3:
        dc.w    9       
        dc.l    %00000000000000010000000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000101000010000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000001000010100000000000000       
        dc.l    %00000000000111100000000000000000       
        dc.l    %00000000001000000000000000000000       
sEnemy3_4:
        dc.w    8       
        dc.l    %00000000000000000000000000000000       
        dc.l    %00000000010111101000000000000000       
        dc.l    %00000000001000010000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000010000001000000000000000       
        dc.l    %00000000001000010000000000000000       
        dc.l    %00000000010111101000000000000000       
        dc.l    %00000000000000000000000000000000       

******************************************** GENERIC SPRITE-PLOTTER
*
* This routine draws a sprite to the screen buffer at (D0, D1).
* For Xor_Sprite_D2, D2 is the sprite handle
* For Xor_Sprite, A0 should point to the sprite
* This routine changes, A0, A1, D0, D1, and D2
*
* Each sprite begins with a word specifying its height, minus one.  It is
* followed by one longword for each line of the image.  The sprite image
* starts at the 8th bit, and can be up to 17 pixels wide.
*
********

Xor_Sprite_D2:
        lea     image_table(pc,d2.w),a0 
Xor_Sprite:
        tst.w   d1      
        blt.s   off_the_screen  
        move.w  d0,d2                   ;D0 = X coordinate
        and.w   #15,d0  
        lsl.w   #5,d1                   ;D1 = Y coordinate
        lea     0(a5,d1.w),a1   
        lsr.w   #4,d2   
        add.w   d2,d2   
        add.w   d2,a1   

        move.w  (a0)+,d2                ;A0 -> Sprite data
        subq.w  #8,d0   
        bgt.s   xs_ShiftRight   
        beq.s   xs_alignedOK    

xs_ShiftLeft:
        neg.w   d0      
xs_ShiftLeft_:
        move.l  (a0)+,d1        
        lsl.l   d0,d1   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,xs_ShiftLeft_        
off_the_screen:
        rts     

xs_alignedOK:
        move.l  (a0)+,d1        
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,xs_alignedOK 
        rts     

xs_ShiftRight:
        move.l  (a0)+,d1        
        lsr.l   d0,d1   
        eor.l   d1,(a1) 
        lea     32(a1),a1       
        dbra    d2,xs_ShiftRight        
        rts     

******************************************** SPRITE IMAGE NUMBER ASSIGNMENTS
*
* The IMAGE macro generates assigns sprite image numbers to sprites, which
* are there offsets from the label "image_table".  These handles, which are
* given to symbols named "in_Name" are normally used to refer to sprites;
* they are stored in the game's object data structures, among other things.
* Throughout most of the game, these image handles are stored instead of the
* real addresses, as they require no relocation and stay the same when the
* game is saved and restored again.
*
* As this table is only used to set symbols to equal the offsets, this table
* takes absolutely no space in the executable code.
*
********

IMAGE   MACRO   
in_\1   equ     s\1-image_table 
        ENDM    

image_table:
        IMAGE   Disruptor_Blast 
        IMAGE   Enemy_1 
        IMAGE   Enemy_Bomb      
        IMAGE   Enemy_2 
        IMAGE   Boss_1  
        IMAGE   Enemy_Bullet    
        IMAGE   Explosion1      
        IMAGE   Explosion2      
        IMAGE   Explosion3      
        IMAGE   Explosion4      
        IMAGE   Explosion5      
        IMAGE   Explosion6      
        IMAGE   Explosion7      
        IMAGE   Explosion8      
        IMAGE   LExplosion1     
        IMAGE   LExplosion2     
        IMAGE   LExplosion3     
        IMAGE   LExplosion4     
        IMAGE   LExplosion5     
        IMAGE   LExplosion6     
        IMAGE   LExplosion7     
        IMAGE   LExplosion8     
        IMAGE   LExplosion9     
        IMAGE   Enemy3_1        
        IMAGE   Enemy3_2        
        IMAGE   Enemy3_3        
        IMAGE   Enemy3_4        
        IMAGE   Enemy4_1        
        IMAGE   Enemy4_2        
        IMAGE   Enemy4_3        
        IMAGE   Enemy4_4        
        IMAGE   Enemy7_1        
        IMAGE   Enemy7_2        
        IMAGE   Enemy7_3        
        IMAGE   Enemy7_4        
        IMAGE   Enemy_Small_1   
        IMAGE   Enemy_Small_2   
        IMAGE   Enemy_Small_3   
        IMAGE   Enemy_Small_4   
        IMAGE   Boss_2  
        IMAGE   Triple_Shot     
        IMAGE   Cash_10 
        IMAGE   Cash_100        
        IMAGE   Cash_1000       
        IMAGE   Enemy_5 
        IMAGE   Enemy_6 
        IMAGE   Boss_X  
        IMAGE   Arrow_Bullet    
        IMAGE   Guided_Left     
        IMAGE   Guided_Right    
        IMAGE   Guided_Down     
        IMAGE   Plasma_Blast    
        IMAGE   Enemy_8 
        IMAGE   Blob_Blast      
        IMAGE   SuperBoss_Left  
        IMAGE   SuperBoss_Right 
        IMAGE   SuperBoss_Left_Dmg      
        IMAGE   SuperBoss_Right_Dmg     
        IMAGE   SuperBoss_Left_ 
        IMAGE   SuperBoss_Right_        
        IMAGE   SuperBoss_Left_Dmg_     
        IMAGE   SuperBoss_Right_Dmg_    
        IMAGE   fake    
        IMAGE   Enemy_0 
        IMAGE   Enemy_0_1       
        IMAGE   Enemy_0_2       
        IMAGE   Enemy_0_3       
        IMAGE   Enemy_0_4       
        IMAGE   Enemy_0_5       
        IMAGE   Quad_Blast      
        IMAGE   Bubble_Weapon   
        IMAGE   Triangle        
        IMAGE   E_X     
        IMAGE   Missile 
        IMAGE   Wheel_1 
        IMAGE   Wheel_2 
        IMAGE   Wheel_3 
        IMAGE   Wheel_4 
        IMAGE   Ultimate_Bullet 
        IMAGE   Ball    
        IMAGE   Player_Ship_Normal      
        IMAGE   Player_Ship_II  
        IMAGE   Player_Ship_III 
        IMAGE   Swoop1  
        IMAGE   Swoop2  
        IMAGE   MBL     
        IMAGE   MBC     
        IMAGE   MBR     
