****************************************************************************
****************************************************************************
**                                                               
**  Phoenix (Title screen routines)
**
**  Copyright 2004 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated September 14, 2004
**
****************************************************************************
****************************************************************************

******************************************** INITIALIZE TITLE SCREEN

Phoenix_Title_Screen:
    IFND ti89d
        bsr     Build_Side_Data         ; Prepare side data
    ENDIF

    IFND ti89d   
        bsr     Status_Prepare  
        moveq   #1,d0                   ; Set font to large
        bsr     Set_Font        
        bsr     Display_Screen  
        lea     Main_Title_Messages(pc),a2      
        moveq   #3,d3   
        moveq   #2,d4   
        moveq   #56,d5  
        bsr     Print_Messages  
        moveq   #4,d3   
        addq.w  #3,d4   
        bsr     Print_Messages  
        moveq   #4,d3   
        addq.w  #3,d4   
        bsr     Print_Messages  
    ENDIF   

    IFD ti89d
        moveq   #8,d6
        moveq   #1,d0                   ; Set font to large
        bsr     Set_Font        
        bsr     Clear_Screen    
        lea     Main_Title_Messages(pc),a2      
        moveq   #10,d3  
        moveq   #2,d4   
        bsr     Print_Messages  
        move.w  #$d1,speed(a5)  
        moveq   #0,d0                   ; Set font to small
        bsr     Set_Font
        moveq   #6,d6
    ENDIF   

******************************************** TITLE SCREEN LOOP

Title_Loop:
        bsr     Test_Key        
        cmp.w   #264,d0 
        beq     Game_Over       
        cmp.w   #268,d0 
        beq.s   Start_Actual_Game       
        cmp.w   #"I",d0 
        bne.s   noinv   
        st      inv(a5)
noinv:
    IFND ti89d   
        cmp.w   #269,d0
        beq.s   Start_Actual_Game       
        cmp.w   #270,d0 
        beq.s   Start_Actual_Game       
        cmp.w   #271,d0 
        beq.s   Start_Actual_Game       
        cmp.w   #272,d0 
        beq.s   Show_Contact
        cmp.w   #273,d0
        beq     Show_Legal
        cmp.w   #274,d0 
        beq.s   Show_Instructions       
        cmp.w   #275,d0 
    ENDIF   
    IFD ti89d
        cmp.w   #269,d0
        beq     Show_Legal
        cmp.w   #270,d0
        beq     Show_Contact    
        cmp.w   #271,d0 
        beq     Show_Instructions       
        cmp.w   #272,d0 
    ENDIF   
        beq     Show_High_Scores        
    IFND ti89d   
        bsr     Scroll_Side             ; Scroll sides of screen
        bsr     Display_Screen_Sides    ; Display sides of screen
    ENDIF   
        bsr     Timer_Delay             ; Wait for next 30th of second
        bra.s   Title_Loop              ; Stay on title if not pressed

Start_Actual_Game:
    IFD ti89d
        moveq   #10,d6
        moveq   #2,d0                   ; Set font to large
        bsr     Set_Font

        bsr     Clear_Screen    
        lea     Select_Diff_Message(pc),a2      
        moveq   #5,d3   
        moveq   #1,d4   
        bsr     Print_Messages  
SDL:    bsr     Get_Key 
        cmp.w   #264,d0 
        beq     Game_Over       
        sub.w   #268,d0 
        move.w  d0,d1   
        and.w   #$FFFC,d1       
        bne.s   SDL     
        addq.w  #1,d0   
        move.w  d0,difficulty(a5)       

        bsr     Clear_Screen    
        lea     Select_Speed_Message(PC),a1     
        moveq   #3,d3   
        moveq   #1,d4   
        bsr     Print_Messages  
SSL:    bsr     Get_Key 
        cmp.w   #264,d0 
        beq     Game_Over       
        cmp.w   #268,d0 
        beq.s   Game_Normal     
        cmp.w   #269,d0 
        beq.s   Game_Fast
        cmp.w   #"^",d0
        beq.s   Game_Cheat
        bra.s   SSL     

Game_Normal:
        bsr     Status_Prepare  
        st      Game_Started(a5)        
        rts     

Game_Cheat:
        st      cheated(a5)
        st      weapons_available(a5)
        move.w  #-3,fire_delay(a5)
        
Game_Fast:
        move.w  #$e1,speed(a5)  
        bra.s   Game_Normal     
    ENDIF   

    IFND ti89d   
        sub.w   #267,d0 
        move.w  d0,difficulty(a5)       
        bsr     Status_Prepare  
        st      Game_Started(a5)        
        rts     
    ENDIF   

Show_Legal:
        lea     Legal_Nonsense(pc),a2 
        bra.s   Display_Page

Show_Contact:
        lea     Contact_Messages(pc),a2 
        bra.s   Display_Page    

Show_Instructions:
        lea     Instruction_Messages(pc),a2     

Display_Page:
    IFND ti89d   
        bsr     Display_Screen  
        moveq   #14,d3  
        moveq   #1,d4   
        moveq   #34,d5  
        bsr.s   Print_Messages  
        bsr     Status_Prepare  
ts_wait_enter:
        bsr     Scroll_Side             ; Scroll sides of screen
        bsr     Display_Screen_Sides    ; Display sides of screen
        bsr     Timer_Delay             ; Wait for next 30th of second
        bsr     Test_Key        
        cmp.w   #264,d0 
        beq     Game_Over       
        cmp.w   #32,d0  
    ENDIF   

    IFD ti89d   
        bsr     Clear_Screen    
        moveq   #14,d3  
        moveq   #1,d4   
        bsr.s   Print_Messages  
        bsr     Status_Prepare  
ts_wait_enter:
        bsr     Timer_Delay             ; Wait for next 30th of second
        bsr     Test_Key        
        cmp.w   #264,d0 
        beq     Game_Over       
        cmp.w   #13,d0  
    ENDIF   

        bne.s   ts_wait_enter   
        bra     Phoenix_Title_Screen    

Show_High_Scores:
        bsr     Display_High_Scores     
        bra     Phoenix_Title_Screen    

******************************************** DISPLAY A SEQUNCE OF MESSAGES

Print_Messages:
    IFND ti89d   
        move.w  d5,d1   
        move.w  d4,d0   
        addq.w  #8,d4   
    ENDIF   
    IFD ti89d   
        moveq   #0,d1   
        move.w  d4,d0   
        add.w   d6,d4   
    ENDIF   
        lea     (a2),a0 
        bsr     Display_String  
loop_end_str:
        tst.b   (a2)+   
        bne.s   loop_end_str    
        dbra    d3,Print_Messages       
        rts     

******************************************** TITLE SCREEN MESSAGES

    IFND ti89d   
Main_Title_Messages:
        dc.b    '    ',PHOENIX,' '
        VERSION_STRING
        dc.b    0
        dc.b    ' Copyright 2004 by',0
        dc.b    'by Patrick Davidson',0
        dc.b    '--- No Warranty ---',0

Starting_Title_Messages:
        dc.b    ' Starting',THE,'Game',0  
        dc.b    'F1',DASH,'Beginner',0       
        dc.b    'F2',DASH,'Intermediate',0   
        dc.b    'F3',DASH,'Advanced',0       
        dc.b    'F4',DASH,'Expert',0 

Info_Title_Messages:
        dc.b    '  Additional',INFO,0   
        dc.b    'F5',DASH,'Contact Addrs.',0
        dc.b    'F6',DASH,'Legal',INFO,0
        dc.b    'F7',DASH,'Instructions',0   
        dc.b    'F8',DASH,'High Scores',0    
    ENDIF   

    IFD ti89d   
Select_Diff_Message:
        dc.b    'Select Difficulty:',0  
        dc.b    0       
        dc.b    'F1',DASH,'Beginner',0       
        dc.b    'F2',DASH,'Intermediate',0   
        dc.b    'F3',DASH,'Difficult',0      
        dc.b    'F4',DASH,'Expert',0 

Select_Speed_Message:
        dc.b    'Select Speed:',0       
        dc.b    0       
        dc.b    'F1',DASH,'Normal',0 
        dc.b    'F2',DASH,'Fast',0   

Main_Title_Messages:
        dc.b    '    ',PHOENIX,' '
        VERSION_STRING
        dc.b    0
        dc.b    ' Copyright 2004 by',0
        dc.b    'by Patrick Davidson',0
        dc.b    '--- No Warranty ---',0
        dc.b    0       
        dc.b    'F1',DASH,'Start New Game',0 
        dc.b    0       
        dc.b    'F2',DASH,'Legal Info',0 
        dc.b    'F3',DASH,'Contact Addrs.',0 
        dc.b    'F4',DASH,'Instructions',0   
        dc.b    'F5',DASH,'High Scores',0    
    ENDIF   

Instruction_Messages:
        dc.b    PHOENIX,' In-Game Controls:',0   
        dc.b    'Cursor pad',DASH,'moves ship',0     
    IFND ti89    
        dc.b    'LOCK',DASH,'fires',WEAPON,0 
        dc.b    'F1 thru F8',DASH,'select',WEAPON,0  
        dc.b    'APPS',DASH,'Save game',_AND,'exit',0   
        dc.b    'MODE + ESC',DASH,'Exit',THE,'game',0  
        dc.b    'SPACE',DASH,'Special',WEAPON,0      
    ENDIF   
    IFD ti89    
        dc.b    '2ND',DASH,'fires',WEAPON,0  
        dc.b    '1 thru 8',DASH,'select',WEAPON,0    
        dc.b    'APPS',DASH,'Turn off calculator',0  
        dc.b    '. (DOT)',DASH,'Exit',THE,'game',0     
        dc.b    'Diamond',DASH,'Special',WEAPON,0    
    ENDIF   
        dc.b    0       
        dc.b    ' The status of',YOU,'r shield',0  
        dc.b    'is indicated by',THE,'bar at',0  
        dc.b    'the bottom of the gameplay',0  
        dc.b    'area.  It gets shorter',0      
        dc.b    'when',YOU,'r ship is damaged.',0  
        dc.b    0
        dc.b    HOWBACK,0

Contact_Messages:
        dc.b    'Web:  http://pad.calc.org/',0  
        dc.b    'E-Mail:       pad@calc.org',0  
        dc.b    0       
        dc.b    '   All users of ',PHOENIX,0     
        dc.b    'should E-Mail me ideas,',0     
        dc.b    'comments, or bug reports',0    
        dc.b    'about',_IT,'  Be sure to tell',0  
        dc.b    'me what version of,',THE,0
    IFND ti89d
        dc.b    'game',_AND,'which calculator',0
    ENDIF
    IFD ti89d
        dc.b    'game and which calculator',0
    ENDIF
        dc.b    'you have.  If',YOU,' report a',0  
        dc.b    'bug, be sure',_TO,'describe',0    
        dc.b    'in detail what',YOU,' did',0      
        dc.b    'before',THE,'error occured.',0
        dc.b    0
        dc.b    HOWBACK,0

Legal_Nonsense:
        dc.b    'This program may be used,',0
        dc.b    'modified, and/or copied',0
        dc.b    'with no restrictions.',0
        dc.b    0       
        dc.b    'Since I receive no',0  
        dc.b    'payment for',THIS,0  
        dc.b    'program, it has no',0       
        dc.b    'warranty of any kind.',0  
        dc.b    0  
        dc.b    'The source code to',THIS,0  
        dc.b    'program is on its web',0
        dc.b    'page (see contact info).',0,0,0
        dc.b    HOWBACK,0  

******************************************** PROGRAM TITLE

_comment:
        dc.b    'Phoenix by Patrick Davidson',0 

    IFND ti89d   
_full_title:
        dc.b    'Phoenix '
        VERSION_STRING
        dc.b    ' by Patrick Davidson Released '
        DATE_STRING
        dc.b    0
    ENDIF   

        CNOP    0,2     
