;##################################################################
;
;   Phoenix III - Player bullet code
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated August 5, 2001.
;
;##################################################################     

;############## Player bullet routine
;
; Calls the code specified by the bullet 'type'.  The 'type', which must
; be a multiple of 3, is an index into the table of jumps for bullet code.
; Bullet routines should move the bullet and draw its image.  They are
; called with HL pointing to the bullet entry, and can change all registers.

process_bullets:
        ld      hl,bullets
        ld      b,b_count
loop_player_bullets:
        ld      a,(hl)
        ld      (do_player_bullet+1),a
        push    hl
        push    bc
        call    do_player_bullet
        pop     bc
        pop     hl
        ld      de,b_size
        add     hl,de
        djnz    loop_player_bullets
        ret

do_player_bullet:
        jr      point_to_pbullet_code
point_to_pbullet_code:

;############## Bullet routine table starts here

no_pbullet:
        ld      (hl),0
        ret
        jp      standard_bullet                 ;3
        jp      enhanced_bullet                 ;6
        jp      left_bullet                     ;9
                                                ;12

;############## Right moving bullet

right_bullet:
        inc     hl
        inc     (hl)
        bit     7,(hl)
        jr      z,enhanced
_kill_bullet:
        dec     hl
        ld      (hl),0
        ret

;############## Left moving bullet

left_bullet:
        inc     hl
        dec     (hl)
        jr      nz,enhanced
        jr      _kill_bullet

;############## Enhanced bullet handling

enhanced_bullet:
        inc     hl
enhanced:
        ld      d,(hl)
        inc     hl
        inc     hl
        dec     (hl)
        dec     (hl)
        ld      a,(hl)
        cp      19
        jr      c,destroy_it
        ld      e,a
        ld      hl,bullet2_image
        jp      drw_spr

;############## Standard bullet handling

standard_bullet:
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        dec     (hl)
        ld      a,(game_timer)
        rra
        jr      c,notagain
        dec     (hl)
notagain:
        ld      a,(hl)
        cp      20
        jr      c,destroy_it
        ld      e,a
        ld      hl,bullet_image
        jp      drw_spr
destroy_it:
        dec     hl
        dec     hl
        dec     hl
        ld      (hl),0
        ret

;############## Player bullet image

bullet_image:
        .db     4
        .db     %01100000
        .db     %11110000
        .db     %11110000
        .db     %01100000

        .db     %00000000
        .db     %01100000
        .db     %01100000
        .db     %00000000


bullet2_image:
        .db     6
        .db     %01000000
        .db     %10100000
        .db     %10100000
        .db     %10100000
        .db     %11100000
        .db     %10100000
        .db     %01000000
        .db     %11100000
        .db     %11100000
        .db     %11100000
        .db     %11100000
        .db     %10100000
