;##################################################################
;
;   Phoenix III - Sprite drawing routine
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated July 18, 2001.
;
;##################################################################     

double_sprite:
        inc     hl
        push    hl
        push    de
        call    _ldHLind
        call    drw_spr
        pop     de
        ld      a,8
        add     a,d
        ld      d,a
        pop     hl
        inc     hl
        inc     hl
        call    _ldHLind
        jr      drw_spr

MIN_Y   =32
MAX_Y   =96
                
clip_top:
        pop     hl              ; HL -> image data
        add     a,(hl)          ; A = bottom Y coordinate + 1
        sub     MIN_Y+1         ; A = # of lines past 32 
        ret     c
        inc     a               ; A = number of lines on screen
        ld      b,a             ; B = number of lines to draw

        ld      a,(hl)          ; A = number of lines in image
        ld      (smc_distance+1),a
        sub     b               ; A = number of lines skipped
        inc     a               ; A = number of bytes to skip
        
        add     a,l
        jr      nc,ctad
        inc     h
ctad:   ld      l,a             ; HL -> start of image data to use

        ld      a,d             ; A = X coordinate
        
        ex      de,hl           ; DE -> start of image data to use

smc_gfxmem_start:
        ld      hl,0            ; modified to 3 bytes before plane start
        rra
        rra
        rra
        and     15
        add     a,l
        ld      l,a             ; HL -> screen address
        jr      nc,drw_spr_main
        inc     h
        jr      drw_spr_main
        
drw_spr:
        bit     7,(hl)
        jr      nz,double_sprite
        ld      c,0
        ld      a,d                     ; A = X coordinate
        bit     7,a                     ; X >= 128 -> completely offscreen
        ret     nz
        cp      17                      ; Z <= 17 -> completely offscreen
        ret     c
        cp      24
        jr      nc,no_left_clip
        ld      c,24
        jr      clip_done
no_left_clip:
        cp      121
        jr      c,clip_done
        ld      c,48
clip_done:

        and     7
        ld      b,a
        add     a,a
        add     a,b
        add     a,c
        ld      (jumpintable+1),a       ; Save selected shift amount 
        
        push    hl                      ; Save sprite image pointer

        ld      b,0
smc_gfxmem_minus512:
        ld      hl,0            ; Modified to 515 bytes before start
        ld      a,e

        cp      MIN_Y
        jr      c,clip_top

        ld      (smc_start_y_coord+1),a
        
        add     a,a                     ; A = Y * 2
        add     a,a
        rl      b                       ; BA = Y * 4
        add     a,a                    
        rl      b                       ; BA = Y * 8
        add     a,a
        rl      b                       ; BA = Y * 16
        ld      c,d             
        srl     c
        srl     c
        srl     c                       ; C = X / 8
        or      c
        ld      c,a
        add     hl,bc                   ; HL = Screen address

        ex      de,hl                   ; DE = Screen address

        pop     hl
        ld      a,(hl)                  ; B = height
        ld      b,a
        ld      (smc_distance+1),a
        inc     hl                      ; HL -> image

        ex      de,hl                   ; HL -> screen, DE -> image

smc_start_y_coord:
        ld      a,0                     ; Self-modification stores Y here
        cp      MAX_Y
        ret     nc
        add     a,b                     ; A = maximum Y coordinate
        cp      MAX_Y
        jr      c,drw_spr_main
        sub     b
        sub     MAX_Y
        neg

        ld      b,a
                
drw_spr_main:
        ld      c,0
        scf
        ccf

        push    hl
        push    bc
        push    de
        call    jumpintable
        pop     de
smc_distance:
        ld      hl,0
        add     hl,de
        ex      de,hl
        pop     bc
        pop     hl
#ifdef __TI86__
        set     2,h
#else
        inc     h
        inc     h
        inc     h
        inc     h
#endif
        
jumpintable:
        jr      table

table:
        jp      routine0
        jp      routine1
        jp      routine2
        jp      routine3
        jp      routine4
        jp      routine5
        jp      routine6
        jp      routine7
        jp      routine0
        jp      lroutine1
        jp      lroutine2
        jp      lroutine3
        jp      lroutine4
        jp      lroutine5
        jp      lroutine6
        jp      lroutine7
        jp      routine0
        jp      rroutine1
        jp      rroutine2
        jp      rroutine3
        jp      rroutine4
        jp      rroutine5
        jp      rroutine6
        jp      rroutine7

;############## Non-clipped drawing

routine0:
        ld      c,16            ;7
routine0_:
        ld      a,(de)          ;7
        inc     de              ;6

        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,c             ;4
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done0        ;10
        inc     h               ;4
done0:  djnz    routine0_
        ret

routine7:
        inc     hl
routine7_:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a             ;4
        rl      c               ;8
        or      (hl)            ;7
        ld      (hl),a          ;7
        dec     hl              ;6
        ld      a,(hl)          ;7
        or      c               ;4
        ld      (hl),a          ;7

        ld      a,b             ;4
        ld      bc,17           ;10
        add     hl,bc           ;11
        ld      c,b             ;4
        ld      b,a             ;4
        djnz    routine7_
        ret

routine1:
        ld      a,(de)          ;7
        inc     de              ;6

        rra                     ;4
        rr      c               ;8
        or      (hl)            ;7
        ld      (hl),a          ;7
        inc     hl              ;6
        ld      a,(hl)          ;7
        or      c               ;4
        ld      (hl),a          ;7

        ld      a,b             ;4
        ld      bc,15           ;10
        add     hl,bc           ;11
        ld      c,b             ;4
        ld      b,a             ;4
        djnz    routine1
        ret

routine2:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $3F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $C0             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,15            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done2        ;10
        inc     h               ;4
done2:  djnz    routine2
        ret

routine3:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $1F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $E0             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,15            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done3        ;10
        inc     h               ;4
done3:  djnz    routine3
        ret

routine4:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        ld      c,a             ;4
        and     $0F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $F0             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,15            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done4        ;10
        inc     h               ;4
done4:  djnz    routine4        ;13
        ret

routine6:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        ld      c,a             ;4
        and     $03             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $FC             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,15            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done6        ;10
        inc     h               ;4
done6:  djnz    routine6        ;13
        ret
                               
routine5:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        rlca                    ;4
        ld      c,a             ;4
        and     $07             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7
        ld      a,c             ;4
        and     $F8             ;7
        inc     hl              ;6
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,15            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,done5        ;10
        inc     h               ;4
done5:  djnz    routine5        ;13
        ret

;############## Right-clipped drawing

rroutine7:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca
        and     1
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone7       ;10
        inc     h               ;4
rdone7: djnz    rroutine7
        ret

rroutine1:
        ld      a,(de)          ;7
        inc     de              ;6

        rra                     ;4
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone1       ;10
        inc     h               ;4
rdone1: djnz    rroutine1
        ret

rroutine2:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        and     $3F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone2        ;10
        inc     h               ;4
rdone2: djnz    rroutine2
        ret

rroutine3:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        and     $1F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone3       ;10
        inc     h               ;4
rdone3: djnz    rroutine3
        ret

rroutine4:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        and     $0F             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone4       ;10
        inc     h               ;4
rdone4: djnz    rroutine4       ;13
        ret

rroutine6:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        and     $03             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone6       ;10
        inc     h               ;4
rdone6: djnz    rroutine6       ;13
        ret
                               
rroutine5:
        ld      a,(de)          ;7
        inc     de              ;6

        rlca                    ;4
        rlca                    ;4
        rlca                    ;4
        and     $07             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,rdone5       ;10
        inc     h               ;4
rdone5: djnz    rroutine5       ;13
        ret

;############## Left-clipped drawing

lroutine7:
        inc     hl
lroutine7_:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a             ;4
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone7       ;10
        inc     h               ;4
ldone7: djnz    lroutine7_
        ret

lroutine1:
        inc     hl
lroutine1_:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        and     $80
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone1       ;10
        inc     h               ;4
ldone1: djnz    lroutine1_
        ret

lroutine2:
        inc     hl
lroutine2_:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        and     $c0
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone2       ;10
        inc     h               ;4
ldone2: djnz    lroutine2_
        ret

lroutine3:
        inc     hl
lroutine3_:
        ld      a,(de)          ;7
        inc     de              ;6

        rrca                    ;4
        rrca                    ;4
        rrca                    ;4
        and     $e0             ;7
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone3       ;10
        inc     h               ;4
ldone3: djnz    lroutine3_
        ret

lroutine4:
        inc     hl
lroutine4_:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a
        add     a,a
        add     a,a
        add     a,a
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone4       ;10
        inc     h               ;4
ldone4: djnz    lroutine4_      ;13
        ret

lroutine6:
        inc     hl
lroutine6_:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a
        add     a,a
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone6       ;10
        inc     h               ;4
ldone6: djnz    lroutine6_      ;13
        ret
                               
lroutine5:
        inc     hl
lroutine5_:
        ld      a,(de)          ;7
        inc     de              ;6

        add     a,a
        add     a,a
        add     a,a
        or      (hl)            ;7
        ld      (hl),a          ;7

        ld      a,16            ;7
        add     a,l             ;4
        ld      l,a             ;4
        jp      nc,ldone5       ;10
        inc     h               ;4
ldone5: djnz    lroutine5_      ;13
        ret
