;##################################################################
;
;   Phoenix III for the TI-86 - Main enemy handling
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated July 29, 2001.
;
;##################################################################

;############## Enemy bullet routine
;
; Calls the code specified by the bullet 'type'.  The 'type', which must
; be 1 + multiple of 3, is an index into the table of jumps for bullet code.
; Bullet routines should move the bullet and draw its image.  They are
; called with HL pointing to the bullet entry, and can change all registers.

enemy_bullets:
        ld      hl,flak
        ld      b,f_count
loop_ebullets:
        ld      a,(hl)
        ld      (do_enemy_bullet+1),a
        push    bc
        push    hl
        call    do_enemy_bullet
        pop     hl
bullet_killed:
        pop     bc
        ld      de,f_size
        add     hl,de
        djnz    loop_ebullets
        ret

do_enemy_bullet:
        jr      no_ebullet
no_ebullet:
        ret
        jp      diag_ebullet
        jp      slow_down_ebullet
        jp      down_ebullet

;############## Fully aimed bullet

aimed_bullet:
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      e,(hl)
        inc     hl
        inc     hl
        inc     hl
        ld      b,(hl)
        call    div4
        ld      a,b
        add     a,d
        cp      20
        jr      c,kill_bullet_2
        cp      129
        jr      nc,kill_bullet_2
        ld      d,a
        inc     hl
        ld      b,(hl)
        call    div4
        ld      a,b
        add     a,e
        cp      25
        jr      c,kill_bullet_2
        cp      100
        jr      nc,kill_bullet_2
        ld      e,a
        dec     hl
        dec     hl
        dec     hl
        dec     hl
        ld      (hl),e
        dec     hl
        dec     hl
        ld      (hl),d
        ld      hl,bullet_image
        jp      drw_spr

kill_bullet_2:
        pop     hl
        pop     hl
        ld      (hl),0
        jr      bullet_killed

;############## Small bullet moving down quickly

down_ebullet:
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        inc     (hl)
        inc     (hl)
        ld      e,(hl)
        ld      a,96
        cp      e
        jr      c,kill_bullet
        ld      hl,simple_bullet
        jp      drw_spr

;############## Bullet moving straight down slowly with any image

slow_down_ebullet:
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      a,(game_timer)
        rra
        jr      c,nodescend
        inc     (hl)
nodescend:
        ld      e,(hl)
        ld      a,96
        cp      e
        jr      c,kill_bullet
        inc     hl
        inc     hl
        inc     hl
        call    _ldHLind
        jp      drw_spr

;############## Diagonal enemy bullet

diag_ebullet:
        inc     hl
        ld      d,(hl)
        inc     hl
        inc     hl
        ld      e,(hl)
        push    de
        push    hl
        ld      hl,bullet_image
        call    drw_spr
        pop     hl
        pop     de

        inc     hl
        inc     hl
        inc     hl
        ld      a,(hl)
        add     a,d
        jr      z,kill_bullet
        cp      128
        jr      z,kill_bullet
        ld      d,a

        inc     hl
        ld      a,(hl)
        add     a,e
        jr      z,kill_bullet
        cp      104
        jr      z,kill_bullet

        dec     hl
        dec     hl
        dec     hl
        dec     hl
        ld      (hl),a
        dec     hl
        dec     hl
        ld      (hl),d
        ret

kill_bullet:
        pop     hl
        pop     hl
        ld      (hl),0
        jp      bullet_killed
