;##################################################################
;
;   Phoenix III for the TI-86 - enemy entry routines
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated July 18, 2001.
;
;##################################################################

fivehundred:
        .db     $00,$05,$00

restart_game:
        ld      hl,score+2
        ld      de,fivehundred+2
        call    ADD_BCD
        ld      hl,extra_power
        ld      a,(hl)
        add     a,4
        ld      (hl),a
        cp      240
        jr      nz,restart_level
        ld      (hl),236
        jr      restart_level

initialize_enemies:
        ld      hl,enemies
        ld      de,enemies+1
        ld      (hl),0
        ld      bc,$17f
        ldir
                        
restart_level:
        ld      a,1
        ld      de,number+2
        ld      (de),a
        ld      hl,level+2
        call    ADD_BCD
        ld      hl,level_data+2
        ld      (level_pointer),hl
        ld      hl,(level_data)
        ld      (level_delay),hl
        ret

enemies_left:
        nop
        inc     hl
        jr      new_delay

add_next_enemy:
        ld      hl,(level_delay)
        bit     7,h
        jr      nz,enemies_left
        dec     hl
new_delay:
        ld      (level_delay),hl
        ld      a,h
        or      l
        ret     nz

        ld      hl,(level_pointer)
        call    _ldHLind
        call    install_enemy
        ld      hl,(level_pointer)
        inc     hl
        inc     hl
        push    hl
        call    _ldHLind
        ld      (level_delay),hl
        ld      a,h
        or      l
        pop     hl
        jr      z,restart_game
        inc     hl
        inc     hl
        ld      (level_pointer),hl
        ret

install_enemy:
        push    hl
        ld      hl,enemies
        ld      de,e_size
        ld      b,16
loop_find_unused_enemy:
        ld      a,(hl)
        or      a
        jr      z,put_enemy
        add     hl,de
        djnz    loop_find_unused_enemy

        pop     hl
        ret

put_enemy:
        pop     de
        ld      (hl),1          ; normal active enemy
        inc     hl

        ex      de,hl           ; copy coords and damage
        ld      bc,4
        ldir
        ld      a,(extra_power)
        add     a,(hl)
        ld      (de),a
        inc     hl
        inc     de

        call    start_list

        call    start_list

        ld      bc,12
        ldir
        ret

start_list:
        ld      c,(hl)
        inc     hl
        ld      b,(hl)          ; BC = start of list
        inc     hl
        ld      a,(bc)          ; A = countdown
        inc     bc              ; BC = start of list data

        ex      de,hl           ; store these variables
        ld      (hl),c
        inc     hl
        ld      (hl),b
        inc     hl
        ld      (hl),a
        inc     hl
        ex      de,hl

        ret
