;##################################################################
;
;   Phoenix III for the TI-86 - Main enemy handling
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated July 29, 2001
;
;##################################################################

;############## Fire enemy bullets
;
; A = firing type, D = X coordinate, E = Y coordinate
; Changes all registers

enemy_shoot:
        ld      (shoot_select+1),a
shoot_select:
        jr      shoot_none
shoot_none:
        ret
        jp      shoot_1
        jp      shoot_2

shoot_3:
        ld      a,5
        add     a,e
        ld      e,a
        dec     d
        dec     d

        push    de
        call    find_enemy_bullet
        pop     de
        ret     nz
        push    de

        call    shoot_big_inner

        call    find_enemy_bullet
        pop     de
        ret     nz

        ld      a,12
        add     a,d

        ld      d,a

        jp      shoot_big_inner

shoot_2:
        push    de
        call    find_enemy_bullet
        pop     de
        ret     nz

        ld      (hl),7
        inc     hl
        inc     d
        inc     d
        ld      (hl),d
        inc     hl
        ld      (hl),2
        inc     hl
        inc     e
        inc     e
        inc     e
        ld      (hl),e
        inc     hl
        ld      (hl),5
        inc     hl
        ld      (hl),$97
        ret

shoot_1:
        push    de
        call    find_enemy_bullet
        pop     de
        ret     nz

shoot_1_inner:
        ld      (hl),1
        inc     hl
        inc     d
        inc     d
        ld      (hl),d
        inc     hl
        ld      (hl),4
        inc     hl
        inc     e
        inc     e
        ld      (hl),e
        inc     hl
        ld      (hl),4
        inc     hl
        ld      (hl),$98

        inc     hl
        ld      (hl),1
        ld      a,(player_x)
        sub     d
        jr      nc,player_not_right
        ld      (hl),-1
player_not_right:

        inc     hl
        ld      (hl),1
        ld      a,(player_y)
        sub     e
        ret     nc
        ld      (hl),-1
        ret

;############## Fire a large, fully-aimed bullet (HL -> bullet, DE = coords)

shoot_big_inner:
        push    de
        ld      a,(player_y)
        sub     e
        sra     a
        sra     a
        ld      b,a                     ; B = (PY - EY) * (1/4)
        sra     a
        add     a,b
        ld      e,a                     ; E = (3/8) * (PY - EY)
        jp      p,positive
        neg
positive:
        ld      b,a                     ; B = | (3/8) * (PY - EY) |

        ld      a,(player_x)
        sub     d                       ; A = PX - EX
        jr      c,fire_big_left
        call    get_angle               ; classify angle
        
deploy_big:                             ; D: -3 is most left, 3 most right
        push    hl
        ld      hl,angles_table
        ld      a,d
        add     a,3
        add     a,a
        ld      c,a
        ld      b,0
        add     hl,bc
        ld      a,(hl)                  ; Y-velocity
        inc     hl
        ld      b,(hl)                  ; X-velocity
        bit     7,e                     ; test whether to go up
        jr      z,no_neg
        neg
no_neg:
        pop     hl

        pop     de

        ld      (hl),10                 ; enemy bullet type
        inc     hl
        ld      (hl),d                  ; X-coordinate
        inc     hl
        ld      (hl),5                  ; width
        inc     hl
        ld      (hl),e                  ; Y-coordinate
        inc     hl
        ld      (hl),5                  ; height
        inc     hl
        ld      (hl),$96
        inc     hl
        ld      (hl),b
        inc     hl
        ld      (hl),a
        ret     

angles_table:
        .db     2,-6
        .db     4,-4
        .db     6,-2
        .db     8,0
        .db     6,2
        .db     4,4
        .db     2,6

fire_big_left:
        neg
        call    get_angle
        ld      a,d
        neg
        ld      d,a
        jr      deploy_big

; Classify DY/DX into one of several categories, returning with D=0 for
; closest to straight down, D=3 for closest to sideways, taking
; A = |DX|, B = |DY| as arguments

get_angle:
        ld      d,0
        sub     b
        ret     c                       ; DX < (3/8) DY -> straight down
        inc     d
        sub     b
        ret     c                       ; DX < (3/4) DY -> slight angle
        inc     d
        sub     b
        ret     c                       ; DX < (3/2) DY -> 45 deg angle
        sub     b
        ret     c
        inc     d                       ; DX > (3/2) DY -> high angle
        ret

;############## Locate an unused enemy bullet
;
; Modifies all registers
; Returns HL pointing to bullet
; Zero flag set = empty bullet found

find_enemy_bullet:
        ld      hl,flak
        ld      de,f_size
        ld      b,f_count
        xor     a
loop_find_enemy_bullet:
        cp      (hl)
        ret     z
        add     hl,de
        djnz    loop_find_enemy_bullet
        ret

;############## Enemy bullet images

simple_bullet:
        .db     4
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
        .db     %11000000
