;##################################################################
;
;   Phoenix III - Collisions involving player
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last modified May 19, 2001.  
;
;##################################################################

hit_player:
        ld      hl,(player_y)
        ld      e,h
        ld      d,8
        ld      (test_coords),de
        ld      h,8
        ld      (test_coords+2),hl

;############## Scan for collisions with enemies

        ld      hl,enemies
        ld      b,e_num
loop_scan_enemies:
        ld      a,(hl)
        add     a,a
        jr      z,no_enemy_hy
        push    hl
        inc     hl
        call    collision_check
        pop     hl
        call    c,player_enemy_collision

no_enemy_hy:
        ld      de,e_size
        add     hl,de

        djnz    loop_scan_enemies

;############## Scan for collisions with enemy bullets

        ld      hl,flak
        ld      b,f_count
loop_scan_flak:
        ld      a,(hl)
        or      a
        jr      z,no_flak_hy
        push    hl
        inc     hl
        call    collision_check
        pop     hl
        call    c,player_ebullet_collision

no_flak_hy:
        ld      de,f_size
        add     hl,de

        djnz    loop_scan_flak

        ret

;############## Collision between player and enemy bullet at (HL)

player_ebullet_collision:
        push    bc
        push    hl
        ld      bc,f_dmg
        add     hl,bc
        ld      a,(hl)
        cp      $f0
        jp      nc,collect_bonus
        ld      hl,shield+2
        ld      de,dmg+2
        ld      (de),a
        call    ADD_BCD
        inc     hl
        bit     7,(hl)
        jp      nz,killed_you
        pop     hl
        pop     bc
        ld      (hl),0
        ret

dmg:    .db     $99,$99,$99

collect_bonus:
        call    receive_bonus
        pop     hl
        pop     bc
        ld      (hl),0
        ret

;############## Collision between player and enemy at (HL)

player_enemy_collision:
        push    bc
        push    hl
        ld      hl,shield+2
        ld      de,minus1+2
        call    ADD_BCD
        inc     hl
        bit     7,(hl)
        jr      nz,killed_you
        ld      c,1
        pop     de
        push    de
        call    damage_enemy
        pop     hl
        pop     bc
        ret

killed_you:
        or      h
        ld      (game_over),a
        jp      exit_program
