;##################################################################
;
;   Phoenix III - information panel display
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated July 29, 2001.
;
;##################################################################

;############## Show information panel

#ifdef __TI83__

show_panel:
        ld      hl,(addr_main_plane0)
        ld      de,(128*7)+10
        add     hl,de
        ex      de,hl
        ld      hl,shield+1
        ld      b,2
        jp      main_bcd_display
#endif

#ifndef __TI83__

show_panel:
        ld      hl,(gfx_buffer)
        ld      de,$8d
        add     hl,de
        ex      de,hl
        ld      hl,shield
        ld      b,3
        call    display_number_bcd

        ld      hl,(gfx_buffer)
        ld      de,$18d
        add     hl,de
        ex      de,hl
        ld      hl,score
        ld      b,3
        call    display_number_bcd

        ld      hl,(gfx_buffer)
        ld      de,$28d
        add     hl,de
        ex      de,hl
        ld      hl,level
        ld      b,3
        call    display_number_bcd

        ld      hl,(gfx_buffer)
        ld      de,$38d
        add     hl,de
        ex      de,hl
        ld      hl,number
        ld      a,(num_cycles)
        ld      (number+2),a
        ld      b,3
        jr      display_number_bcd
#endif

minus1: .db     $99,$99,$99

number: .db     0,0,0

;############## Initialize infomration panel

#ifndef __TI83__

init_panel:
        call    _clrLCD
        ld      hl,$16a
        ld      (_penCol),hl
        ld      hl,shield_msg
        call    _vputs
        ld      hl,$116a
        ld      (_penCol),hl
        ld      hl,score_msg
        call    _vputs
        ld      hl,$216a
        ld      (_penCol),hl
        ld      hl,level_msg
        call    _vputs
        ld      hl,$316a
        ld      (_penCol),hl
        ld      hl,magic_msg
        call    _vputs

        ld      hl,$ffff
        ld      de,$fbff
        ld      bc,$1400
        lddr
        ret

shield_msg:
        .db     "Shield",0
score_msg:
        .db     "Score",0
level_msg:
        .db     "Level",0
magic_msg:
        .db     "Magic",0
#endif

;############## Add two six-digit packed BCD numbers
;
; HL -> destination + 2
; DE -> source + 2
;
; Returns with the C flag 0 if no carry out, 1 if carry out.

ADD_BCD:
        ld      b,3
        and     a
loop_bcd:
        ld      a,(de)
        adc     a,(hl)
        daa
        ld      (hl),a
        dec     hl
        dec     de
        djnz    loop_bcd
        ret

;############## Compares BCD numbers
;
; HL ->number to subtract from other
; DE ->number
;
; Returns with flags indicating comparion results.  Changes A, B, DE, HL.

CP_BCD: ld      b,3
cmpl:   ld      a,(de)
        cp      (hl)
        ret     nz
        inc     de
        inc     hl
        djnz    cmpl
        ret

;############## Display hex/BCD numbers in special text (6 digits)
;
; HL -> location of number in memory
; DE -> graphics buffer address (upper-left corner of number)

display_number_bcd:
        ld      b,3
#ifdef __TI83__
        push    de
        push    hl
        ld      de,(addr_main_plane0)
        ld      hl,13
        add     hl,de
        ex      de,hl
        pop     hl
        call    main_bcd_display

        ld      b,3
loop_copy_to_screen:
        ld      a,b
        add     a,$28
        pop     hl
        push    hl
        push    bc

        call    waste_time
        out     ($10),a

        ld      a,h
        rl      l
        rla
        and     7
        add     a,a
        add     a,a
        add     a,a
        or      $80
        call    waste_time
        out     ($10),a 

        pop     bc
        push    bc
        ld      a,12
        add     a,b
        ld      e,a
        ld      d,0
        ld      hl,(addr_main_plane0)
        add     hl,de
        ld      de,16
        ld      b,8

loop_copy_block:
        push    bc
        call    waste_time
        pop     bc
        ld      a,(hl)
        out     ($11),a
        add     hl,de
        djnz    loop_copy_block

        pop     bc
        djnz    loop_copy_to_screen

        pop     de
        ret
        
waste_time:
        ld      b,10
waste_loop:
        djnz    waste_loop
        ret
#endif

main_bcd_display:
        ld      a,(hl)
        push    de
        push    hl
        push    bc
        call    display_a_bcd
        pop     bc
        pop     hl
        pop     de
        inc     de
        inc     hl
        djnz    main_bcd_display
        ret

display_a_bcd:
        push    af                      ; Save character
        and     15                      ; A = low digit
        add     a,a                                     
        add     a,a
        add     a,a                     ; A = low digit * 8
        ld      c,a
        ld      b,0
        ld      hl,digit_images
        add     hl,bc                   ; HL -> start of image

        ex      de,hl                   ; DE -> char image, HL -> screen
        push    hl                      ; Save screen address
        ld      c,16
        ld      a,8
loop_copy_digit:
        push    af
        ld      a,(de)
        ld      (hl),a
        pop     af
        inc     de
        add     hl,bc
        dec     a
        jr      nz,loop_copy_digit
        pop     de
                                        ; Restore screen address in DE
        pop     af
        rrca
        and     %01111000               ; A = high digit * 8
        ld      c,a
        ld      hl,digit_images
        add     hl,bc                   ; HL -> start of image

        ex      de,hl                   ; DE -> char image, HL -> screen
        ld      c,16
        ld      a,8
loop_or_digit:
        push    af
        ld      a,(de)
        add     a,a
        add     a,a
        add     a,a
        add     a,a
        or      (hl)
        ld      (hl),a
        pop     af
        inc     de
        add     hl,bc
        dec     a
        jr      nz,loop_or_digit
        ret
        
digit_images:
        .db     %00000010
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000010
        .db     %00000000

        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000000

        .db     %00000010
        .db     %00000101
        .db     %00000001
        .db     %00000001
        .db     %00000010
        .db     %00000100
        .db     %00000111
        .db     %00000000

        .db     %00000110
        .db     %00000001
        .db     %00000001
        .db     %00000110
        .db     %00000001
        .db     %00000001
        .db     %00000110
        .db     %00000000

        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000111
        .db     %00000001
        .db     %00000001
        .db     %00000001
        .db     %00000000

        .db     %00000111
        .db     %00000100
        .db     %00000100
        .db     %00000110
        .db     %00000001
        .db     %00000001
        .db     %00000110
        .db     %00000000

        .db     %00000011
        .db     %00000100
        .db     %00000100
        .db     %00000110
        .db     %00000101
        .db     %00000101
        .db     %00000010
        .db     %00000000

        .db     %00000111
        .db     %00000001
        .db     %00000001
        .db     %00000001
        .db     %00000010
        .db     %00000010
        .db     %00000010
        .db     %00000000

        .db     %00000010
        .db     %00000101
        .db     %00000101
        .db     %00000010
        .db     %00000101
        .db     %00000101
        .db     %00000010
        .db     %00000000

        .db     %00000010
        .db     %00000101
        .db     %00000101
        .db     %00000011
        .db     %00000001
        .db     %00000001
        .db     %00000110
        .db     %00000000

        .db     %00000010
        .db     %00000101
        .db     %00000101
        .db     %00000111
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000000

        .db     %00000110
        .db     %00000101
        .db     %00000101
        .db     %00000110
        .db     %00000101
        .db     %00000101
        .db     %00000110
        .db     %00000000

        .db     %00000010
        .db     %00000101
        .db     %00000100
        .db     %00000100
        .db     %00000100
        .db     %00000101
        .db     %00000010
        .db     %00000000

        .db     %00000110
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000101
        .db     %00000110
        .db     %00000000

        .db     %00000111
        .db     %00000100
        .db     %00000100
        .db     %00000110
        .db     %00000100
        .db     %00000100
        .db     %00000111
        .db     %00000000

        .db     %00000111
        .db     %00000100
        .db     %00000100
        .db     %00000110
        .db     %00000100
        .db     %00000100
        .db     %00000100
        .db     %00000000
