;##################################################################
;
;   Phoenix III for the TI-83+ - low level display/interrupt/background/keys
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated April 30, 2002.
;
;##################################################################

;############## Interrupt routine
;
; Counts cycles for synchronization purposes.

timer_interrupt:
        push    hl
        push    af
        ld      hl,num_cycles
        inc     (hl)
        pop     af
        pop     hl
        JP      $38
timer_interrupt_end:

;############## Initialization

init:   ld      de,(free_memory)
        ld      hl,2048-3
        add     hl,de
        ld      (smc_gfxmem_start+1),hl
        dec     h
        dec     h
        ld      (smc_gfxmem_minus512+1),hl

        ex      de,hl
        inc     h
        inc     h
        inc     h
        inc     h
        ld      (addr_background_plane1),hl
        inc     h
        inc     h
        inc     h
        inc     h
        ld      (addr_main_plane0),hl
        inc     h
        inc     h
        inc     h
        inc     h
        ld      (addr_main_plane1),hl
        inc     h
        inc     h
        inc     h
        inc     h
        ld      (addr_TEMP_AREA),hl

        ld      hl,timer_interrupt
        ld      de,interrupt_entry
        ld      bc,timer_interrupt_end-timer_interrupt
        ldir

        ld      hl,interrupt_table
        ld      (hl),interrupt_byte
        ld      bc,256
        ld      d,h
        ld      e,l
        inc     de
        ldir

        ld      a,interrupt_reg
        ld      i,a

        im      2

        ei

        ld      hl,TEXT_MEM            ; zero variables
        ld      de,TEXT_MEM+1
        xor     a
        ld      (hl),a
        ld      bc,127
        ldir

        ld      (exit_program+1),sp
        call    phoenix3
exit_program:
        ld      sp,0
        ld      a,(game_over)
        or      a
        ret     z
        jp      do_scoring

;############## Show a grayscale frame

twocolor_white:
        call    wait_frame_end
        ld      hl,(addr_main_plane0)
        jr      copy_screen

show_frame:
        ld      hl,num_cycles
        jr      nextline
nextline:
        jr      grayscale
        jr      twocolor_black
        jr      twocolor_white

grayscale:
        call    wait_frame_end
        ld      hl,(addr_main_plane1)
        call    copy_screen
        call    wait_change
        ld      hl,(addr_main_plane0)

;############## Screen buffer copy routine

#define DWAIT in a,($10) \ and %10010000 \ jr nz, $-4

copy_screen:
        ld      a,$80
        out     ($10),a
        ld      c,$20
dispColumn:
        DWAIT
        ld      a,c
        out     ($10),a
        cp      $2c
        ret     z
        ld      b,64
        ld      de,16
dispByte:
        DWAIT
        ld      a,(hl)
        out     ($11),a
        add     hl,de
        djnz    dispByte
        ld      de,-1023
        add     hl,de
        inc     c
        jr      dispColumn

;############## Show frame (black & white, light gray -> black)

twocolor_black:
        call    wait_frame_end

        ld      hl,(addr_main_plane0)
        ld      de,(addr_main_plane1)
        ld      bc,1024
l:      ld      a,(de)
        inc     de
        or      (hl)
        ld      (hl),a
        inc     hl
        dec     bc
        ld      a,b
        or      c
        jr      nz,l

        ld      hl,(addr_main_plane0)
        jr      copy_screen

;############## Wait for next frame, and do page swap

wait_frame_end:
        call    wait_change
        ld      a,(hl)
        cp      5
        jr      c,wait_frame_end
        ld      (hl),0
        ret

wait_change:
        ld      hl,num_cycles
        ld      a,(hl)
loop_wait:
        cp      (hl)
        jr      z,loop_wait
        ret

;############## Display a frame from the scrolled screen

;----E800
;
; size here in noscroll_size (this is *bottom* part of screen)
;
;----scrolling line
;
; size here in scroll_size (this is *top* part of screen)
;
;----EBFF

display_scrolled:
        ld      a,(scroll_line)
        or      a
        jr      z,scroll_offset_0

        add     a,a
        add     a,a
        ld      l,a
        ld      h,0
        add     hl,hl
        add     hl,hl                   ; HL = scroll amount * 16
        ld      (scroll_size),hl

        ex      de,hl
        ld      hl,$403                 ; adjusted +3 for plane offsets
        sbc     hl,de
        ld      (noscroll_size),hl

        ld      de,(addr_background_plane0)  ; copy top of plane 0
        add     hl,de
        ld      de,(addr_main_plane0)
        ld      a,(scroll_line)
        call    copy_a_lines

        ld      bc,-$400                ; copy bottom of plane 0
        add     hl,bc
        ld      a,(scroll_line)
        neg
        and     63
        call    copy_a_lines

        ld      hl,(noscroll_size)      ; copy top of plane 1
        ld      de,(addr_background_plane1)
        add     hl,de
        ld      de,(addr_main_plane1)
        ld      a,(scroll_line)
        call    copy_a_lines

        ld      bc,-$400                ; copy bottom of plane 1
        add     hl,bc
        ld      a,(scroll_line)
        neg
        and     63

copy_a_lines:
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        ldi
        inc     hl
        inc     hl
        inc     hl
        inc     hl
        inc     de
        inc     de
        inc     de
        inc     de
        dec     a
        jr      nz,copy_a_lines
        ret

scroll_offset_0:
        ld      hl,(addr_background_plane0)
        inc     hl
        inc     hl
        inc     hl
        ld      de,(addr_main_plane0)
        ld      a,64
        jr      copy_a_lines

;############## Scroll the screen up one line

scroll_screen:
        ld      a,(game_timer)
        rrca
        ret     nz
do_scroll_screen:
        ld      a,(scroll_line)
        inc     a
        and     63
        ld      (scroll_line),a

        ld      hl,ycoord
        dec     (hl)
        ld      a,(hl)
        cp      -1
        jr      nz,no_reset_map_pos

        ld      hl,map_end
        ld      de,-13
        add     hl,de
        ld      (map_pos),hl

no_reset_map_pos:
        and     7
        ld      c,a
        ld      de,(map_pos)
        ld      a,(scroll_line)
        call    render_background_line

        ld      a,(ycoord)
        and     7
        ret     nz
        ld      hl,(map_pos)
        ld      de,-13
        add     hl,de
        ld      (map_pos),hl
        ret

;############## Render background at (DE) into line A (segment c)

render_background_line:
        dec     a
        cpl
        add     a,a
        add     a,a
        ld      l,a                  
        inc     l                    
        ld      h,0
        add     hl,hl
        add     hl,hl

        push    de
        ld      de,(addr_background_plane0)
        add     hl,de
        pop     de
        dec     hl

        ld      b,12
loop_render_background:
        ld      a,(de)                  ; A = tile #
        inc     de
        add     a,a
        add     a,a
        add     a,a
        add     a,a                     ; A = offset of this tiles
        add     a,c                     ; A = offset of this line in tile

        push    de
        push    hl
        ld      e,a
        ld      d,0
        ld      hl,tiles
        add     hl,de                   ; HL -> tile data
        ld      a,(hl)                  ; A = tile data (plane 0)
        ld      de,8
        add     hl,de
        ld      d,(hl)                  ; H = tile data (plane 1)
        pop     hl
        ld      (hl),a                  ; Write plane 0 data
        inc     h
        inc     h
        inc     h
        inc     h
        ld      (hl),d
        dec     h
        dec     h
        dec     h
        dec     h
        pop     de
        inc     hl
        djnz    loop_render_background
        ret

;############## Scroll in the top of the backgroudn

initialize_background:
        ld      hl,scroll_line
        ld      a,-64
        add     a,(hl)
        ld      (hl),a

        ld      b,64
pscr:   push    bc
        call    do_scroll_screen
        pop     bc
        djnz    pscr
        ret

;############## GET_KEY replacement

SUPER_GET_KEY:
        push    hl
        push    de
        push    bc
        ld      e,0                     ; E = GET_KEY result
        ld      hl,getkeylastdata       ; HL = ptr to last read's table
        ld      a,$fe                   ; A = key port mask
        ld      c,0                     ; C = key number counter

gkol:   out     (1),a                   ; select group of keys to read
        ld      b,8                     ; B = # of keys left in group                      
        push    af                      ; save group mask

        in      a,(1)                   ; A = bit pattern of this key group
        ld      d,(hl)                  ; D = old key mask
        ld      (hl),a                  ; save this mask as old one
        cpl                             ; bit in A now 1 for pressed keys
        and     d                       ; bit in A now 1 for just-pressed

gkl:    inc     c                       ; increment # to key about to test
        rra                             ; Shift key value into carry
        jr      nc,nokey                ; NC = bit 0 = not just-pressed
        ld      e,c                     ; set E to # of key just pressed
nokey:  djnz    gkl

        pop     af                      ; restore group mask
        inc     hl                      ; move up in read table
        rlca                            ; select next mask
        cp      $7F                     ; if $7F, we are done
        jr      nz,gkol
        ld      a,e                     ; move result into A
        pop     bc
        pop     de
        pop     hl
        ret

getkeylastdata:
        .db     $ff,$ff,$ff,$ff,$ff,$ff,$ff

;############## Low-level support routines

ADD_HL_A:
        add     a,l
        ld      l,a
        ret     nc
        inc     h
        ret

_ldHLind:
LD_HL_MHL:
        ld      a,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,a
        ret

CP_HL_DE:
        push    hl
        and     a
        sbc     hl,de
        pop     hl
        ret

