;##################################################################
;
;   Phoenix III - Player handling
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated December 20, 2001.
;
;##################################################################     

;############## Movement, firing and ship display

do_player:
        ld      a,(getkeylastdata)

        ld      hl,player_y

        rra
        ld      c,a
        jr      c,no_down       
        ld      a,(hl)  
        add     a,3     
        cp      89
        jr      nc,no_down       
        ld      (hl),a  
no_down:
        inc     hl      
        rr      c       
        jr      c,no_left       
        ld      a,(hl)  
        add     a,-3
        cp      23
        jr      c,no_left       
        ld      (hl),a  
no_left:
        rr      c       
        jr      c,no_right      
        ld      a,(hl)  
        add     a,3
#ifdef  __TI83__
        cp      114
#else
        cp      121
#endif
        jr      nc,no_right      
        ld      (hl),a  
no_right:
        ld      d,(hl)  
        dec     hl      
        rr      c       
        jr      c,no_up 
        ld      a,(hl)  
        add     a,-3     
        cp      33     
        jr      c,no_up 
        ld      (hl),a  
no_up:  ld      e,(hl)
        ld      hl,player_ship
        jp      drw_spr

player_shoot:
        ld      a,(weapon_power)
        dec     a
        jr      z,enhanced_shoot
        dec     a
        jr      z,triple_shoot

        call    find_empty_bullet
        ret     nz
        ld      (hl),3
        inc     hl
        ld      a,(player_x)
        inc     a
        inc     a
        ld      (hl),a
        inc     hl
        ld      (hl),4
        inc     hl
        ld      a,(player_y)
        dec     a
        ld      (hl),a
        inc     hl
        ld      (hl),4
        inc     hl
        ld      (hl),5
        ret

enhanced_shoot:
        ld      a,(player_x)
        dec     a
        call    put_enhanced_bullet
        ld      a,(player_x)
        add     a,6

put_enhanced_bullet:
        ld      c,a
        call    find_empty_bullet
        ret     nz
        ld      (hl),6
        inc     hl
        ld      (hl),c
        inc     hl
        ld      (hl),3
        inc     hl
        ld      a,(player_y)
        dec     a
        dec     a
        ld      (hl),a
        inc     hl
        ld      (hl),6
        inc     hl
        ld      (hl),10
        ret

triple_shoot:
        ld      a,(player_x)
        add     a,3
        call    put_enhanced_bullet
        call    find_empty_bullet
        ret     nz
        ld      (hl),9
        inc     hl
        ld      a,(player_x)
        ld      (hl),a
        inc     hl
        ld      (hl),3
        inc     hl
        ld      a,(player_y)
        dec     a
        dec     a
        ld      (hl),a
        inc     hl
        ld      (hl),6
        inc     hl
        ld      (hl),10
        call    find_empty_bullet
        ret     nz
        ld      (hl),12
        inc     hl
        ld      a,(player_x)
        add     a,5
        ld      (hl),A
        inc     hl
        ld      (hl),3
        inc     hl
        ld      a,(player_y)
        dec     a
        dec     a
        ld      (hl),a
        inc     hl
        ld      (hl),6
        inc     hl
        ld      (hl),10
        ret

find_empty_bullet:
        ld      hl,bullets
        ld      de,b_size
        ld      b,b_count
loop_find_empty_bullet:
        ld      a,(hl)
        or      a
        ret     z
        add     hl,de
        djnz    loop_find_empty_bullet
        ret

;############## Player ship image

player_ship:
        .db     8

        .db     %10000001
        .db     %10000001
        .db     %10000001
        .db     %10000001
        .db     %10011001
        .db     %10100101
        .db     %11000011
        .db     %10000001

        .db     %11000011
        .db     %11000011
        .db     %11000011
        .db     %11011011
        .db     %11111111
        .db     %11100111
        .db     %11000011
        .db     %10000001

