;##################################################################
;
;   Phoenix III - High score handling
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated January 17, 2002.
;
;##################################################################

do_scoring:
        call    enter_table

        call    show_table

;############## Wait to exit table display

wait_key:
        call    SUPER_GET_KEY
wait_loop:
        call    SUPER_GET_KEY
        cp      K_EXIT
        ret     z
        cp      K_CLEAR
        ret     z
        cp      K_ENTER
        jr      nz,wait_loop
        ret

;############## Display high score table

show_table:
        ROM_CALL(_clrLCD)
        ld      (_curRow),de
        ld      hl,high_msg
        ROM_CALL(_puts)
        ld      hl,scores
        ld      b,7
put_loop:
        push    hl
        ld      a,8
        sub     b
        ld      (_curRow),a
        xor     a
        ld      (_curCol),a
        push    bc
        ROM_CALL(_puts)
        pop     bc
        pop     hl
        ld      de,NAMELEN+1
        add     hl,de
        ld      a,8
        sub     b
        rrca
        ld      e,a
        or      $fc
        ld      d,a
        ld      a,e
        and     $80
        or      $d
        ld      e,a

        push    hl
        push    bc
        call    display_number_bcd
        pop     bc
        pop     hl
        inc     hl
        inc     hl
        inc     hl
        djnz    put_loop
        ret

;############## Show final scoring information

enter_table:
        ld      hl,scores_end-3
        ld      de,score
        call    CP_BCD
        jp      c,no_score

;############## Add player to high scores

        ld      hl,scores_end-4-NAMELEN        ; Put your score in bottom
        ld      b,NAMELEN
loop_space:
        ld      (hl),' '
        inc     hl
        djnz    loop_space
        ld      (hl),0
        inc     hl
        ex      de,hl
        ld      hl,score
        ld      bc,2
        ldir
        
        ld      b,6                             ; Bubble it towards the top
        ld      de,scores_end-3                 ; DE -> entry to move up
loop_bubble:                             
        ld      hl,-(NAMELEN+4)
        add     hl,de                           ; HL -> entry to compare with

        push    bc
        push    de
        call    CP_BCD
        pop     de
        pop     bc

        jr      z,bubble_up
        jr      c,no_bubble_up
bubble_up:

        push    bc
        inc     de
        inc     de                              ; DE -> very end of entry
        ld      hl,-(NAMELEN+4)
        add     hl,de                           ; HL -> previous entry
        ld      b,NAMELEN+4
loop_exchange:
        ld      a,(de)
        ld      c,a
        ld      a,(hl)
        ld      (de),a
        ld      (hl),c
        dec     hl
        dec     de
        djnz    loop_exchange
        pop     bc
        dec     de                              ; DE -> previous entry
        dec     de

        djnz    loop_bubble

no_bubble_up:

        push    bc
        push    de
        call    show_table

        ld      hl,0
        ld      (_curRow),hl
        ld      hl,highscore_prompt
        ROM_CALL(_puts)

        pop     de
        pop     bc
        ld      ix,-(NAMELEN+1)
        add     ix,de
        inc     b
        ld      c,b
        ld      b,0
        ld      (_curRow),bc

;############## Prompt for name entry

input_name:
     ;   ld      b,0
enter_name_loop:
        call    SUPER_GET_KEY
        or      a
        jr      z,enter_name_loop
        cp      K_DEL
        jr      z,backup
        cp      K_ENTER
        ret     z
        ld      c,a
        ld      a,NAMELEN
        cp      b
        jr      z,enter_name_loop
        ld      hl,chartable-10
        ld      e,c
        ld      d,0
        add     hl,de
        ld      a,(hl)
        ld      (ix),a
        ROM_CALL(_putc)
        inc     b
        inc     ix
        jr      enter_name_loop
backup: xor     a
        cp      b
        jr      z,enter_name_loop
        dec     b
        dec     ix
        ld      (ix),32
        ld      hl,_curCol
        dec     (hl)
        ld      a,32
        ROM_CALL(_putc)
        dec     (hl)
        jr      enter_name_loop

chartable:
#ifndef __TI83__
        .db     "XTOJE."
        .db     ". WSNID!.ZVRMHC?"
        .db     ".YUQLGB#x~+PKFA|"
        .db     "@54321.~+"
#else
        .db     ":WRMH."
        .db     "..0VQLG!..ZUPKFC"
        .db     "..YTOJEBX.>SNIDA"
        .db     ".12345.."
#endif

;############## Sorry, no highscore

no_score:
        ld      hl,0
        ld      (_curRow),hl
        ld      hl,finalscore
        ROM_CALL(_puts)

        ld      de,$fc8d
        ld      hl,score
        call    display_number_bcd

        jp      wait_key

#ifdef __TI83__
finalscore:
        .db     "GAME OVER !!!!!!"
        .db     "Final Score:    "
        .db     "You did not get "
        .db     "a high score.   "
        .db     "Press ENTER to  "
        .db     "to continue.",0
high_msg:
        .db     "High Scores:    ",0
highscore_prompt:
        .db     "Enter your name:",0
#else
finalscore:
        .db     "----> GAME OVER <----"
        .db     "Your Final Score:    "
        .db     "You did not get a    "
        .db     "high score.  Press   "
        .db     "ENTER to continue.",0
high_msg:
        .db     "All-Time High Scores:",0
highscore_prompt:
        .db     "-> Enter Your Name <-",0
#endif
