****************************************************************************
****************************************************************************
**                                                               
**  Smiley's Adventure (Background rendering)
**
**  Copyright 2005 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**                  
**  Last updated July 2, 2005
**
****************************************************************************
****************************************************************************

Draw_Background:
        movem.l d3-d7/a2-a6,-(sp)

        move.w  x(a5),d2        ; Initialize for correct shift amounts
        move.w  d2,d6
        lsr.w   #1,d2
        bsr     Draw_Column_Init

        lea     map(a5),a0     ; A0 = start of fg map
        move.w  x(a5),d2
        lsr.w   #4,d2
        add.w   d2,a0
        move.w  y(a5),d2
        lsr.w   #4,d2
        move.w  fg_width(a5),d3
        mulu    d3,d2
        lea     smcdcl+2(pc),a3
        subq.w  #1,d3
        move.w  d3,(a3)
        add.w   d2,a0           ; A0 = starting position in fg map

        lea     map0(pc),a1     ; A1 = start of bg map
        move.w  x(a5),d2
        lsr.w   #5,d2
        add.w   d2,a1
        move.w  y(a5),d2
        lsr.w   #5,d2
        mulu    #BG_WIDTH,d2
        add.w   d2,a1           ; A1 = starting position in bg map

        move.w  y(a5),d0
        and.w   #15,d0          ; D0 = offset into starting fg tile
        moveq   #16,d2
        sub.w   d0,d2           ; D2 = lines remaining in starting fg tile
        add.w   d0,d0

        move.w  y(a5),d1
        lsr.w   #1,d1
        and.w   #15,d1          ; D1 = offset into starting fg tile
        moveq   #16,d3
        sub.w   d1,d3           ; D3 = lines remaining in starting bg tile
        add.w   d1,d1

        lea     (a5),a6
	moveq	#(SCR_WIDTH/16)-1,d7
Draw_Columns:
        movem.w d0-d3/d7,-(sp)
        moveq   #SCR_HEIGHT-1,d4

        moveq   #0,d5                   
        move.b  (a1)+,d5                ; d5 = left tile number           
        lsl.w   #5,d5                   ; d5 = left tile offset
        moveq   #0,d6
        move.b  (a1),d6                 ; d6 = right tile number
        lsl.w   #5,d6                   ; d6 = right tile offset
        lea     tiles0(pc),a3
        lea     0(a3,d6.w),a5           ; a5 = start of right tile
        add.w   d5,a3                   ; a3 = start of left tile
        add.w   d1,a3
        add.w   d1,a5

        moveq   #0,d5
        move.b  (a0)+,d5                ; d5 = left tile number           
        lsl.w   #6,d5                   ; d5 = left tile offset
        moveq   #0,d6
        move.b  (a0),d6                 ; d6 = right tile number
        lsl.w   #6,d6                   ; d6 = right tile offset
        lea     tiles1(pc),a2
        lea     0(a2,d6.w),a4           ; a4 = start of right tile
        add.w   d5,a2                   ; a2 = start of left tile
        add.w   d0,a2
        add.w   d0,a4

        movem.l a0/a1/a6,-(sp)
        bsr     Draw_Column_Loop
        movem.l (sp)+,a0/a1/a6
        lea     2(a6),a6

        movem.w (sp)+,d0-d3/d7
        dbra    d7,Draw_Columns
        movem.l (sp)+,d3-d7/a2-a6
        rts

******************************************** INITIALIZE COLUMN DRAWING
*
* D2 = X coordinate in background to begin drawing
* D6 = X coordinate in foreground to begin drawing
*
********

Draw_Column_Init:
        and.w   #15,d2
        lea     bg0(pc),a0
        lea     bg_shift(pc),a1
        bsr     Load_8_Bytes
        move.w  d6,d2
        and.w   #15,d2
        lea     fg0(pc),a0
        lea     fg_shift(pc),a1

******************************************** LOAD 20-BYTE TABLE FRAGMENT
*
* A0 = table
* A1 = destination
* D2 = index in table
*
********

Load_20_Bytes:
        mulu    #20,d2
        add.w   d2,a0
        move.l  (a0)+,(a1)+
        move.l  (a0)+,(a1)+
        move.l  (a0)+,(a1)+
        move.l  (a0)+,(a1)+
        move.l  (a0)+,(a1)+
        rts

******************************************** LOAD 10-BYTE TABLE FRAGMENT
*
* A0 = table
* A1 = destination
* D2 = index in table
*
********

Load_8_Bytes:
        lsl.w   #3,d2
        add.w   d2,a0
        move.l  (a0)+,(a1)+
        move.l  (a0)+,(a1)+
        rts

******************************************** COLUMN DRAWING LOOP
*
* D2 = # of lines left in foreground tile
* D3 = # of lines left in background tile
* D4 + 1 = # of columns left to draw
* A0 = position in foreground map
* A1 = position in background map
* A2 -> left foreground tile image
* A3 -> left background tile image
* A4 -> right foreground tile image
* A5 -> right background tile image
* A6 = pointer to column in first bitplane
*
********

Draw_Column_Loop:
        subq.w  #1,d3                   ; decrement remaining bg       
        bge.s   \nnb                    

        lea     BG_WIDTH-1(a1),a1       ; advance bg map position
        moveq   #0,d5                   
        move.b  (a1)+,d5                ; d5 = left tile number           
        lsl.w   #5,d5                   ; d5 = left tile offset
        moveq   #0,d6
        move.b  (a1),d6                 ; d6 = right tile number
        lsl.w   #5,d6                   ; d6 = right tile offset
        lea     tiles0(pc),a3
        lea     0(a3,d6.w),a5           ; a5 = start of right tile
        add.w   d5,a3                   ; a3 = start of left tile
        moveq   #15,d3
\nnb:

        subq.w  #1,d2                   ; decrement remaining fg       
        bge.s   nnf                    

smcdcl: lea     32-1(a0),a0             ; advance to next row
        moveq   #0,d5                   
        move.b  (a0)+,d5                ; d5 = left tile number           
        lsl.w   #6,d5                   ; d5 = left tile offset
        moveq   #0,d6
        move.b  (a0),d6                 ; d6 = right tile number
        lsl.w   #6,d6                   ; d6 = right tile offset
        lea     tiles1(pc),a2
        lea     0(a2,d6.w),a4           ; a5 = start of right tile
        add.w   d5,a2                   ; a3 = start of left tile
        moveq   #15,d2
nnf:

bg_shift:
        ds.w    4
fg_shift:
        ds.w    10

        and.w   d1,d6
        or.w    d0,d6
        move.w  d6,(a6)

        lea     SCR_WIDTH/8(a6),a6   ;10
        dbra    d4,Draw_Column_Loop     ;14
        rts    

*************************************** DATA LOADING ROUTINES
*
* Each of these is copied into the middle of the column drawing loop.
* The drawing initialization selects the ones with the correct shift
* amount.  Background routines put plane  in D6.
* Foreground routines put plane in D1, mask in D0.
*
********

BGL     MACRO
        move.w  (a5)+,d6
        swap    d6
        move.w  (a3)+,d6
        rol.l   #\1,d6                   ; D6 = bg plane 0
        ENDM

BGR     MACRO
        move.w  (a3)+,d6
        swap    d6
        move.w  (a5)+,d6
        lsr.l   #\1,d6
        ENDM

FGL     MACRO
        move.w  32(a4),d1
        swap    d1
        move.w  32(a2),d1
        rol.l   #\1,d1                   ; D1 = fg plane 1
        move.w  (a4)+,d0
        swap    d0
        move.w  (a2)+,d0
        rol.l   #\1,d0                   ; D0 = fg plane 0
        ENDM

FGR     MACRO
        move.w  32(a2),d1               ;12
        swap    d1                      ;4
        move.w  32(a4),d1               ;12
        lsr.l   #\1,d1                  ;8 + 2x
        move.w  (a2)+,d0                ;8
        swap    d0                      ;4
        move.w  (a4)+,d0                ;8
        lsr.l   #\1,d0                  ;8 + 2x
        ENDM

bg0:    move.w  (a3)+,d6
        nop        
        nop        
        nop

bg1:    BGL     1
        BGL     2
        BGL     3
        BGL     4
        BGL     5
        BGL     6
        BGL     7
        BGL     8
        BGR     7
        BGR     6 
        BGR     5 
        BGR     4 
        BGR     3 
        BGR     2 
        BGR     1 

fg0:    move.w  32(a2),d1
        move.w  (a2)+,d0
        nop
        nop
        nop
        nop
        nop
        nop
        nop

fg1:    FGL     1
        FGL     2
        FGL     3
        FGL     4
        FGL     5
        FGL     6
        FGL     7
        FGL     8
        FGR     7
        FGR     6 
        FGR     5 
        FGR     4 
        FGR     3 
        FGR     2 
        FGR     1 

   ; old routine
   ; OVER 146 + 2x + 2y per line --> 2336 + 32x + 32y per tile
   ; BACK 102 + 2x + 2y per line --> 1632 + 32x + 32y per tile
   ; MISC                             272
   ; TOTL                            4240 + 64x + 64y per tile
   ; AVAL                          < 5222             per tile

   ; new routine
   ; FTCH 128 + 4x + 4y per line --> 2048 + 64x + 64y per tile
   ; OTHR 100           per line --> 1600             per tile
   ; NEXT                             208
   ; TOTL                            3856 + 64x + 64y per tile

   ; newest routine
   ; FTCH  92 + 4x + 2y per line --> 1472 + 64x + 32y per tile
   ; OTHT  68                        1088             per tile
   ; NEXT                             208
   ; TOTL                            2768 + 64x + 32y per tile

******************************************** TILE DATA

BACKGROUND_WIDTH        equ     24
BACKGROUND_HEIGHT       equ     FG_HEIGHT
FOREGROUND_HEIGHT       equ     12
BG_WIDTH                equ     BACKGROUND_WIDTH

map0:   INCLUDE map0.i
tiles0: INCLUDE tiles0.i
tiles1: INCLUDE tiles1.i
