****************************************************************************
****************************************************************************
**                                                               
**  Smiley's Adventure (Collision check)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated December 20, 2001
**
****************************************************************************
****************************************************************************

******************************************** TEST FOR COLLISIONS
*
* This routine tests two objects for collisions.  It returns true
* if there is a collision, false otherwise.
*
* prototype:
* Test_Collisiion(int x1, int y1, int x2, int y2, int img1, int img2)
*                      4       6       8      10        12        14
*
* Widths are assumed to be 17 pixels, heights are taken from the
* image data.  This routine first does a bounding-box test, and
* if that overlaps, the actual image data is tested.
*
********

no_collision:
        moveq   #0,d0   
        rts     

	DC.B	'RIGHTHERE',0
	
Test_Collision:
	lea	sprite_table(pc),a0
	
        move.w  6(sp),d0		; D0 = Y1
        sub.w   10(sp),d0		; D0 = Y1 - Y2    
	move.w	d0,d2			; D2 = Y1 - Y2
	move.w	12(sp),d1
	move.w	0(a0,d1.w),d1
	add.w	0(a0,d1.w),d0		; D0 = Y1 - Y2 + H1
        blt.s   no_collision
	move.w	14(sp),d1
	move.w	0(a0,d1.w),d1
	sub.w	0(a0,d1.w),d2		; D2 = Y1 - Y2 - H2
	bgt.s	no_collision

	move.w	4(sp),d2		; D2 = X1
	sub.w	8(sp),d2		; D2 = X1 - X2
	cmp.w	#16,d2
	bgt.s	no_collision
	cmp.w	#-16,d2
	blt.s	no_collision

	move.w	14(sp),d1
	move.w	0(a0,d1.w),d1
	lea	0(a0,d1.w),a1		; A1 -> image 2
	move.w	12(sp),d1
	move.w	0(a0,d1.w),d1
	lea	0(a0,d1.w),a0		; A0 -> image 1

	move.w	6(sp),d0		; D0 = Y1
	sub.w	10(sp),d0		; D0 = Y1 - Y2
	bge.s	\ns
	exg	a0,a1			; ensure A1 image on top
	neg.w	d0			
	neg.w	d2
\ns:					; D0 = lines distance

	move.w	(a1)+,d1		; D1 = height of top image - 1
	sub.w	d0,d1			; D1 = overlap area - 1
	add.w	d0,d0
	add.w	d0,d0
	add.w	d0,a1			; A1 = start of compare area

        cmp.w   (a0)+,d1                ; overlap - lower object height
        ble.s   \ok                     ; skip if lower object tall enough
        move.w  -2(a0),d1               ; set overlap area to object height
\ok:

	tst.w	d2			; A1.x - A0.x
        blt.s   \a3right
        beq.s   \samex

\ll:    move.l  (a1)+,d0
	lsl.l	d2,d0
        and.l   (a0)+,d0
        bne.s   \rts
        dbra    d1,\ll
\rts:	rts

\a3right:
        neg.w   d2
\rl:    move.l  (a1)+,d0
	lsr.l	d2,d0
        and.l   (a0)+,d0
        bne.s   \rts
        dbra    d1,\rl
        rts

\samex: move.l  (a1)+,d0
        and.l   (a0)+,d0
        bne.s   \rts
        dbra    d1,\samex
        rts
