****************************************************************************
****************************************************************************
**                                                               
**  Absolute Annihilation for TI-68K (hardware-specific routines)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated December 12, 2004
**
****************************************************************************
****************************************************************************

Init_Screen:
        move.w  #$400,d0
        trap    #1

        move.l  $C8,d1                 ; Hardware check is based on example
        and.l   #$e00000,d1            ; code from Zeljko Juric
        move.l  d1,a1
        move.l  260(a1),a0
        move.l  a0,d2
        sub.l   d1,d2
        cmp.l   #$FFFF,d2
        bhi     hw1
        cmpi.w  #$16,(a0)
        bls     hw1
        move.l  $16(a0),d1
        subq.w  #1,d1
        beq     hw1

        trap    #12                     ; VTI check
        move.w  #$3000,sr
        move.w  sr,d1
        move.w  d0,sr
        btst    #12,d1
        bne     hw1

hw2:	move.b	#2,hw_version(a5)
	clr.b	old_frame(a5)
	move.b	#256-132,$600013
	rts

hw1:	move.b	#1,hw_version(a5)
	lea	hw1_interrupt(pc),a0
	move.l	a0,$74
	move.b	#257-54,$600017
	bsr	vwait_hw1
	bsr	vwait_hw1
	moveq	#15,d0
\w2:	dbra	d0,\w2	
	move.b	#256-144,$600013	; set screen height to 160
	rts

Wait_Vbl:
	cmp.b	#1,hw_version(a5)
	beq.s	vwait_hw1

vwait_hw2:
	move.b	old_frame(a5),d0
	lea	$70001d,a0
\we:	move.b	(a0),d1
	eor.b	d0,d1
	bmi.s	\we
\wne:	move.b	(a0),d1
	eor.b	d0,d1
	bpl.s	\wne
	move.b	(a0),old_frame(a5)
	rts

vwait_hw1:
	lea	hw1_count(pc),a0
\w:	tst.w	(a0)
	beq.s	\w
	clr.w	(a0)
	rts

hw1_count:
	dc.w	0

hw1_interrupt:
	addq.w	#1,hw1_count
	rte
	
	
	
