
****************************************************************************
****************************************************************************
**                                                               
**  AAA for TI-89 (Sprite Plotting Routine)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated December 20, 2001
**
****************************************************************************
****************************************************************************

;************************************** MASKING (D1,D3) over (A1)

MASKDRAW MACRO
	and.l	(a1),d3
	or.l	d1,d3
	move.l	d3,(a1)
        ENDM

MASKDRAWR MACRO
	and.w	(a1),d3
	or.w	d1,d3
	move.w	d3,(a1)
        ENDM

MASKDRAWL MACRO
        swap    d1
        swap    d3
        MASKDRAWR
        ENDM

;************************************** GRAYSCALE SPRITE ROUTINE

clip_top:
        move.w  d1,d2                   ;D2 = - # of lines skipped
        add.w   d4,d1                   ;D1 = # of lines to draw - 1
        blt     rts

        add.w   d2,d2
        add.w   d2,d2                   ;D2 = -4 * # of lines skipped
        sub.w   d2,a0                   ;A0 -> First used sprite data
        sub.w   d2,a2

        move.w  d1,d4
        move.l  a5,a1
        bra.s   y_offset_obtained

Masked_Sprite:
        move.w  (a0)+,d4                ;D4 = height in lines - 1
        move.w  d4,d2
        add.w   d2,d2
        add.w   d2,d2                   ;D2 = length of plane data - 4
        lea     4(a0,d2.w),a2           ;A2 -> second image

        tst.w   d1                      ;D1 = # of lines from top to start
        blt.s   clip_top
        move.w  d1,d3

        add.w   d4,d3
        sub.w   #SCR_HEIGHT-1,d3        ;D3 = # lines past bottom
        ble.s   clipped_vert
        sub.w   d3,d4
        blt     rts

clipped_vert:
        mulu    #SCR_WIDTH/8,d1         ;D1 = line's offset in buffer
        lea     0(a5,d1.w),a1           ;A1 -> start of line in buffer
y_offset_obtained:

        move.w  d0,d2
        and.w   #15,d0                  ;D0 = low 4 bits of X coordinate
        asr.w   #4,d2                   ;D2 = word offset in line
        blt     clip_left
        cmp.w   #SCR_WIDTH/16-1,d2
        bge     clip_right
        add.w   d2,d2                   ;D2 = byte offset in line       
        add.w   d2,a1                   ;A1 -> long image drawn at
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        move.l  (a2)+,d3
        rol.l   d0,d1   
        rol.l   d0,d3
        MASKDRAW
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\leftloop
\rts:   rts     
\cent:  move.l  (a0)+,d1
        move.l  (a2)+,d3
        MASKDRAW
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\cent
        rts

\right: move.l  (a0)+,d1
        move.l  (a2)+,d3
        ror.l   d0,d1
        ror.l   d0,d3
        MASKDRAW
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\right                
        rts     

clip_left:
        addq.w  #1,d2
        blt.s   \rts
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        move.l  (a2)+,d3
        rol.l   d0,d1   
        rol.l   d0,d3
        MASKDRAWR
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\leftloop
\rts:   rts

\cent:  move.l  (a0)+,d1
        move.l  (a2)+,d3
        MASKDRAWR
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\cent
        rts     

\right: move.l  (a0)+,d1
        move.l  (a2)+,d3
        ror.l   d0,d1
        ror.l   d0,d3
        MASKDRAWR
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\right                
        rts     

clip_right:
        bgt.s   \rts
        lea     SCR_WIDTH/8-2(a1),a1
        subq.w  #8,d0

        bgt.s   \right
        beq.s   \cent    

\left:  neg.w   d0      
\leftloop:
        move.l  (a0)+,d1
        move.l  (a2)+,d3
        rol.l   d0,d1   
        rol.l   d0,d3
        MASKDRAWL
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\leftloop
\rts:   rts

\cent:  move.l  (a0)+,d1
        move.l  (a2)+,d3
        MASKDRAWL
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\cent
        rts     

\right: move.l  (a0)+,d1
        move.l  (a2)+,d3
        ror.l   d0,d1
        ror.l   d0,d3
        MASKDRAWL
        lea     SCR_WIDTH/8(a1),a1       
        dbra    d4,\right                
rts:    rts

************************** DRAW SPRITE BY NUMBER

Draw_Sprite:
	move.w	4(sp),d0
	move.w	6(sp),d1
	move.w	8(sp),d2
	movem.l	d3-d4/a2,-(sp)
	move.w	sprite_table(pc,d2.w),d2
	lea	sprite_table(pc,d2.w),a0
	bsr	Masked_Sprite
	movem.l	(sp)+,d3-d4/a2
	rts

SPRITE	MACRO
	dc.w	\1-sprite_table
	ENDM

EXTSPR	MACRO
	dc.w	((.b\@-.a\@)>>3)-1
.a\@:	INCLUDE	\1
.b\@:
	ENDM

sprite_table:
	SPRITE	smile		* 0
	SPRITE	frown		* 2
	SPRITE	porcupine	* 4
	SPRITE	spider		* 6
	SPRITE	bird1		* 8
	SPRITE	bird2		* 10
	SPRITE	bird3		* 12 
	SPRITE	bird4		* 14
	SPRITE  bomb		* 16
	SPRITE	small		* 18
	SPRITE	bullet		* 20
	
smile:	dc.w	13
	dc.l	%00000000001111111111000000000000
	dc.l	%00000000010000000000100000000000
	dc.l	%00000000100110000110010000000000
	dc.l	%00000000101001001001010000000000
	dc.l	%00000000101001001001010000000000
	dc.l	%00000000100110000110010000000000
	dc.l	%00000000100000000000010000000000
	dc.l	%00000000100000000000010000000000
	dc.l	%00000000101000000001010000000000
	dc.l	%00000000100100000010010000000000
	dc.l	%00000000100011111100010000000000
	dc.l	%00000000100000000000010000000000
	dc.l	%00000000010000000000100000000000
	dc.l	%00000000001111111111000000000000

	dc.l	%11111111110000000000111111111111
	dc.l	%11111111100000000000011111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111100000000000011111111111
	dc.l	%11111111110000000000111111111111

frown:	dc.w	13
	dc.l	%00000000001111111111000000000000
	dc.l	%00000000010000000000100000000000
	dc.l	%00000000100100110001010000000000
	dc.l	%00000000100011001010010000000000
	dc.l	%00000000100001000100010000000000
	dc.l	%00000000100010101010010000000000
	dc.l	%00000000100100010001010000000000
	dc.l	%00000000100000000000010000000000
	dc.l	%00000000100000000000010000000000
	dc.l	%00000000100000000000010000000000
	dc.l	%00000000100011111100010000000000
	dc.l	%00000000100100000010010000000000
	dc.l	%00000000010000000000100000000000
	dc.l	%00000000001111111111000000000000

	dc.l	%11111111110000000000111111111111
	dc.l	%11111111100000000000011111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111000000000000001111111111
	dc.l	%11111111100000000000011111111111
	dc.l	%11111111110000000000111111111111

porcupine:
	dc.w	9
	dc.l	%00000000000000001000000000000000
	dc.l	%00000000000000001000000000000000
	dc.l	%00000000100000001000000010000000
	dc.l	%00000000010000011100000100000000
	dc.l	%00000000001001101011001000000000
	dc.l	%00000000000110001000110000000000
	dc.l	%00000000000110001001110000000000
	dc.l	%00000000000101000000010000000000
	dc.l	%00000000111111000001111110000000
	dc.l	%00000000000111111111110000000000

	dc.l	%11111111111111110111111111111111
	dc.l	%11111111111111110111111111111111
	dc.l	%11111111011111110111111101111111
	dc.l	%11111111101111100011111011111111
	dc.l	%11111111110110000000110111111111
	dc.l	%11111111111000000000001111111111
	dc.l	%11111111111000000000001111111111
	dc.l	%11111111111000000000001111111111
	dc.l	%11111111000000000000000001111111
	dc.l	%11111111111000000000001111111111

spider:
	dc.w	9
	dc.l	%00000000011110000001111000000000
	dc.l	%00000000011111000011111000000000
	dc.l	%00000000010011111111001000000000
	dc.l	%00000000110001000010001100000000
	dc.l	%00000000110001000010001100000000
	dc.l	%00000000110011000010001100000000
	dc.l	%00000000100111111111001100000000
	dc.l	%00000000101100011001100100000000
	dc.l	%00000000101100011001100100000000
	dc.l	%00000000101100011001100100000000

	dc.l	%11111111100001111110000111111111
	dc.l	%11111111100000111100000111111111
	dc.l	%11111111101100000000110111111111
	dc.l	%11111111001110000001110011111111
	dc.l	%11111111001110000001110011111111
	dc.l	%11111111001100000001110011111111
	dc.l	%11111111011000000000110011111111
	dc.l	%11111111010011100110011011111111
	dc.l	%11111111010011100110011011111111
	dc.l	%11111111010011100110011011111111
	
bird1:	EXTSPR	images\bird1.i
bird2:	EXTSPR	images\bird2.i
bird3:	EXTSPR	images\bird3.i
bird4:	EXTSPR	images\bird4.i
bomb:	EXTSPR	images\bomb.i
small:	EXTSPR	images\small.i
bullet:	EXTSPR	images\bullet.i