#include <stdio.h>

int outsize = 0;
int bit = 0;
unsigned out_byte = 0;
FILE *i, *o;
int total = 0;
int packed = 0;

void write_bit(int b)
{
    if (b)
        out_byte |= (1 << bit);
    bit++;
    if (bit == 8) {
        bit = 0;
        outsize++;
        fputc(out_byte, o);
        out_byte = 0;
    }
}

#define RUN 4

int process_level()
{
    int map[64*16+1];
    int size = 0;
    char c;
    int data, x, y, n, b;

    while (1) {
        c = fgetc(i);
        if (c == EOF)
            break;
        if (c == '$') {
            fscanf(i, "%xd", &data);
            map[size++] = data;
        }
        if (feof(i))
            break;
    }
    map[size++] = 32;

    for (x = 0; x < size; x++) {
        if (map[x] == 0) {
            write_bit(1);
            for (y = 0; map[x+y] == 0 && y < (1 << RUN); y++);
            x += y - 1;
            for (b = 1; b < (1<<RUN); b <<= 1)
                write_bit((y - 1) & b);
        } else {
            write_bit(0);
            for (b = 1; b < (1<<5); b <<= 1)
                write_bit(map[x] & b);
        }
    }

    total += size - 1;
}

int main(int argc, char **argv)
{
    char inname[500], outname[500];
    char header[] = {0x2c, 0x0d, 0, 2, 0, 0,
                   0,0,0,0,0,0,0,0,0,0,
                   0,0};
    int x;

    if (argc < 2) {
        printf("not enough arguments\n");
        return 0;
    }

    strcpy(outname, argv[1]);
    strcat(outname, ".bin");

    o = fopen(outname, "wb");
    if (o == NULL)
        return 420;

    for (x = 0; x < 10; x++) {
        if (argv[1][x] == 0) break;
        header[x + 6] = argv[1][x];
    }

    fwrite(header, sizeof(header), 1, o);

    for (x = 1; x < 255; x++) {
        sprintf(inname, "%s\\%d.asm", argv[1], x);
        i = fopen(inname, "r");
        if (i == NULL) break;
        process_level();
        fclose(i);
    }

    if (bit != 0) {
        fputc(out_byte, o);
        outsize++;
    }

    printf("%d levels - total size %d - packed to %d bytes\n", x-1, total, outsize);

    fseek(o, 5, SEEK_SET);
    fputc(x - 1, o);
    fclose(o);

    return 0;
}
