****************************************************************************
****************************************************************************
**                                                               
**  Absolute Annihilation for TI-89 (Basic "library" routines)
**
**  Copyright 2001 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@calc.org, http://pad.calc.org/)
**
**  Last updated December 8, 2001
**
****************************************************************************
****************************************************************************

******************************************** READ ALL KEYS
*
* Reads all keys by hardware and places their values in the key_data buffer.
* Keypresses occuring on this read are indicated in the key_edge buffer.
*
********

Read_All_Keys:
	move.w	d3,-(sp)
    IFD ti89
        moveq   #7,d0
    ENDIF
    IFD ti92plus
        moveq   #9,d0
    ENDIF
        lea     key_data(a5),a0
        moveq   #-2,d2
read_keys_loop:
        move.w  d2,$600018
        moveq   #34,d1
rkl_waste_time:
        dbra    d1,rkl_waste_time
        move.b  (a0),d3                         ; D3 = old key data
        move.b  $60001b,d1                      ; D4 = new key data
        move.b  d1,(a0)+
        move.b  d3,9(a0)
        not.b   d3
        or.b    d1,d3                           ; 0 = - edge (key down)
        move.b  d3,19(a0)

        rol.w   #1,d2
        dbra    d0,read_keys_loop
	move.w	(sp)+,d3
        rts

Wait_No_Key:
        move.w  #0,$600018
        move.w  #200,d0
\loop:  dbra    d0,\loop
Wait_No_Key_Loop:
        MOVE.B  $60001b,D0
        not.b   d0
        bne.s   Wait_No_Key_Loop
        RTS     

******************************* CONTRAST ADJUSTMENT

Contrast_Up:
	movem.l	d3-d4,-(sp)
	JSR_ROM	OSContrastUp
	movem.l (sp)+,d3-d4
	rts

Contrast_Down:	
	movem.l	d3-d4,-(sp)
	JSR_ROM	OSContrastDn
	movem.l (sp)+,d3-d4
	rts	