/* Smiley's Adventure - Data structure defintions

   This software is in the public domain.  There is no warranty.

   by Patrick Davidson pad@ocf.berkeley.edu http://www.ocf.berkeley.edu/~pad/

   Last updated August 20, 2011 */

/* level size */

#define FG_HEIGHT 16
#define MAP_SIZE FG_HEIGHT*64
#define MAX_SPECIALS 30
#define MAX_CREATURES 17
#define MAX_BULLETS 15

/* screen size */

#ifdef __TI89__
#define USE_TI89
#define SCR_WIDTH 160
#define SCR_HEIGHT 100
#else
#define USE_TI92PLUS
#define USE_V200
#define SCR_WIDTH 240
#define SCR_HEIGHT 128
#endif

#define PLANE_SIZE (SCR_WIDTH*SCR_HEIGHT>>3)

/* special tile data structure */

typedef struct {
  int type;
  int x;
  int y;
} special;

/* creature data structure */

typedef struct {
  int type;
  int x;
  int y;
  int dir;
} creature;

/* bullet data structure */

typedef struct {
  int type;
  int x;
  int y;
} bullet;

/* main game data strucure */

typedef struct {
  char s[PLANE_SIZE];
  char *maps_pointer;
  int *tiles_pointer;
  int num_maps;
  char key_data[10];
  char old_keys[10];
  char key_edge[10];
  char *ptr;
  int dat; 

  int fg_width;
  int maps_type;
  char map[MAP_SIZE];
  int x;
  int y;
  int pstatus;
  int pimage;
  int px;
  int py;
  int yv;
  char old_frame;
  char hw_version;
  special specials[MAX_SPECIALS];
  int has_key;
  creature creatures[MAX_CREATURES];
  int level;
  int timer;
  int frame3;
  int destx;
  int desty;
  int lives;
  bullet bullets[MAX_BULLETS];
  int shots_remaining;
  int flying;
  char *eof;
} game_data;

/* assembly functions */

void Draw_Background(void);
void Display_Screen(void);
void Read_All_Keys(void);
void Draw_Sprite(int x, int y, int n);
void Contrast_Up(void);
void Contrast_Down(void);
void Wait_Vbl(void);
long Test_Collision(int x1, int y1, int x2, int y2, int img1, int img2);

/* key testing */

#ifdef __TI89__
#define GETEDGE(row89,col89,row92,col92) (!(w->key_edge[row89]&(1<<col89)))
#else
#define GETEDGE(row89,col89,row92,col92) (!(w->key_edge[row92]&(1<<col92)))
#endif

#ifdef __TI89__
#define GETKEY(row89,col89,row92,col92) (!(w->key_data[row89]&(1<<col89)))
#else
#define GETKEY(row89,col89,row92,col92) (!(w->key_data[row92]&(1<<col92)))
#endif

/* tile types */

#define TILE_EMPTY 0
#define TILE_LADDER 1
#define TILE_LADDERBRICK 2
#define TILE_SOLID1 3
#define TILE_SOLID2 4
#define TILE_SOLID3 5
#define TILE_LADDERTOP 6
#define TILE_SOLID4 7
#define TILE_EXIT 8
#define TILE_ARC1 9
#define TILE_ARC2 10
#define TILE_ARC3 11
#define TILE_PORCUPINE 12
#define TILE_KEY 13
#define TILE_DOOR 14
#define TILE_TELEPORTIN 15
#define TILE_TELEPORTOUT 16
#define TILE_SPIDER 17
#define TILE_BIRD 18
#define TILE_GUN 19
#define TILE_LIFE 20
#define TILE_BREAKABLE 21
#define TILE_SPRING 22
#define TILE_CANNON 23
#define TILE_VARC1 24
#define TILE_VARC2 25
#define TILE_VARC3 26
#define TILE_MAX 26
#define TILE_BREAKING 32
#define TILE_TAKENGUN 33
#define TILE_BROKEN 34

/* creature types */

#define CREATURE_NONE 0
#define CREATURE_PORCUPINE 1
#define CREATURE_SPIDER 2
#define CREATURE_BIRD 3
#define CREATURE_BOMB 4

/* bullet types */

#define BULLET_NONE 0
#define BULLET_LEFT 1
#define BULLET_RIGHT 2
