****************************************************************************
****************************************************************************
**                                                               
**  Smiley's Adventure - Data Structure Definitons
**
**  Copyright 2011 by Patrick Davidson.  This software may be freely
**  modified and/or copied with no restrictions.  There is no warranty.
**
**  by Patrick Davidson (pad@ocf.berkeley.edu, www.ocf.berkeley.edu/~pad)
**
**  Last updated August 20, 2011
**
****************************************************************************
****************************************************************************

FG_HEIGHT	equ	16

	IFD	ti89
SCR_WIDTH	equ	160
SCR_HEIGHT	equ	100
	ENDIF
	IFND	ti89
SCR_WIDTH	equ	240
SCR_HEIGHT	equ	128
	ENDIF

PLANE_SIZE	equ	SCR_WIDTH*SCR_HEIGHT/8

MAX_CREATURES   equ     17
MAX_BULLETS	equ	15
MAX_SPECIALS    equ     30

******************************************** MAIN VARIABLES
*
* This defines the game's main variables.  The 'rs' macro reserves the
* specified amount of space by incrementing the offset counter.  Overall,
* this section serves to calculate the offsets of each variable.  This
* system allows variables to be easily added, removed, or resized, as the
* offsets themselves are not hard-coded.  Near the bottom, data_end is
* defined with a size of zero to set that equal to the length of the data
* so far.  At the end, 'offset' is the total size of all this data.
*
********

offset  set     0       

rs      MACRO   
\1      set     offset  
offset  set     offset+\2       
        ENDM    

        rs  	s,PLANE_SIZE           ; Screen buffer
	rs	maps_pointer,4
	rs	tiles_pointer,4
	rs	num_maps,2

        rs      key_data,10
        rs      old_keys,10
        rs      key_edge,10

        rs      scratch_pointer,4
        rs      scratch_data,2

        rs      data_start,0

        rs      fg_width,2
        rs      maps_type,2
        rs      map,64*FG_HEIGHT
        rs      x,2
        rs      y,2
	rs	status,2
	rs	image,2
	rs	px,2
	rs	py,2
	rs	yv,2
	rs	old_frame,1
	rs	hw_version,1
	rs	specials,MAX_SPECIALS*6
	rs	has_key,2
	rs	creatures,MAX_CREATURES*8
	rs	level,2
	rs	timer,2
	rs	frame3,2
	rs	destx,2
	rs	desty,2
	rs	lives,2
	rs	bullets,MAX_BULLETS*6
	rs	shots_remaining,2
        rs      flying,2
        rs      eof,4

        rs      data_end,0

*************************************** HARDWARE KEY READING
*
* This macro tests a key, using data from the last call to Read_All_Keys.
* Its syntax is
*
* GETKEY row89,column89,row92,column92
*
* The zero flag is set if it is pressed, and clear otherwise.
*
* A5 must be pointing to the game's data structures.
*
********

GETKEY  MACRO
    IFD ti89
        btst    #\2,key_data+\1(a5)
    ENDIF
    IFD ti92plus
        btst    #\4,key_data+\3(a5)
    ENDIF
        ENDM

GETEDGE  MACRO
    IFD ti89
        btst    #\2,key_edge+\1(a5)
    ENDIF
    IFD ti92plus
        btst    #\4,key_edge+\3(a5)
    ENDIF
        ENDM

*************************************** ROM CALLING FUNCTIONS

JMP_ROM MACRO
        move.l  (200).w,a0
        move.l  \1*4(a0),a0
        jmp     (a0)
        ENDM

JSR_ROM MACRO
        move.l  (200).w,a0
        move.l  \1*4(a0),a0
        jsr     (a0)
        ENDM

************************************** EXPORTED FUNCTIONS

	XDEF	Read_All_Keys
	XDEF	Display_Screen
	XDEF	Draw_Background
	XDEF	Draw_Sprite
	XDEF	Contrast_Up
	XDEF	Contrast_Down
	XDEF	Wait_Vbl
	XDEF	Test_Collision
