;##################################################################
;
;   ZMercury (player bullets)
;                                                                     
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 13, 2011.
;
;##################################################################     

player_shoot:
        ld      a,(weapon_upgrade)
        or      a
        jr      z,normal_shoot

        ld      hl,bonus_count          ; count down on bonus shot limit
        dec     (hl)
        jr      nz,continue_bonus_weapon
        xor     a
        ld      (weapon_upgrade),a
        jr      normal_shoot

continue_bonus_weapon:
        dec     a
        jr      z,double_shoot

        ld      de,top_bulletc
        call    shoot_de
        ld      de,bottom_bulletc
        jr      shoot_de

double_shoot:
        ld      de,top_bullet
        call    shoot_de
        ld      de,bottom_bullet
        jr      shoot_de

normal_bullet:
        .db     4,8,4,4,3               ; type, width, deltay, height, damage
        .dw     img_bullet1
top_bullet:
        .db     7,8,0,2,4
        .dw     img_ebullet2
bottom_bullet:              
        .db     7,8,10,2,4
        .dw     img_ebullet2
top_bulletc:
        .db     %10000001,8,0,3,5
        .dw     img_bulletd
bottom_bulletc:              
        .db     %11111111,8,10,3,5
        .dw     img_bulletu

normal_shoot:
        ld      de,normal_bullet
shoot_de:
        ld      hl,player_bullets
        ld      b,pb_num
loop_spb:
        ld      a,(hl)
        or      a
        jr      z,found
        ld      a,pb_size
        call    ADD_HL_A
        djnz    loop_spb
        ret

found:  ex      de,hl
        ldi
        ld      a,(player_x)
        add     a,2
        ld      (de),a
        inc     de
        ldi
        ld      a,(player_y)
        ld      b,a
        ld      a,(hl)
        inc     hl
        add     a,b
        ld      (de),a
        inc     de
        ld      bc,4
        ldir
        ret

handle_player_bullets:
        ld      hl,player_bullets
        ld      b,pb_num
loop_hpb:
        ld      a,(hl)
        or      a
        jr      z,npb
        push    hl
        inc     hl                      ; HL -> X

        ld      c,0                     ; provisional delta Y
        add     a,a                     ; overflows if not diagonal
        jr      nc,not_diagonal
        ld      c,a                     ; set actual delta Y (2 or -2)
        ld      a,8                     ; assuming dX = 8 for diagonal

not_diagonal:
        add     a,(hl)                  ; add dX and kill if offscreen
        cp      136
        jr      nc,pbk
        ld      (hl),a
        ld      d,a                     ; D = new Y

        inc     hl
        inc     hl
        ld      a,c
        add     a,(hl)                  ; A = new Y
        ld      (hl),a
        cp      MIN_Y-3
        jr      c,pbk                   ; kill if above top
        cp      MAX_Y
        jr      nc,pbk                  ; kill if below bottowm
        ld      e,a                     ; E = new Y

        inc     hl                      ; get image pointer in HL
        inc     hl
        inc     hl
        ld      c,(hl)
        inc     hl
        ld      a,(hl)
        ld      l,c
        ld      h,a
        push    bc
        call    drw_spr
        pop     bc
        pop     hl

npb:    ld      de,pb_size              ; go to next bullet
        add     hl,de
        djnz    loop_hpb
        ret

pbk:    pop     hl                      ; kill this bullet
        ld      (hl),0
        jr      npb
