;##################################################################
;
;   ZMercury (enemy entry routines)
;                                                                     
;   Programmed by Patrick Davidson (pad@ocf.berkeley.edu)
;        
;   Copyright 2011 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated August 1, 2011.
;
;##################################################################     

;############## Insert enemies of type A

enemy_entry:
        ex      de,hl
        dec     a
        add     a,a
        ld      hl,entry_table
        call    ADD_HL_A
        call    DO_LD_HL_MHL
        jp      (hl)

entry_table:
        .dw     entry_1
        .dw     entry_2
        .dw     entry_3
        .dw     enter_open_space
        .dw     entry_5
        .dw     entry_6
        .dw     entry_7
        .dw     entry_8

;############## Enter open space (no movement until 0 enemies left)

enter_open_space:
        ld      (game_status),a
        ret

;############## Find empty enemy
;
; Returns pointer to empty enemy in HL, trashes all other registers
; Zero flag set for success (caller must check)

find_empty_enemy:
        ld      hl,e_array
        ld      de,e_size
        ld      b,e_num
loop_find_ee:
        ld      a,(hl)
        or      a
        jr      z,found_ee
        add     hl,de
        djnz    loop_find_ee
found_ee:
        ret

;############## Simple wave of enemies

entry_1:
        ld      hl,template_1
        jr      install_enemy_data

template_1:
        .db     3,0,9,0
        .db     4,136,8,50,8,3
        .dw     img_enemy1
        
;############## Wave of phoenixs

entry_2:
        ld      hl,template_2
        jr      install_enemy_data

template_2:
        .db     3,8,15,0
        .db     7,135,8,50,12,9
        .dw     img_enemy2

;############## Spinning sines

entry_3:
        ld      hl,template_3
        ld      (hl),4
        jr      install_enemy_data

template_3:
        .db     4,10,15,10
        .db     10,138,8,1,8,15
        .dw     img_spin1
        .db     40,138
        
;############## Tough spinning sines

entry_8:
        ld      hl,template_8
        jr      install_enemy_data
template_8:
        .db     4,10,15,10
        .db     22,138,8,1,8,25
        .dw     img_spin1b
        .db     40,138

;############## Partial spinning sines

entry_6:
        ld      hl,template_3
        ld      (hl),2
        jr      install_enemy_data

;############## Spinning attack in narrow wave

entry_7:
        ld      hl,template_7b
        call    install_enemy_data
        ld      hl,template_7
        jr      install_enemy_data

template_7:
        .db     3,10,15,10
        .db     16,138,8,1,8,18
        .dw     img_spint1
        .db     40,138

template_7b:
        .db     1,0,0,0
        .db     19,138,40,8,16,50
        .dw     img_boss
        .db     -44

;############## Install enemies according to data
;
; Data format is .db count, X-step, Y-step, phase-step followed by the template:
; type, X, width (40 for >8 sprite), Y, height, damage, image (pointer), phase

install_enemy_data:             
        ld      a,(hl)                  ; read count
        inc     hl
        ld      (data_address),hl       ; save pointer to offsets
        inc     hl
        inc     hl
        inc     hl
        ld      de,temp_enemy           ; copy template
        ld      bc,e_size
        ldir

        ld      b,a
loop_ied:
        push    bc
        call    find_empty_enemy        ; find empty enemy
        jr      nz,ied_failed

        ex      de,hl                   ; copy template to it
        ld      hl,temp_enemy
        ld      bc,e_size
        ldir

        ld      de,(data_address)       ; adjust X
        ld      a,(de)
        ld      hl,temp_enemy+e_x
        add     a,(hl)
        ld      (hl),a

        inc     de                      ; adjust Y
        ld      a,(de)
        inc     hl
        inc     hl
        add     a,(hl)
        ld      (hl),a
        
        inc     hl                      ; adjust toughness
        inc     hl
        ld      a,(difficulty_level)
        add     a,(hl)
        ld      (hl),a

        inc     de                      ; adjust phase
        ld      a,(de)
        ld      hl,temp_enemy+e_phase
        add     a,(hl)
        ld      (hl),a
ied_failed:
        pop     bc
        djnz    loop_ied
        ret

install_single_enemy:
        call    find_empty_enemy
        ret     nz

;############## Base enemy

entry_5:
        ld      hl,-TERRAIN_WIDTH
        ex      de,hl
        ld      b,8
        ld      a,10

loop_search_block:
        add     hl,de
        cp      (hl)
        jr      z,found_block
        djnz    loop_search_block
        ret

found_block:
        ld      a,b
        add     a,a
        add     a,a
        add     a,a
        add     a,MIN_Y-11
        ld      (template_5+3),a

        call    find_empty_enemy
        ret     nz
        ex      de,hl
        ld      hl,template_5
        ld      bc,e_size
        ldir
        ret

template_5:
        .db     13,137,8,40,8,45
        .dw     img_base
