;##################################################################
;
;   ZMercury (enemy firing routines)
;                                                                     
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   Copyright 2004 by Patrick Davidson.  This software may be freely
;   modified and/or copied with no restrictions.  There is no warranty.
;
;   This file was last updated February 24, 2004.
;
;##################################################################     

;############## Normal firing (HL -> enemy X, B = Y offset, DE -> image)

enemy_fire_normal:
        push    de
        push    bc
        push    hl
        call    find_empty_enemy_bullet
        pop     de
        jr      nz,efn_quit
        ld      (hl),$04
        inc     hl
        ld      a,(de)
        ld      (hl),a
        inc     hl
        inc     de
        inc     de
        ld      (hl),4
        inc     hl
        ld      a,(de)
        pop     bc
        add     a,b
        ld      (hl),a
        inc     hl
        ld      (hl),4
        inc     hl
        ld      (hl),5
        inc     hl
        pop     bc
        ld      (hl),c                          
        inc     hl
        ld      (hl),b
        xor     a
        ret

efn_quit:
        pop     hl
        pop     hl
        ret

;############## Aim at player (HL -> ebimage + 1)

enemy_bullet_aim:
        ld      de,(player_y)           ; E = Y, Y = X
        dec     hl
        dec     hl
        dec     hl
        dec     hl
        ld      a,(hl)
        sub     e                     
        sub     5                       ; A = deltaY
        ld      b,a                     ; B = deltaY
        dec     hl
        dec     hl   
        ld      a,(hl)
        sub     d                       ; B = deltaX
        ret     c                       ; exit if to left of player
        srl     a
        srl     a
        dec     hl                      ; HL -> type

        bit     7,b
        jr      z,test_aim_up

test_aim_down:
        add     a,b                     ; A = deltaX - |deltaY|
        ret     p
        ld      (hl),$14
        ret

test_aim_up:
        cp      b
        ret     nc
        ld      (hl),$f4
        ret   

;############## Find empty enemy bullet
;
; Returns pointer to empty enemy bullet in HL
; Preserves BC, trashes all other registers
; Zero flag set for success (caller must check)

find_empty_enemy_bullet:
        push    bc
        ld      hl,enemy_bullets
        ld      de,eb_size
        ld      b,eb_num
loop_find_eb:
        ld      a,(hl)
        or      a
        jr      z,found_eb
        add     hl,de
        djnz    loop_find_eb
found_eb:
        pop     bc
        ret
